unit DataRdRecReserveDvdR;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  DVD݊[h                                                           //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdrItemMode = (dmOff,dmMain,dmSub);
const
  TDataRdRecReserveDvdrItemModeStr     : array[0..2] of string = ('OFF','Main','Sub');

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdrItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveDvdrItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveDvdrItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdrItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveDvdrItem;
    function GetModes(
      Mode: TDataRdRecReserveDvdrItemMode): TDataRdRecReserveDvdrItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveDvdrItems) ;
    function Add() : TDataRdRecReserveDvdrItem;
    property Items[Index: Integer] : TDataRdRecReserveDvdrItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveDvdrItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveDvdrItemMode) : string;
    property Modes[Mode : TDataRdRecReserveDvdrItemMode] : TDataRdRecReserveDvdrItem read GetModes;

  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdr = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveDvdrItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveDvdrItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToDvdrMode(const str : string) : TDataRdRecReserveDvdrItemMode;
  function DvdrModeToStr(const Mode : TDataRdRecReserveDvdrItemMode) : string;

implementation

{ TDataRdRecReserveDvdr }

constructor TDataRdRecReserveDvdr.Create;
begin
  FItems := TDataRdRecReserveDvdrItems.Create;
end;

destructor TDataRdRecReserveDvdr.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveDvdr.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveDvdr;
begin
  if Source is TDataRdRecReserveDvdr then begin
    a := TDataRdRecReserveDvdr(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveDvdr.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveDvdrItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveDvdr.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveDvdrItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveDvdrItems }

function TDataRdRecReserveDvdrItems.Add: TDataRdRecReserveDvdrItem;
var
  d : TDataRdRecReserveDvdrItem;
begin
  d := TDataRdRecReserveDvdrItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveDvdrItems.Assign(a: TDataRdRecReserveDvdrItems);
var
  d : TDataRdRecReserveDvdrItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveDvdrItems.GetItems(
  Index: Integer): TDataRdRecReserveDvdrItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveDvdrItems.GetModes(
  Mode: TDataRdRecReserveDvdrItemMode): TDataRdRecReserveDvdrItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveDvdrItems.IndexOfMode(
  Mode: TDataRdRecReserveDvdrItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveDvdrItems.ModeToValue(
  Mode: TDataRdRecReserveDvdrItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveDvdrItem }

procedure TDataRdRecReserveDvdrItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveDvdrItem;
begin
  if Source is TDataRdRecReserveDvdrItem then begin
    a := TDataRdRecReserveDvdrItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveDvdrItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveDvdrItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveDvdrItem.GetModeStr: string;
begin
  result := DvdrModeToStr(FMode);
end;

procedure TDataRdRecReserveDvdrItem.SetModeStr(const Value: string);
begin
  FMode := StrToDvdrMode(Value);
end;

function StrToDvdrMode(const str : string) : TDataRdRecReserveDvdrItemMode;
var
  i : Integer;
begin
  result := dmOff;
  for i := 0 to High(TDataRdRecReserveDvdrItemModeStr) do begin
    if TDataRdRecReserveDvdrItemModeStr[i] = str then begin
      result := TDataRdRecReserveDvdrItemMode(i);
      break;
    end;
  end;
end;

function DvdrModeToStr(const Mode : TDataRdRecReserveDvdrItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveDvdrItemModeStr[i];
end;

end.
