unit DataRdRecReserveDvdChapter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  L^fBA                                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdChapterItemMode = (rdcOff,rdc5,rdc10,rdc15,rdc20);

const
  TDataRdRecReserveDvdChapterItemModeStr : array[0..4] of string = ('OFF','5','10','15','20');
//--------------------------------------------------------------------------//
//  RDgpłL^fBANX                                        //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdChapterItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveDvdChapterItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveDvdChapterItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpłL^fBAꗗǗNX                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdChapterItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveDvdChapterItem;
    function GetModes(
      Mode: TDataRdRecReserveDvdChapterItemMode): TDataRdRecReserveDvdChapterItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveDvdChapterItems);
    function Add() : TDataRdRecReserveDvdChapterItem;
    property Items[Index: Integer] : TDataRdRecReserveDvdChapterItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveDvdChapterItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveDvdChapterItemMode) : string;
    property Modes[Mode : TDataRdRecReserveDvdChapterItemMode] : TDataRdRecReserveDvdChapterItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDvdChapter = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveDvdChapterItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveDvdChapterItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToDvdChapterMode(const str : string) : TDataRdRecReserveDvdChapterItemMode;
  function DvdChapterModeToStr(const Mode : TDataRdRecReserveDvdChapterItemMode) : string;

implementation

{ TDataRdRecReserveMedia }

constructor TDataRdRecReserveDvdChapter.Create;
begin
  FItems := TDataRdRecReserveDvdChapterItems.Create;
end;

destructor TDataRdRecReserveDvdChapter.Destroy;
begin
  FItems.Free;
  inherited;
end;
procedure TDataRdRecReserveDvdChapter.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveDvdChapter;
begin
  if Source is TDataRdRecReserveDvdChapter then begin
    a := TDataRdRecReserveDvdChapter(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveDvdChapter.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveDvdChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveDvdChapter.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveDvdChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;


{ TDataRdRecReserveMediaItems }

function TDataRdRecReserveDvdChapterItems.Add: TDataRdRecReserveDvdChapterItem;
var
  d : TDataRdRecReserveDvdChapterItem;
begin
  d := TDataRdRecReserveDvdChapterItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveDvdChapterItems.Assign(
  a: TDataRdRecReserveDvdChapterItems);
var
  d : TDataRdRecReserveDvdChapterItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveDvdChapterItems.GetItems(
  Index: Integer): TDataRdRecReserveDvdChapterItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveDvdChapterItems.GetModes(
  Mode: TDataRdRecReserveDvdChapterItemMode): TDataRdRecReserveDvdChapterItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveDvdChapterItems.IndexOfMode(
  Mode: TDataRdRecReserveDvdChapterItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveDvdChapterItems.ModeToValue(
  Mode: TDataRdRecReserveDvdChapterItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveMediaItem }

procedure TDataRdRecReserveDvdChapterItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveDvdChapterItem;
begin
  if Source is TDataRdRecReserveDvdChapterItem then begin
    a := TDataRdRecReserveDvdChapterItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveDvdChapterItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveDvdChapterItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveDvdChapterItem.GetModeStr: string;
begin
  result := DvdChapterModeToStr(FMode);
end;

procedure TDataRdRecReserveDvdChapterItem.SetModeStr(const Value: string);
begin
  FMode := StrToDvdChapterMode(Value);
end;

function StrToDvdChapterMode(const str : string) : TDataRdRecReserveDvdChapterItemMode;
var
  i : Integer;
begin
  result := rdcOff;
  for i := 0 to High(TDataRdRecReserveDvdChapterItemModeStr) do begin
    if TDataRdRecReserveDvdChapterItemModeStr[i] = str then begin
      result := TDataRdRecReserveDvdChapterItemMode(i);
      break;
    end;
  end;
end;

function DvdChapterModeToStr(const Mode : TDataRdRecReserveDvdChapterItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveDvdChapterItemModeStr[i];
end;

end.
