unit DataRdRecReserveDateTime;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus;

//--------------------------------------------------------------------------//
//  ^t                                                                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDateTimeMode = (rrrdNormal,rrrdWeekSun,rrrdWeekMon,rrrdWeekTue,rrrdWeekWed,
                                   rrrdWeekThu,rrrdWeekFri,rrrdWeekSat,rrrdAllDay,rrrdMonThu,
                                   rrrdMonFri,rrrdMonSat);
type
  TDataRdRecReserveDateTimeEx = class(TDateTimeCtrl)
  private
    { Private 錾 }
    FOwner : TObject;
    FWeeks : array[1..7] of Boolean;
    FMode: TDataRdRecReserveDateTimeMode;
    FOnWeekCheck: TNotifyEvent;
    function GetWeeks(Index: Integer): Boolean;
    procedure SetMode(const Value: TDataRdRecReserveDateTimeMode);
    procedure DoWeekCheck();
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    function CheckDayWeek(d : TDateTimeCtrl) : Boolean;
    function StrFormat(const FormatStr : string) : string;

    property Mode : TDataRdRecReserveDateTimeMode read FMode write SetMode;
    property Weeks[Index : Integer] : Boolean read GetWeeks;
    property OnWeekCheck : TNotifyEvent read FOnWeekCheck write FOnWeekCheck;
  end;

//--------------------------------------------------------------------------//
//  RD̘^\Ŏgpt^                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDateTimeItem = class(TPersistent)
  private
    { Private 錾 }
    FStart : TDataRdRecReserveDateTimeEx;
    FStop : TDataRdRecReserveDateTimeEx;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    function CheckOverlap(aStart,aStop : TDateTimeCtrl) : Boolean;

    property Start : TDataRdRecReserveDateTimeEx read FStart;
    property Stop : TDataRdRecReserveDateTimeEx read FStop;
  end;

//--------------------------------------------------------------------------//
//  RD̘^\etŕƂ̈ꗗNX                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDateTimeItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveDateTimeItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TDataRdRecReserveDateTimeItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataRdRecReserveDateTimeItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  RD̘^\Ŏgpt^                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveDateTime = class(TPersistent)
  private
    { Private 錾 }
    FStart : TDataRdRecReserveDateTimeEx;
    FStop : TDataRdRecReserveDateTimeEx;
    FItems : TDataRdRecReserveDateTimeItems;
    procedure OnWeekCheck(Sender: TObject);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    procedure MakeList(aStart,aStop : TDateTimeCtrl);
    property Start : TDataRdRecReserveDateTimeEx read FStart;
    property Stop : TDataRdRecReserveDateTimeEx read FStop;
    property Items : TDataRdRecReserveDateTimeItems read FItems;
  end;

implementation

{ TDataRdRecReserveDateTime }

constructor TDataRdRecReserveDateTime.Create;
begin
  FStart := TDataRdRecReserveDateTimeEx.Create;
  FStart.FOwner := Self;
  FStop := TDataRdRecReserveDateTimeEx.Create;
  FStop.FOwner := Self;
  FStop.OnWeekCheck := OnWeekCheck;
  FItems := TDataRdRecReserveDateTimeItems.Create;
end;

destructor TDataRdRecReserveDateTime.Destroy;
begin
  FItems.Free;
  FStop.Free;
  FStart.Free;
  inherited;
end;

procedure TDataRdRecReserveDateTime.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveDateTime;
begin
  if Source is TDataRdRecReserveDateTime then begin
    a := TDataRdRecReserveDateTime(Source);
    FStart.Assign(a.FStart);
    FStop.Assign(a.FStop);
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^ǂݍ݁@`                                                  //
//                                                                          //
//   - Input -  t : f[^ǂݍޕ񃊃Xg                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataRdRecReserveDateTime.DataLoad(t: TStringListEx): Boolean;
var
  s : string;
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    s := t.GetStrs('DateTimeStart','');                         // ^Jn
    t2.CommaTextEx := s;
    FStart.DataLoad(t2);

    s := t.GetStrs('DateTimeStop','');                         // ^Jn
    t2.CommaTextEx := s;
    FStop.DataLoad(t2);

  finally
    t2.Free;
  end;


  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^݁@`                                                  //
//                                                                          //
//   - Input -  t : f[^ޕ񃊃Xg                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataRdRecReserveDateTime.DataSave(t: TStringListEx): Boolean;
var
  s : string;
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    FStart.DataSave(t2);
    s := t2.CommaTextEx;
    t.SetStrs('DateTimeStart',s);                         // ^Jn

    FStop.DataSave(t2);
    s := t2.CommaTextEx;
    t.SetStrs('DateTimeStop',s);                         // ^I
  finally
    t2.Free;
  end;
  result := True;
end;

procedure TDataRdRecReserveDateTime.OnWeekCheck(Sender: TObject);
var
  i,j,aStart,aStop : Integer;
begin
  aStart := FStart.Hou * 60 + FStart.Min;
  aStop := FStop.Hou * 60 + FStop.Min;
  if aStart <= aStop then begin
    for i := 1 to 7 do begin
      FStop.FWeeks[i] := FStart.FWeeks[i];
    end;
  end
  else begin
    for i := 1 to 7 do begin
      j := (i mod 7) + 1;
      FStop.FWeeks[j] := FStart.FWeeks[i];
    end;
  end;
end;

procedure TDataRdRecReserveDateTime.MakeList(aStart,
  aStop: TDateTimeCtrl);
var
  dd : TDateTimeCtrl;
  d : TDataRdRecReserveDateTimeItem;
begin
  dd := TDateTimeCtrl.Create;
  FItems.Clear;
  dd.Assign(aStart);
  try
    while dd.Compari(aStop) < 0 do begin
      if FStart.CheckDayWeek(dd) then begin;  // YԂ^悷̏ꍇ
        d := FItems.Add();
        d.Start.Yer := dd.Yer;
        d.Start.Mon := dd.Mon;
        d.Start.Day := dd.Day;
        d.Stop.Yer := dd.Yer;
        d.Stop.Mon := dd.Mon;
        d.Stop.Day := dd.Day;
        if FStart.Hou > FStop.Hou then begin  // t܂łꍇ
          d.Stop.IncDay();                    // IPi߂
        end;
        d.Start.Hou := Start.Hou;
        d.Start.Min := Start.Min;
        d.Stop.Hou := Stop.Hou;
        d.Stop.Min := Stop.Min;
      end;
      dd.IncDay();
    end;
  finally
    dd.Free;
  end;

end;

{ TDataRdRecReserveDateTimeEx }

procedure TDataRdRecReserveDateTimeEx.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveDateTimeEx;
  i : Integer;
begin
  if Source is TDataRdRecReserveDateTimeEx then begin
    a := TDataRdRecReserveDateTimeEx(Source);
    FMode := a.FMode;
    for i := 1 to High(FWeeks) do begin
      FWeeks[i] := a.FWeeks[i];
    end;

    inherited;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveDateTimeEx.CheckDayWeek(d: TDateTimeCtrl): Boolean;
begin
  DoWeekCheck();
  result := FWeeks[d.Week];
end;

function TDataRdRecReserveDateTimeEx.DataLoad(t: TStringListEx): Boolean;
begin
  Mode := TDataRdRecReserveDateTimeMode(t.GetInts('Mode',0));
  Yer := t.GetInts('Yer',Yer);
  Mon := t.GetInts('Mon',Mon);
  Day := t.GetInts('Day',Day);
  Hou := t.GetInts('Hou',Hou);
  Min := t.GetInts('Min',Min);
  result := True;
end;

function TDataRdRecReserveDateTimeEx.DataSave(t: TStringListEx): Boolean;
begin
  t.SetInts('Mode',Ord(FMode));
  t.SetInts('Yer',Yer);
  t.SetInts('Mon',Mon);
  t.SetInts('Day',Day);
  t.SetInts('Hou',Hou);
  t.SetInts('Min',Min);
  result := True;
end;

procedure TDataRdRecReserveDateTimeEx.DoWeekCheck;
begin
  if Assigned(FOnWeekCheck) then FOnWeekCheck(Self);
end;

function TDataRdRecReserveDateTimeEx.GetWeeks(Index: Integer): Boolean;
begin
  result := FWeeks[Index];
end;

procedure TDataRdRecReserveDateTimeEx.SetMode(
  const Value: TDataRdRecReserveDateTimeMode);
const
  Tbl : array[0..11,1..7] of Boolean = ((False,False,False,False,False,False,False),  // ̂
                                        (True ,False,False,False,False,False,False),  // Tj
                                        (False,True ,False,False,False,False,False),  // Tj
                                        (False,False,True ,False,False,False,False),  // TΗj
                                        (False,False,False,True ,False,False,False),  // Tj
                                        (False,False,False,False,True ,False,False),  // Tؗj
                                        (False,False,False,False,False,True ,False),  // Tj
                                        (False,False,False,False,False,False,True ),  // Tj
                                        (True ,True ,True ,True ,True ,True ,True ),  // 
                                        (False,True ,True ,True ,True ,False,False),  // `
                                        (False,True ,True ,True ,True ,True ,False),  // `
                                        (False,True ,True ,True ,True ,True ,True )); // `y

var
  i,j : Integer;
begin
  FMode := Value;
  j := Ord(Value);
  for i := 1 to 7 do begin
    FWeeks[i] := Tbl[j,i];
  end;
  if Value = rrrdNormal then begin
    //if Yer = 0 then exit;
    FWeeks[Week] := True;
  end;
end;

function TDataRdRecReserveDateTimeEx.StrFormat(
  const FormatStr: string): string;
begin
  if FMode = rrrdNormal then begin
    result := FormatDateTime(FormatStr,DateTime);
  end
  else begin
    result := TRdSchedulelDateModeTbl[Ord(FMode)];
  end;
end;

{ TDataRdRecReserveDateTimeItems }

destructor TDataRdRecReserveDateTimeItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataRdRecReserveDateTimeItems.Add: TDataRdRecReserveDateTimeItem;
var
  d : TDataRdRecReserveDateTimeItem;
begin
  d := TDataRdRecReserveDateTimeItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveDateTimeItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataRdRecReserveDateTimeItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataRdRecReserveDateTimeItems.GetItems(
  Index: Integer): TDataRdRecReserveDateTimeItem;
begin
  result := inherited Items[Index];
end;

{ TDataRdRecReserveDateTimeItem }

constructor TDataRdRecReserveDateTimeItem.Create;
begin
  FStart := TDataRdRecReserveDateTimeEx.Create;
  FStop  := TDataRdRecReserveDateTimeEx.Create;
end;

destructor TDataRdRecReserveDateTimeItem.Destroy;
begin
  FStart.Free;
  FStop.Free;
  inherited;
end;

function TDataRdRecReserveDateTimeItem.CheckOverlap(aStart,
  aStop: TDateTimeCtrl): Boolean;
var
  f1,f2 : Boolean;
begin
  f1 := FStart.Compari(aStart) <= 0;
  f2 := FStop.Compari(aStart) >0;
  if f1 and f2 then begin
    result := True;
    exit;
  end;
  f1 := FStart.Compari(aStop) < 0;
  f2 := FStop.Compari(aStop) > 0;
  if f1 and f2 then begin
    result := True;
    exit;
  end;
  result := False;
end;

end.
