unit DataRdRecReserveCmChapter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  {Ҏ`v^[                                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveCmChapterItemMode = (ccOff,ccON);
const
  TDataRdRecReserveCmChapterItemModeStr : array[0..1] of string = ('OFF','ON');

//--------------------------------------------------------------------------//
//  RDgpł{Ҏ`v^[f[^NX                        //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveCmChapterItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveCmChapterItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveCmChapterItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł{Ҏ`v^[ꗗǗNX                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveCmChapterItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveCmChapterItem;
    function GetModes(
      Mode: TDataRdRecReserveCmChapterItemMode): TDataRdRecReserveCmChapterItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveCmChapterItems) ;
    function Add() : TDataRdRecReserveCmChapterItem;
    property Items[Index: Integer] : TDataRdRecReserveCmChapterItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveCmChapterItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveCmChapterItemMode) : string;
    property Modes[Mode : TDataRdRecReserveCmChapterItemMode] : TDataRdRecReserveCmChapterItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDgpł{Ҏ`v^[ǗNX                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveCmChapter = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveCmChapterItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveCmChapterItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToCmChapterMode(const str : string) : TDataRdRecReserveCmChapterItemMode;
  function CmChapterModeToStr(const Mode : TDataRdRecReserveCmChapterItemMode) : string;

implementation

{ TDataRdRecReserveLineVoice }

constructor TDataRdRecReserveCmChapter.Create;
begin
  FItems := TDataRdRecReserveCmChapterItems.Create;
end;

destructor TDataRdRecReserveCmChapter.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveCmChapter.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveCmChapter;
begin
  if Source is TDataRdRecReserveCmChapter then begin
    a := TDataRdRecReserveCmChapter(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveCmChapter.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveCmChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveCmChapter.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveCmChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveLineVoiceItems }

function TDataRdRecReserveCmChapterItems.Add: TDataRdRecReserveCmChapterItem;
var
  d : TDataRdRecReserveCmChapterItem;
begin
  d := TDataRdRecReserveCmChapterItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveCmChapterItems.Assign(
  a: TDataRdRecReserveCmChapterItems);
var
  d : TDataRdRecReserveCmChapterItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveCmChapterItems.GetItems(
  Index: Integer): TDataRdRecReserveCmChapterItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveCmChapterItems.GetModes(
  Mode: TDataRdRecReserveCmChapterItemMode): TDataRdRecReserveCmChapterItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveCmChapterItems.IndexOfMode(
  Mode: TDataRdRecReserveCmChapterItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveCmChapterItems.ModeToValue(
  Mode: TDataRdRecReserveCmChapterItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveLineVoiceItem }

procedure TDataRdRecReserveCmChapterItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveCmChapterItem;
begin
  if Source is TDataRdRecReserveCmChapterItem then begin
    a := TDataRdRecReserveCmChapterItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveCmChapterItem.DataLoad(
  t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveCmChapterItem.DataSave(
  t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveCmChapterItem.GetModeStr: string;
var
  i : Integer;
begin
  i := Ord(FMode);
  result := TDataRdRecReserveCmChapterItemModeStr[i];
end;

procedure TDataRdRecReserveCmChapterItem.SetModeStr(const Value: string);
var
  i : Integer;
begin
  FMode := ccOff;
  for i := 0 to High(TDataRdRecReserveCmChapterItemModeStr) do begin
    if TDataRdRecReserveCmChapterItemModeStr[i] = Value then begin
      FMode := TDataRdRecReserveCmChapterItemMode(i);
      break;
    end;
  end;
end;

function StrToCmChapterMode(const str : string) : TDataRdRecReserveCmChapterItemMode;
var
  i : Integer;
begin
  result := ccOff;
  for i := 0 to High(TDataRdRecReserveCmChapterItemModeStr) do begin
    if TDataRdRecReserveCmChapterItemModeStr[i] = str then begin
      result := TDataRdRecReserveCmChapterItemMode(i);
      break;
    end;
  end;
end;

function CmChapterModeToStr(const Mode : TDataRdRecReserveCmChapterItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveCmChapterItemModeStr[i];
end;

end.
