unit DataRdRecReserveChapterMultiVoice;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  d`v^[                                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChapterMultiVoiceItemMode = (rcmOff,rcmOn);
const
  TDataRdRecReserveChapterMultiVoiceItemModeStr : array[0..1] of string = ('OFF','ON');

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChapterMultiVoiceItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveChapterMultiVoiceItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveChapterMultiVoiceItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChapterMultiVoiceItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveChapterMultiVoiceItem;
    function GetModes(
      Mode: TDataRdRecReserveChapterMultiVoiceItemMode): TDataRdRecReserveChapterMultiVoiceItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveChapterMultiVoiceItems) ;
    function Add() : TDataRdRecReserveChapterMultiVoiceItem;
    property Items[Index: Integer] : TDataRdRecReserveChapterMultiVoiceItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveChapterMultiVoiceItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveChapterMultiVoiceItemMode) : string;
    property Modes[Mode : TDataRdRecReserveChapterMultiVoiceItemMode] : TDataRdRecReserveChapterMultiVoiceItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChapterMultiVoice = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveChapterMultiVoiceItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveChapterMultiVoiceItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToChapterMultiVoiceMode(const str : string) : TDataRdRecReserveChapterMultiVoiceItemMode;
  function ChapterMultiVoiceModeToStr(const Mode : TDataRdRecReserveChapterMultiVoiceItemMode) : string;

implementation

{ TDataRdRecReserveCapterMultiVoice }

constructor TDataRdRecReserveChapterMultiVoice.Create;
begin
  FItems := TDataRdRecReserveChapterMultiVoiceItems.Create;
end;

destructor TDataRdRecReserveChapterMultiVoice.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveChapterMultiVoice.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveChapterMultiVoice;
begin
  if Source is TDataRdRecReserveChapterMultiVoice then begin
    a := TDataRdRecReserveChapterMultiVoice(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveChapterMultiVoice.DataLoad(
  ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveChapterMultiVoiceItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveChapterMultiVoice.DataSave(
  ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveChapterMultiVoiceItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveCapterMultiVoiceItems }

function TDataRdRecReserveChapterMultiVoiceItems.Add: TDataRdRecReserveChapterMultiVoiceItem;
var
  d : TDataRdRecReserveChapterMultiVoiceItem;
begin
  d := TDataRdRecReserveChapterMultiVoiceItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveChapterMultiVoiceItems.Assign(
  a: TDataRdRecReserveChapterMultiVoiceItems);
var
  d : TDataRdRecReserveChapterMultiVoiceItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveChapterMultiVoiceItems.GetItems(
  Index: Integer): TDataRdRecReserveChapterMultiVoiceItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveChapterMultiVoiceItems.GetModes(
  Mode: TDataRdRecReserveChapterMultiVoiceItemMode): TDataRdRecReserveChapterMultiVoiceItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveChapterMultiVoiceItems.IndexOfMode(
  Mode: TDataRdRecReserveChapterMultiVoiceItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

{ TDataRdRecReserveCapterMultiVoiceItem }

procedure TDataRdRecReserveChapterMultiVoiceItem.Assign(
  Source: TPersistent);
var
  a : TDataRdRecReserveChapterMultiVoiceItem;
begin
  if Source is TDataRdRecReserveChapterMultiVoiceItem then begin
    a := TDataRdRecReserveChapterMultiVoiceItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveChapterMultiVoiceItem.DataLoad(
  t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveChapterMultiVoiceItem.DataSave(
  t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveChapterMultiVoiceItem.GetModeStr: string;
begin
  result := ChapterMultiVoiceModeToStr(FMode);
end;

procedure TDataRdRecReserveChapterMultiVoiceItem.SetModeStr(
  const Value: string);
begin
  FMode := StrToChapterMultiVoiceMode(Value);
end;

function StrToChapterMultiVoiceMode(const str : string) : TDataRdRecReserveChapterMultiVoiceItemMode;
var
  i : Integer;
begin
  result := rcmOff;
  for i := 0 to High(TDataRdRecReserveChapterMultiVoiceItemModeStr) do begin
    if TDataRdRecReserveChapterMultiVoiceItemModeStr[i] = str then begin
      result := TDataRdRecReserveChapterMultiVoiceItemMode(i);
      break;
    end;
  end;
end;

function ChapterMultiVoiceModeToStr(const Mode : TDataRdRecReserveChapterMultiVoiceItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveChapterMultiVoiceItemModeStr[i];
end;

function TDataRdRecReserveChapterMultiVoiceItems.ModeToValue(
  Mode: TDataRdRecReserveChapterMultiVoiceItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

end.
 