unit DataRdRecReserveChannel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

type TDataRdRecReserveChannelMode = (cmEtc,cmUvAnalog,cmBsAnalog,cmLine,cmCs,cmUvDigital,
                                     cmBsDigital,cmCs110);
const TDataRdRecReserveChannelTbl : array[0..7] of string =
                                    ('̑','nAiO','arAiO','O','XJp[',
                                     'nfW^','arfW^','XJp[110');
const TDataRdRecReserveChannelModeStr : array[0..7] of string =
                                    ('ETC','UVA','BSA','Line','CS',
                                     'UVD','BSD','CS110');

//--------------------------------------------------------------------------//
//  RDMł`lf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChannelItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveChannelMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveChannelMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDMł`lꗗǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChannelItemsEx = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveChannelItem;
  public
    { Public 錾 }
    procedure Add(d : TDataRdRecReserveChannelItem);
    property Items[Index: Integer] : TDataRdRecReserveChannelItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  RDMł`lꗗǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChannelItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveChannelItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveChannelItems) ;
    function Add() : TDataRdRecReserveChannelItem;
    property Items[Index: Integer] : TDataRdRecReserveChannelItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  RDǗĂ`lǗNX                              //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveChannel = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveChannelItems;
    FSelects : TDataRdRecReserveChannelItemsEx;
    function GetSelects(
      Mode: TDataRdRecReserveChannelMode): TDataRdRecReserveChannelItemsEx;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveChannelItems read FItems;
    property Selects[Mode : TDataRdRecReserveChannelMode] : TDataRdRecReserveChannelItemsEx read GetSelects;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

implementation

{ TDataRdRecReserveChannel }

constructor TDataRdRecReserveChannel.Create;
begin
  FItems := TDataRdRecReserveChannelItems.Create;
  FSelects := TDataRdRecReserveChannelItemsEx.Create;
end;

destructor TDataRdRecReserveChannel.Destroy;
begin
  FSelects.Free;
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveChannel.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveChannel;
begin
  if Source is TDataRdRecReserveChannel then begin
    a := TDataRdRecReserveChannel(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveChannel.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveChannel.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;

end;

function TDataRdRecReserveChannel.GetSelects(
  Mode: TDataRdRecReserveChannelMode): TDataRdRecReserveChannelItemsEx;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
begin
  FSelects.Clear;
  for i := 0 to FItems.Count-1 do begin
    d := FItems[i];
    if d.Mode = Mode then begin
      FSelects.Add(d);
    end;
  end;
  result := FSelects;
end;

{ TDataRdRecReserveChannelItemsEx }

procedure TDataRdRecReserveChannelItemsEx.Add(
  d: TDataRdRecReserveChannelItem);
begin
  inherited Add(d);
end;

function TDataRdRecReserveChannelItemsEx.GetItems(
  Index: Integer): TDataRdRecReserveChannelItem;
begin
  result := inherited Items[Index];
end;

{ TDataRdRecReserveChannelItems }

function TDataRdRecReserveChannelItems.Add: TDataRdRecReserveChannelItem;
var
  d : TDataRdRecReserveChannelItem;
begin
  d := TDataRdRecReserveChannelItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveChannelItems.Assign(
  a: TDataRdRecReserveChannelItems);
var
  d : TDataRdRecReserveChannelItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveChannelItems.GetItems(
  Index: Integer): TDataRdRecReserveChannelItem;
begin
  result := inherited Items[Index];
end;

{ TDataRdRecReserveChannelItem }

procedure TDataRdRecReserveChannelItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveChannelItem;
begin
  if Source is TDataRdRecReserveChannelItem then begin
    a := TDataRdRecReserveChannelItem(Source);
    inherited;
    FMode := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveChannelItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveChannelItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;


function TDataRdRecReserveChannelItem.GetModeStr: string;
var
  i : Integer;
begin
  i := Ord(FMode);
  result := TDataRdRecReserveChannelModeStr[i];
end;

procedure TDataRdRecReserveChannelItem.SetModeStr(const Value: string);
var
  i : Integer;
begin
  FMode := cmUvAnalog;
  for i := 0 to High(TDataRdRecReserveChannelModeStr) do begin
    if TDataRdRecReserveChannelModeStr[i] = Value then begin
      FMode := TDataRdRecReserveChannelMode(i);
      break;
    end;
  end;
end;

end.
