unit DataRdRecReserveAudio;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  [h                                                              //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAudioItemMode = (raM1,raM2,raPCM);
const
  TDataRdRecReserveAudioItemModeStr : array[0..2] of string = ('M1','M2','PCM');
const
  TDataRdRecReserveAudioItemModeStrMail : array[0..2] of string = ('A','B','C');

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAudioItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveAudioItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveAudioItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAudioItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveAudioItem;
    function GetModes(
      Mode: TDataRdRecReserveAudioItemMode): TDataRdRecReserveAudioItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveAudioItems) ;
    function Add() : TDataRdRecReserveAudioItem;
    property Items[Index: Integer] : TDataRdRecReserveAudioItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveAudioItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveAudioItemMode) : string;
    property Modes[Mode : TDataRdRecReserveAudioItemMode] : TDataRdRecReserveAudioItem read GetModes;

  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAudio = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveAudioItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveAudioItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToAudioMode(const str : string) : TDataRdRecReserveAudioItemMode;
  function AudioModeToStr(const Mode : TDataRdRecReserveAudioItemMode) : string;

implementation

{ TDataRdRecReserveAudio }

constructor TDataRdRecReserveAudio.Create;
begin
  FItems := TDataRdRecReserveAudioItems.Create;
end;

destructor TDataRdRecReserveAudio.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveAudio.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveAudio;
begin
  if Source is TDataRdRecReserveAudio then begin
    a := TDataRdRecReserveAudio(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveAudio.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveAudioItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveAudio.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveAudioItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveAudioItems }

function TDataRdRecReserveAudioItems.Add: TDataRdRecReserveAudioItem;
var
  d : TDataRdRecReserveAudioItem;
begin
  d := TDataRdRecReserveAudioItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveAudioItems.Assign(
  a: TDataRdRecReserveAudioItems);
var
  d : TDataRdRecReserveAudioItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveAudioItems.GetItems(
  Index: Integer): TDataRdRecReserveAudioItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveAudioItems.GetModes(
  Mode: TDataRdRecReserveAudioItemMode): TDataRdRecReserveAudioItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveAudioItems.IndexOfMode(
  Mode: TDataRdRecReserveAudioItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveAudioItems.ModeToValue(
  Mode: TDataRdRecReserveAudioItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveAudioItem }

procedure TDataRdRecReserveAudioItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveAudioItem;
begin
  if Source is TDataRdRecReserveAudioItem then begin
    a := TDataRdRecReserveAudioItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveAudioItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveAudioItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveAudioItem.GetModeStr: string;
begin
  result := AudioModeToStr(FMode);
end;

procedure TDataRdRecReserveAudioItem.SetModeStr(const Value: string);
begin
  FMode := StrToAudioMode(Value);
end;

function StrToAudioMode(const str : string) : TDataRdRecReserveAudioItemMode;
var
  i : Integer;
begin
  result := raM1;
  for i := 0 to High(TDataRdRecReserveAudioItemModeStr) do begin
    if TDataRdRecReserveAudioItemModeStr[i] = str then begin
      result := TDataRdRecReserveAudioItemMode(i);
      break;
    end;
  end;
end;

function AudioModeToStr(const Mode : TDataRdRecReserveAudioItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveAudioItemModeStr[i];
end;

end.
