unit DataRdRecReserveAspect;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  DVD݊[h                                                           //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAspectItemMode = (ra4vs3,ra16vs9);
const
  TDataRdRecReserveAspectItemModeStr : array[0..1] of string = ('4:3','16:9');

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAspectItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveAspectItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveAspectItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAspectItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveAspectItem;
    function GetModes(
      Mode: TDataRdRecReserveAspectItemMode): TDataRdRecReserveAspectItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveAspectItems) ;
    function Add() : TDataRdRecReserveAspectItem;
    property Items[Index: Integer] : TDataRdRecReserveAspectItem read GetItems;default;

    function ModeToValue(Mode : TDataRdRecReserveAspectItemMode) : string;
    property Modes[Mode : TDataRdRecReserveAspectItemMode] : TDataRdRecReserveAspectItem read GetModes;
    function IndexOfMode(Mode : TDataRdRecReserveAspectItemMode) : Integer;

  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveAspect = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveAspectItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveAspectItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToAspectMode(const str : string) : TDataRdRecReserveAspectItemMode;
  function AspectModeToStr(const Mode : TDataRdRecReserveAspectItemMode) : string;

implementation

{ TDataRdRecReserveAspect }

constructor TDataRdRecReserveAspect.Create;
begin
  FItems := TDataRdRecReserveAspectItems.Create;
end;

destructor TDataRdRecReserveAspect.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveAspect.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveAspect;
begin
  if Source is TDataRdRecReserveAspect then begin
    a := TDataRdRecReserveAspect(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveAspect.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveAspectItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveAspect.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveAspectItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveAspectItems }

function TDataRdRecReserveAspectItems.Add: TDataRdRecReserveAspectItem;
var
  d : TDataRdRecReserveAspectItem;
begin
  d := TDataRdRecReserveAspectItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveAspectItems.Assign(
  a: TDataRdRecReserveAspectItems);
var
  d : TDataRdRecReserveAspectItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveAspectItems.GetItems(
  Index: Integer): TDataRdRecReserveAspectItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveAspectItems.GetModes(
  Mode: TDataRdRecReserveAspectItemMode): TDataRdRecReserveAspectItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveAspectItems.IndexOfMode(
  Mode: TDataRdRecReserveAspectItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveAspectItems.ModeToValue(
  Mode: TDataRdRecReserveAspectItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveAspectItem }

procedure TDataRdRecReserveAspectItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveAspectItem;
begin
  if Source is TDataRdRecReserveAspectItem then begin
    a := TDataRdRecReserveAspectItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveAspectItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveAspectItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveAspectItem.GetModeStr: string;
begin
  result := AspectModeToStr(FMode);
end;

procedure TDataRdRecReserveAspectItem.SetModeStr(const Value: string);
begin
  FMode := StrToAspectMode(Value);
end;

function StrToAspectMode(const str : string) : TDataRdRecReserveAspectItemMode;
var
  i : Integer;
begin
  result := ra4vs3;
  for i := 0 to High(TDataRdRecReserveAspectItemModeStr) do begin
    if TDataRdRecReserveAspectItemModeStr[i] = str then begin
      result := TDataRdRecReserveAspectItemMode(i);
      break;
    end;
  end;
end;

function AspectModeToStr(const Mode : TDataRdRecReserveAspectItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveAspectItemModeStr[i];
end;

end.
