//**************************************************************************//
//                                                                          //
//  RD̘^\NX                                            //
//                                                                          //
//  qc̘^\f[^ƂĎgp鑼                                //
//    [gZbg̃f[^ƂĂgpĂ                              //
//                                                                          //
//**************************************************************************//
unit DataRdRecReserve;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,
  DataRdRecReserveDateTime,DataRdRecReserveFolder,
  DataRdRecReserveChannel,DataRdRecReserveGenru,StringListKey,
  DataRdRecReserveInfo,DataRdRecReserveMedia,DataRdRecReserveRate,
  DataRdRecReserveAudio,DataRdRecReserveDvdr,DataRdRecReserveEncode,
  DataRdRecReserveAspect,DataRdRecReserveChapterMultiVoice,
  DataRdRecReserveLineVoice,DataRdRecReserveDvdChapter,
  DataRdRecReserveRecPriority,DataRdRecReserveMagicChapter,
  DataRdRecReserveMuteChapter,DataRdRecReserveCmChapter,DataRdRecReserveTitleLink;

const
  ConfigDataVersion = 1;             // ݒۑ̃o[Wԍ



//--------------------------------------------------------------------------//
//  L^fBA                                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveItemMedhia = (rmdHdd,rmdDvd,rmAB);

const
  TDataRdRecReserveItemMedhiaStr : array[0..2] of string = ('HDD','DVD','AB');

//--------------------------------------------------------------------------//
//  RD̘^\f[^ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveItem = class(TPersistent)
  private
    { Private 錾 }
    //FOwner : TObject;                           // TDataRdRecReserveQ
    FInfoEnabled: Boolean;                        // True:ڍ׏𓾂
    FExecution : Boolean;                         // True:\s
    FName: string;                                // ݒ薼
    FTitle: string;                               // ^ԑg
    FChannel : string;                            // ^\ꗗ̃`l
    FChannelNo: Integer;                          // `li1`12ng 101`BSAiO
                                                  //             201`O
    FChannelStr : string;                         // `liqcgl 203,SP734Ȃǁj
    FBCMedhiaStr: string;

    FDateTime : TDataRdRecReserveDateTime;        // ^iJnƏIj

    FRecMedia: TDataRdRecReserveMediaItemMode;    // ^惁fBA
    FRecRate: TDataRdRecReserveRateItemMode;      // ^惌[g
    FRecAudio: TDataRdRecReserveAudioItemMode;    // [g
    FRecDvdr: TDataRdRecReserveDvdrItemMode;      // DVD-R݊[h


    FGenre: Integer;                              // W
    FComment: string;                             // ԑg
    FHighRateSaved: Boolean;                      // True:[gߖ
    FSilentCut:                                   // `v^[
        TDataRdRecReserveMuteChapterItemMode;

    FCmChapter:                                   // {Ҏ`v^[
        TDataRdRecReserveCmChapterItemMode;

    FAspect: TDataRdRecReserveAspectItemMode;     // DVDL^ʔ䗦

    FChapMultiVoice :
      TDataRdRecReserveChapterMultiVoiceItemMode; // d`v^[
    FFolder: string;                              // i[tH_
    FAudioLine:
            TDataRdRecReserveLineVoiceItemMode;   // CI
    FDvdChChapter :
          TDataRdRecReserveDvdChapterItemMode;    // DVD-Video`v^[
    FMagicChapter :                               // }WbN`v^[
        TDataRdRecReserveMagicChapterItemMode;
    FTitleLink :                                  // ԑgǂ
        TDataRdRecReserveTitleLinkItemMode;
    FEncoder: TDataRdRecReserveEncodeItemMode;    // GR[_[̎

    FLinkEnabled: Boolean;                        // True:ԑgf[^ƑΉ
    FLinkMode: Integer;                           // ԑgƑΉ(-1:ׂ)
    FLinkGenre: Integer;                          // ԑgƑΉW(-1:ׂ)
    FStatus: TTvScheduleStatus;                   // ԑgƑΉ
    FIndexNo: Integer;                            // qcŎgpĂ^\ԍ
    FRecPriority:                                 // ^Dx
       TDataRdRecReserveRecPriorityItemMode;
    FAutoDel: Boolean;                            // 폜@False:Ȃ True:
    FSportExt: TRdSchedulelSportMode;             // X|[c
    function GetRdIndex: Integer;
    function GetRdRecIndex: Integer;

  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    procedure AssignInfo(a : TDataRdRecReserveItem);

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    // True:ڍ׏𓾂
    property InfoEnabled : Boolean read FInfoEnabled write FInfoEnabled;
    // \s
    property Execution : Boolean read FExecution write FExecution;
    // 
    property Name : string read FName write FName;
    // \^Cg
    property Title : string  read FTitle write FTitle;
    property Channel : string read FChannel write FChannel;
    property ChannelNo : Integer read FChannelNo write FChannelNo;
    property ChannelStr : string read FChannelStr write FChannelStr;

    // 
    property BCMedhiaStr : string read FBCMedhiaStr write FBCMedhiaStr;
    // ^惁fBA
    property RecMedia  : TDataRdRecReserveMediaItemMode read FRecMedia write FRecMedia;
    // 掿
    property RecRate   : TDataRdRecReserveRateItemMode read FRecRate write FRecRate;
    // 
    property RecAudio  : TDataRdRecReserveAudioItemMode read FRecAudio write FRecAudio;
    // W
    property Genre     : Integer read FGenre write FGenre;
    // DVD-R݊[h
    property RecDvdr   : TDataRdRecReserveDvdrItemMode read FRecDvdr write FRecDvdr;
    // ԑg
    property Comment   : string read FComment write FComment;
    // ^iJnƏIj
    property DateTime      : TDataRdRecReserveDateTime read FDateTime;
    // True:[gߖ
    property HighRateSaved : Boolean read FHighRateSaved write FHighRateSaved;
    // `v^[
    property SilentCut     : TDataRdRecReserveMuteChapterItemMode read FSilentCut     write FSilentCut;
    // {Ҏ`v^[
    property CmChapter     : TDataRdRecReserveCmChapterItemMode read FCmChapter     write FCmChapter;
    // DVDL^ʔ䗦
    property Aspect    : TDataRdRecReserveAspectItemMode read FAspect write FAspect;
    // d`v^[
    property ChapMultiVoice : TDataRdRecReserveChapterMultiVoiceItemMode read FChapMultiVoice write FChapMultiVoice;
    // }WbN`v^[
    property MagicChapter : TDataRdRecReserveMagicChapterItemMode read FMagicChapter write FMagicChapter;
    // i[tH_
    property Folder  : string read FFolder write FFolder;
    // CI
    property AudioLine : TDataRdRecReserveLineVoiceItemMode read FAudioLine write FAudioLine;
    // DVD-Video`v^[
    property DvdChChapter : TDataRdRecReserveDvdChapterItemMode read FDvdChChapter write FDvdChChapter;
    // ԑgǂ
    property TitleLink : TDataRdRecReserveTitleLinkItemMode read FTitleLink write FTitleLink;
    // GR[_[̎
    property Encoder : TDataRdRecReserveEncodeItemMode read FEncoder write FEncoder;
    // True:ԑgf[^ƑΉ
    property LinkEnabled : Boolean read FLinkEnabled write FLinkEnabled;
    // ԑgƑΉW(-1:ׂ)
    property LinkGenre : Integer read FLinkGenre write FLinkGenre;
    // ԑgƑΉ(-1:ׂ)
    property LinkMode : Integer read FLinkMode write FLinkMode;
    // ԑgƑΉ
    property Status : TTvScheduleStatus read FStatus;
    // ^Dx
    property RecPriority : TDataRdRecReserveRecPriorityItemMode read FRecPriority write FRecPriority;
    // 폜@False:Ȃ True:
    property AutoDel : Boolean read FAutoDel write FAutoDel;
    // X|[c
    property SportExt : TRdSchedulelSportMode read FSportExt write FSportExt;
    // qcŎgpĂ^\ԍ
    property IndexNo : Integer read FIndexNo write FIndexNo;
    // ڂRD̘^f[^\B
    property RdIndex : Integer read GetRdIndex;
    // Ԗڂ̘^f[^\B
    property RdRecIndex : Integer read GetRdRecIndex;

  end;

type
  TDataRdRecReserveItemEvent = procedure(Sender : TObject;d : TDataRdRecReserveItem) of object;

//--------------------------------------------------------------------------//
//  RD̘^\ꗗǗNXQƗpi{̂P䕪j                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveItemsEx = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveItem;
  public
    { Public 錾 }
    procedure Add(d : TDataRdRecReserveItem);
    property Items[Index: Integer] : TDataRdRecReserveItem read GetItems;default;


  end;

type TDataRdRecReserveItemsEvent = procedure(Sender: TObject;ts : TDataRdRecReserveItemsEx) of Object;

//--------------------------------------------------------------------------//
//  RD̘^\ꗗǗNXi{̂P䕪j                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveItems = class(TList)
  private
    { Private 錾 }
    //FOwner : TObject;                         // TDataRdRecReserveQ
    FOnDels: TDataRdRecReserveItemsEvent;
    FOnAdds: TDataRdRecReserveItemsEvent;
    FOnClr: TNotifyEvent;
    function GetItems(Index: Integer): TDataRdRecReserveItem;
    procedure DoAdds(ts : TDataRdRecReserveItemsEx);
    procedure DoDels(ts : TDataRdRecReserveItemsEx);
    procedure DoClr();
  public
    { Public 錾 }
    constructor Create;dynamic;
    destructor Destroy;override;
    procedure Assign(Source : TDataRdRecReserveItems) ;
    procedure Add(d : TDataRdRecReserveItem);
    procedure Delete(i : Integer);
    procedure Adds(ts : TDataRdRecReserveItemsEx);
    procedure Dels(ts : TDataRdRecReserveItemsEx);
    procedure Clear();override;
    property Items[Index: Integer] : TDataRdRecReserveItem read GetItems;default;

    property OnAdds : TDataRdRecReserveItemsEvent read FOnAdds write FOnAdds;
    property OnDels : TDataRdRecReserveItemsEvent read FOnDels write FOnDels;
    property OnClr : TNotifyEvent read FOnClr write FOnClr;
  end;

//--------------------------------------------------------------------------//
//  RDP䕪̘^\ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserve = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveItems;
    //FOwner: TObject;
    //FInfo : TDataRdRecReserveInfo;
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    function DataSaveOld(FileName : string) : Boolean;
    function DataLoadOld(FileName : string) : Boolean;

    function DataSave(tk : TStringListKey;Name : string) : Boolean;
    function DataLoad(tk : TStringListKey;Name : string) : Boolean;

    property Items : TDataRdRecReserveItems read FItems;
    //property Owner : TObject read FOwner write FOwner;
    //property Info : TDataRdRecReserveInfo read FInfo;
  end;

implementation

uses DMUnit,DataRd;

{ TDataRdRecReserveItem }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataRdRecReserveItem.Create;
begin
  FDateTime := TDataRdRecReserveDateTime.Create;
  FStatus := TTvScheduleStatus.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataRdRecReserveItem.Destroy;
begin
  FStatus.Free;
  FDateTime.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Source : Rs[                                           //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//   \ꗗŎ擾of[^̂ݑ                                   //
//                                                                          //
//**************************************************************************//
procedure TDataRdRecReserveItem.AssignInfo(a : TDataRdRecReserveItem);
begin
  FExecution := a.FExecution;
  FName  := a.FName;
  FTitle := a.FTitle;
  Channel := a.FChannel;
  ChannelNo := a.FChannelNo;
  FDateTime.Assign(a.FDateTime);
  FEncoder  := a.FEncoder;
end;


//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Source : Rs[                                           //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataRdRecReserveItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveItem;
begin
  if Source is TDataRdRecReserveItem then begin
    a := TDataRdRecReserveItem(Source);
    AssignInfo(a);
    FInfoEnabled := a.FInfoEnabled;
    //FStart.Assign(a.FStart);
    //FStop.Assign(a.FStop);
    FChannelStr     := a.FChannelStr;
    FBCMedhiaStr    := a.FBCMedhiaStr;
    FRecMedia       := a.FRecMedia;
    FRecRate        := a.FRecRate;
    FRecAudio       := a.FRecAudio;
    FRecDvdr        := a.FRecDvdr;
    FGenre          := a.FGenre;
    FComment        := a.FComment;
    FHighRateSaved  := a.FHighRateSaved;
    FSilentCut      := a.FSilentCut;
    FAspect         := a.FAspect;
    FChapMultiVoice := a.FChapMultiVoice;
    FCmChapter      := a.FCmChapter;
    FMagicChapter   := a.FMagicChapter;
    FFolder         := a.FFolder;
    FAudioLine      := a.FAudioLine;
    FDvdChChapter   := a.FDvdChChapter;
    FLinkEnabled    := a.FLinkEnabled;
    FLinkGenre      := a.FLinkGenre;
    FLinkMode       := a.FLinkMode;
    FRecPriority    := a.FRecPriority;
    FAutoDel        := a.FAutoDel;
    FTitleLink      := a.FTitleLink;
    FSportExt       := a.FSportExt;
    FStatus.Assign(a.FStatus);
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^ǂݍ݁@`                                                  //
//                                                                          //
//   - Input -  t : f[^ǂݍޕ񃊃Xg                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataRdRecReserveItem.DataLoad(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  s : string;
begin

  t2 := TStringListEx.Create;
  try
    result := False;
    FExecution        := t.GetBools('Execution',FExecution);    // ^stO
    FTitle            := t.GetStrs('Title',FTitle);             // ^\
    FChannelStr       := t.GetStrs('ChannelStr',FChannelStr);   // RDʂ`l
    FChannel          := t.GetStrs('Channel',FChannel);   //

    FBCMedhiaStr       := t.GetStrs('BCMedhiaStr',FBCMedhiaStr);   // RDʂ̌n

    FDateTime.DataLoad(t);

    s := t.GetStrs('RecMedia','');                             // ^惁fBA
    FRecMedia := StrToMediaMode(s);

    s := t.GetStrs('RecRate','');                              // ^惌[g
    FRecRate := StrToRateMode(s);

    s := t.GetStrs('RecAudio','');                             // 
    FRecAudio := StrToAudioMode(s);

    s := t.GetStrs('RecDvdr','');                             // DVD-R݊[h
    FRecDvdr := StrToDvdrMode(s);

    FGenre := t.GetInts('Genre',FGenre);                 // W

    t2.CommaTextEx := t.GetStrs('Comment',FComment);                              // ԑg
    FComment := t2.Text;

    FHighRateSaved := t.GetBools('HighRateSaved',FHighRateSaved);          // True:[gߖ
    // `v^[
    //FSilentCut :=  t.GetBools('SilentCut',FSilentCut);
    s := t.GetStrs('SilentCut','');
    FSilentCut := StrToMuteChapterMode(s);

    s := t.GetStrs('Aspect','');                             // DVDL^ʔ䗦
    FAspect := StrToAspectMode(s);

    s := t.GetStrs('ChapterMultiVoice','');                             // d`v^[
    FChapMultiVoice := StrToChapterMultiVoiceMode(s);

    FFolder := t.GetStrs('Folder','[g');                                // i[tH_

    {
    i := t.GetStrTblIndex('AudioLine',TRdSchedulelAudioLineSendTbl,0);     // CI

    FAudioLine := TRdSchedulelAudioLineMode(i);
    }

    s := t.GetStrs('DvdChChapter','');                                     // DVD-Video`v^[
    FDvdChChapter := StrToDvdChapterMode(s);
    {
    i := t.GetStrTblIndex('DvdChChapter',TRdSchedulelDvdChapterSendTbl,0); // DVD-Video`v^[
    FDvdChChapter := TRdSchedulelDvdChapterMode(i);
    }
    //FEncodeNo := t.GetInts('EncodeNo',FEncodeNo);                          // `[i[ԍ(O`
    s := t.GetStrs('Encoder','');
    FEncoder := StrToEncodeMode(s);

    i := t.GetInts('RecPriority',0);                                       // ^Dx
    FRecPriority := TDataRdRecReserveRecPriorityItemMode(i);

    FAutoDel := t.GetBools('AutoDel',FAutoDel);

    // ԑgǂ
    //FTitleLink := t.GetBools('TitleLink',FTitleLink);
    s := t.GetStrs('TitleLink','');
    FTitleLink := StrToTitleLinkMode(s);

    i := Ord(FSportExt);                                                   // X|[c
    i := t.GetInts('SportExt',i);
    FSportExt := TRdSchedulelSportMode(i);

    result := True;
  finally
    t2.Free;
  end;
end;

function TDataRdRecReserveItem.DataSave(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  s : string;
begin

  t2 := TStringListEx.Create;
  try
    result := False;
    t.SetBools('Execution',FExecution);    // ^stO
    t.SetStrs('Title',FTitle);             // ^\
    t.SetStrs('Channel',FChannel);   //
    t.SetStrs('ChannelStr',FChannelStr);   // RDʂ`l
    t.SetStrs('BCMedhiaStr',FBCMedhiaStr);   // RDʂ`

    t2.Clear();                                                 // ^Jn
    FDateTime.Start.DataSave(t2);
    t.SetStrs('DateTimeStart',t2.CommaTextEx);

    t2.Clear();                                                 // ^I
    FDateTime.Stop.DataSave(t2);
    t.SetStrs('DateTimeStop',t2.CommaTextEx);

    s := MediaModeToStr(FRecMedia);                            // ^惁fBA
    t.SetStrs('RecMedia',s);

    s := RateModeToStr(FRecRate);                              // ^惌[g
    t.SetStrs('RecRate',s);

    s := AudioModeToStr(FRecAudio);                              // 
    t.SetStrs('RecAudio',s);

    s := DvdrModeToStr(FRecDvdr);                             // DVD-R݊[h
    t.SetStrs('RecDvdr',s);

    t.SetInts('Genre',FGenre);                                             // W
    t2.Clear;
    t2.Add(FComment);
    t.SetStrs('Comment',t2.CommaTextEx);                             // ԑg
    t.SetBools('HighRateSaved',FHighRateSaved);                     // True:[gߖ

    // `v^[
    //t.SetBools('SilentCut',FSilentCut);
    s := MuteChapterModeToStr(FSilentCut);
    t.SetStrs('SilentCut',s);

    s := AspectModeToStr(FAspect);                                  // DVDL^ʔ䗦
    t.SetStrs('Aspect',s);

    s := ChapterMultiVoiceModeToStr(FChapMultiVoice);                                  // d`v^[
    t.SetStrs('ChapterMultiVoice',s);

    t.SetStrs('Folder',FFolder);                                    // i[tH_

    //i := Ord(FAudioLine);                                           // CI
    //t.SetStrs('AudioLine',TRdSchedulelAudioLineSendTbl[i]);
    s := LineVoiceModeToStr(AudioLine);
    t.SetStrs('AudioLine',s);

    // DVD-Video`v^[
    s := DvdChapterModeToStr(FDvdChChapter);
    t.SetStrs('DvdChChapter',s);


    //t.SetInts('EncodeNo',FEncodeNo);                                // `[i[ԍ(O`
    t.SetInts('Encoder',Ord(FEncoder));                             // `[i[̎

    t.SetInts('RecPriority',Ord(FRecPriority));                     // ^Dx

    t.SetBools('AutoDel',FAutoDel);                                 // 폜

    // ԑgǂ
    //t.SetBools('TitleLink',FTitleLink);
    s := TitleLinkModeToStr(FTitleLink);
    t.SetStrs('TitleLink',s);

    i := Ord(FSportExt);
    t.SetInts('SportExt',i);                                        // X|[c
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataRdRecReserveItem.GetRdIndex: Integer;
var
  dr : TDataRdItem;
  i,j : Integer;
begin
  result := -1;
  if DM = nil then exit;
  if DM.Rd = nil then exit;
  for j := 0 to DM.Rd.Items.Count-1 do begin
    dr := DM.Rd.Items[j];
    i := dr.RecReserve.Items.IndexOf(Self);
    if i <> -1 then begin
      result := j;
      exit;
    end;
  end;

end;

function TDataRdRecReserveItem.GetRdRecIndex: Integer;
var
  dr : TDataRdItem;
  i,j : Integer;
begin
  result := -1;
  if DM = nil then exit;
  if DM.Rd = nil then exit;
  for j := 0 to DM.Rd.Items.Count-1 do begin
    dr := DM.Rd.Items[j];
    i := dr.RecReserve.Items.IndexOf(Self);
    if i <> -1 then begin
      result := i;
      exit;
    end;
  end;
end;

{ TDataRdRecReserveItemsEx }

procedure TDataRdRecReserveItemsEx.Add(d: TDataRdRecReserveItem);
begin
  inherited Add(d);
end;

function TDataRdRecReserveItemsEx.GetItems(
  Index: Integer): TDataRdRecReserveItem;
begin
  result := inherited Items[Index];
end;

{ TDataRdRecReserveItems }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataRdRecReserveItems.Create;
begin

end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataRdRecReserveItems.Destroy;
begin
  Clear();
  inherited;
end;

procedure TDataRdRecReserveItems.Assign(Source: TDataRdRecReserveItems);
var
  i : Integer;
  a : TDataRdRecReserveItems;
  d : TDataRdRecReserveItem;
begin
  a := Source;

  Clear();
  for i := 0 to a.Count-1 do begin
    d := TDataRdRecReserveItem.Create;
    d.Assign(a[i]);
    //d.FOwner := FOwner;
    Add(d);
  end;
end;

procedure TDataRdRecReserveItems.Add(d : TDataRdRecReserveItem);
var
  ts : TDataRdRecReserveItemsEx;
  aStart,aStop : TDateTimeCtrl;
begin
  inherited Add(d);
  //d.FOwner := FOwner;

  aStart := TDateTimeCtrl.Create;
  aStop  := TDateTimeCtrl.Create;
  ts := TDataRdRecReserveItemsEx.Create;
  try
    ts.Add(d);

    aStart.DateTime := Now;
    aStop.Assign(aStart);
    aStop.IncDay(7);
    d.DateTime.MakeList(aStart,aStop);

    DoAdds(ts);
  finally
    ts.Free;
    aStop.Free;
    aStart.Free;
  end;

end;

procedure TDataRdRecReserveItems.Adds(ts: TDataRdRecReserveItemsEx);
var
  i : Integer;
begin
  for i := 0 to ts.Count-1 do begin
    inherited Add(ts[i]);
  end;
  DoAdds(ts);
end;

procedure TDataRdRecReserveItems.Delete(i: Integer);
var
  ts : TDataRdRecReserveItemsEx;
  d : TDataRdRecReserveItem;
begin
  ts := TDataRdRecReserveItemsEx.Create;
  try
    d := Items[i];
    ts.Add(d);
    DoDels(ts);
  finally
    ts.Free;
  end;

  Items[i].Free;
  inherited;
end;

procedure TDataRdRecReserveItems.Dels(ts: TDataRdRecReserveItemsEx);
var
  i,j : Integer;
begin
  DoDels(ts);
  for j := 0 to ts.Count-1 do begin
    i := IndexOf(ts[j]);
    if i = -1 then continue;

    Items[i].Free;
    inherited Delete(i);
  end;


end;

procedure TDataRdRecReserveItems.Clear;
var
  i : Integer;
  ts : TDataRdRecReserveItemsEx;
  d : TDataRdRecReserveItem;
begin
  ts := TDataRdRecReserveItemsEx.Create;
  try
    for i := 0 to Count-1 do begin
      d := Items[i];
      ts.Add(d);
    end;
    DoDels(ts);
  finally
    ts.Free;
  end;

  DoClr();
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataRdRecReserveItems.DoAdds(ts: TDataRdRecReserveItemsEx);
begin
  if Assigned(FOnAdds) then begin
    FOnAdds(Self,ts);
  end;
end;

procedure TDataRdRecReserveItems.DoDels(ts: TDataRdRecReserveItemsEx);
begin
  if Assigned(FOnDels) then begin
    FOnDels(Self,ts);
  end;
end;

procedure TDataRdRecReserveItems.DoClr;
begin
  if Assigned(FOnClr) then begin
    FOnClr(Self);
  end;
end;


function TDataRdRecReserveItems.GetItems(Index: Integer): TDataRdRecReserveItem;
begin
  result := inherited Items[Index];
end;



{ TDataRdRecReserve }

constructor TDataRdRecReserve.Create;
begin
  FItems := TDataRdRecReserveItems.Create;
  //FItems.FOwner := Self;
  //FFolders := TDataRdRecReserveFolder.Create;
  //FChannels := TDataRdRecReserveChannel.Create;
  //FGenres := TDataRdRecReserveGenre.Create;
  //FInfo := TDataRdRecReserveInfo.Create;
end;

destructor TDataRdRecReserve.Destroy;
begin
  //FInfo.Free;
  //FGenres.Free;
  //FChannels.Free;
  //FFolders.Free;
  FItems.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@t@Cf[^ǂݍ݁@`                                      //
//                                                                          //
//   - Input -  FileName : ǂݍރt@C                                 //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataRdRecReserve.DataLoadOld(FileName: string): Boolean;
var
  t,t2 : TStringListEx;
  i : Integer;
  d : TDataRdRecReserveItem;
begin
  result := False;
  FItems.Clear;                                      // \񃊃XgNA
  if not FileExists(FileName) then begin      // t@C݂Ȃꍇ
    exit;                                     // Ȃ
  end;

  t := TStringListEx.Create;
  t2 := TStringListEx.Create;
  try
    t.LoadFromFile(FileName);                   // \f[^t@Cǂݍ
    if t.GetInt() <> ConfigDataVersion then exit;
    for i := 0 to t.Count-1 do begin
      t2.CommaTextEx := t[i];
      d := TDataRdRecReserveItem.Create;
      d.DataLoad(t2);
      FItems.Add(d);
    end;
    result := True;
  finally
    t2.Free;
    t.Free;
  end;
end;

function TDataRdRecReserve.DataSaveOld(FileName: string): Boolean;
begin
  result := False;
end;
{
function TDataRdRecReserveItem.GetFolders: TDataRdRecReserveFolder;
var
  dv : TDataRdRecReserve;
begin
  result := nil;
  dv := TDataRdRecReserve(FOwner);
  if dv = nil then exit;
  result := dv.FFolders;
end;
}
function TDataRdRecReserve.DataLoad(tk: TStringListKey;Name : string): Boolean;
var
  i,cnt : Integer;
  t : TStringListEx;
  s : string;
  dr : TDataRdRecReserveItem;
begin
  result := False;
  FItems.Clear;
  s := Name;
  {
  if FInfo <> nil then begin
    FInfo.DataLoad(tk,Name);
  end;
  }

  t := tk.Values[s];
  if t = nil then exit;
  cnt := t.GetInts('Count',0);
  for i := 0 to cnt-1 do begin
    s := Name + '_' + IntToStr(i);
    t := tk.Values[s];
    if t = nil then continue;
    dr := TDataRdRecReserveItem.Create;
    dr.DataLoad(t);
    FItems.Add(dr);
  end;
  result := True;
end;

function TDataRdRecReserve.DataSave(tk: TStringListKey;Name : string): Boolean;
var
  i : Integer;
  t : TStringListEx;
  s : string;
begin
  t := TStringListEx.Create;
  try
    result := False;
    s := Name;
    {
    if FInfo <> nil then begin
      FInfo.DataSave(tk,Name);
    end;
    }
    t.Clear;
    t.SetInts('Count',FItems.Count);
    tk.Add(s,t);
    for i := 0 to FItems.Count-1 do begin
      s := Name + '_' + IntToStr(i);
      t.Clear;
      FItems[i].DataSave(t);
      tk.Add(s,t);
    end;
    result := True;
  finally
    t.Free;
  end;

end;

end.
