unit DataRd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime,
  DataConfigRd,DataRdRecReserve,MultiEvent,GetRdStanderd,ProcPublicFileName;

//--------------------------------------------------------------------------//
//  RDP䕪̑Sf[^ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdItem = class(TPersistent)
  private
    { Private 錾 }
    //FOwner : TObject;                               // TDataRdQ
    FGetRd : TGetRd;                                  // qcƂ̒ʐMNX
    FIndex : Integer;                                 // ǗĂRD̂ڂi0`
    FRecReserve : TDataRdRecReserve;                  // ^\f[^
    //FConfig : TDataRdConfigItem;                      // ݒiXbhŏ邽ߎ̂j
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;


    property RecReserve : TDataRdRecReserve read FRecReserve;
    //property Config : TDataRdConfigItem read FConfig;
    property GetRd : TGetRd read FGetRd;
    //property Owner : TObject read FOwner;
  end;

type
  TDataRdItemEvent = procedure(Sender : TObject;d1 : TDataRdItem;d2 : TDataRdRecReserveItem) of object;

//--------------------------------------------------------------------------//
//  RD𕡐ǗNX                                                //
//--------------------------------------------------------------------------//
type
  TDataRdItems = class(TList)
  private
    { Private 錾 }
    FOwner : TObject;
    procedure OnRecAdds(Sender : TObject;ts : TDataRdRecReserveItemsEx);
    procedure OnRecDels(Sender : TObject;ts : TDataRdRecReserveItemsEx);
    procedure OnRecClr(Sender : TObject);
    procedure OnRecRateChange(Sender : TObject;dr : TDataRdRecReserveItem);
    function GetItems(Index: Integer): TDataRdItem;
  public
    { Public 錾 }
    constructor Create;dynamic;
    destructor Destroy;override;
    function Add() : TDataRdItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataRdItem read GetItems;default;

  end;


//--------------------------------------------------------------------------//
//  SĂ̂qcǗNX                                              //
//--------------------------------------------------------------------------//
type
  TDataRd = class(TPersistent)
  private
    { Private 錾 }
    FItems: TDataRdItems;                                    // 䕪̂qcǗNX
    FOnChangeAdd: TMultiEventSend;
    FOnChangeDel: TMultiEventSend;
    FOnRecClr: TMultiEventSend;
    FOnRecAdds: TMultiEventSend;
    FOnRecDels: TMultiEventSend;
    FOnRecChange: TGetRdStanderdRecChangeEvent;
    FConfig: TDataConfigRd;

    function GetFileNameInfo() : string;

    procedure DoRecRateChange(dr : TDataRdRecReserveItem);
    procedure SetConfig(const Value: TDataConfigRd);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    function DataLoadOld(tt : TStringListKey) : Boolean;
    function DataLoad(tt : TStringListKey) : Boolean;
    function DataConfigSave(tt : TStringListKey) : Boolean;
    function DataRecSave(tk : TStringListKey) : Boolean;
    function DataRecLoad(tk : TStringListKey) : Boolean;
    function DataInfoSave() : Boolean;
    function DataInfoLoad() : Boolean;

    property Items : TDataRdItems read FItems;
    property Config : TDataConfigRd read FConfig write SetConfig;

    property OnChangeAdd : TMultiEventSend read FOnChangeAdd;
    property OnChangeDel : TMultiEventSend read FOnChangeDel;

    property OnRecAdds : TMultiEventSend read FOnRecAdds;
    property OnRecDels : TMultiEventSend read FOnRecDels;
    property OnRecClr : TMultiEventSend read FOnRecClr;
    property OnRecChange : TGetRdStanderdRecChangeEvent read FOnRecChange write FOnRecChange;
  end;

//--------------------------------------------------------------------------//
//  }`Cxgpɕ̃NX܂Ƃ߂邽߂̃NX                    //
//--------------------------------------------------------------------------//
type
  TDataRdEventObject = class(TPersistent)
  private
    FRdItem: TDataRdItem;
    FRdRecReserveItem: TDataRdRecReserveItem;
    { Private 錾 }
  public
    { Public 錾 }
    property RdItem : TDataRdItem read FRdItem;
    property RdRecReserveItem : TDataRdRecReserveItem read FRdRecReserveItem;
  end;

implementation

uses DMUnit,DataRdRecReserveInfo;

{ TDataRdItem }

constructor TDataRdItem.Create();
begin
  FRecReserve := TDataRdRecReserve.Create;
  //FRecReserve.Owner := Self;
  //FConfig := TDataRdConfigItem.Create;
  FGetRd := TGetRd.Create;
end;

destructor TDataRdItem.Destroy;
begin
  //FConfig.Free;
  FGetRd.Free;
  FRecReserve.Free;
  inherited;
end;

{ TDataRdItems }

constructor TDataRdItems.Create;
begin

end;

destructor TDataRdItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataRdItems.Add() : TDataRdItem;
var
  d : TDataRdItem;
begin
  d := TDataRdItem.Create();
  d.FIndex := Count;              // ڂ̂qcȂ̂
  //d.FOwner := FOwner;             // TDataRdNXQƂ
  inherited Add(d);
  d.FRecReserve.Items.OnAdds := OnRecAdds;
  d.FRecReserve.Items.OnDels := OnRecDels;
  d.FRecReserve.Items.OnClr := OnRecClr;
  d.FGetRd.OnRecChange := OnRecRateChange;
  result := d;
end;
{
procedure TDataRdItems.Assign(Source: TDataRdItems);
var
  i : Integer;
  a : TDataRdItems;
  d : TDataRdItem;
begin
  a := Source;
  Clear();
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a[i]);
  end;
end;
}
procedure TDataRdItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataRdItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataRdItems.GetItems(Index: Integer): TDataRdItem;
begin
  result := inherited Items[Index];
end;

procedure TDataRdItems.OnRecAdds(Sender: TObject;
  ts: TDataRdRecReserveItemsEx);
var
  dv : TDataRd;
begin
  if FOwner = nil then exit;
  dv := TDataRd(FOwner);
  dv.FOnRecAdds.Notify(ts);
end;

procedure TDataRdItems.OnRecClr(Sender: TObject);
var
  dv : TDataRd;
begin
  if FOwner = nil then exit;
  dv := TDataRd(FOwner);
  dv.FOnRecClr.Notify(nil);
end;

procedure TDataRdItems.OnRecDels(Sender: TObject;
  ts: TDataRdRecReserveItemsEx);
var
  dv : TDataRd;
begin
  if FOwner = nil then exit;
  dv := TDataRd(FOwner);
  dv.FOnRecDels.Notify(ts);
end;

{ TDataRd }

procedure TDataRdItems.OnRecRateChange(Sender: TObject;
  dr: TDataRdRecReserveItem);
var
  dv : TDataRd;
begin
  if FOwner = nil then exit;
  dv := TDataRd(FOwner);
  dv.DoRecRateChange(dr);
end;


//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataRd.Create;
begin
  FConfig := TDataConfigRd.Create;

  FItems := TDataRdItems.Create;
  FItems.FOwner := Self;
  FOnChangeAdd := TMultiEventSend.Create(nil);
  FOnChangeDel := TMultiEventSend.Create(nil);

  FOnRecAdds := TMultiEventSend.Create(nil);
  FOnRecDels := TMultiEventSend.Create(nil);
  FOnRecClr := TMultiEventSend.Create(nil);

end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataRd.Destroy;
begin
  FOnRecClr.Free;
  FOnRecDels.Free;
  FOnRecAdds.Free;
  FOnChangeDel.Free;
  FOnChangeAdd.Free;
  FItems.Free;
  FConfig.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@RD̎gp䐔ݒf[^ǂݍ݁@`                                //
//                                                                          //
//      t@Cǂݍ񂾐ݒlgpĂqcǗNX              //
//      Xgݒl`                                          //
//                                                                          //
//   - Input -  tt : f[^ǂݍޕ񃊃Xg                           //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataRd.DataLoadOld(tt: TStringListKey): Boolean;
var
  t,t2 : TStringListEx;
  j : Integer;
  d : TDataRdItem;
begin
  t := tt.Values['RDConfig'];
  t2 := TStringListEx.Create;
  try
    result := False;
    if t.GetInts('Version',-1) <> ConfigDataVersion then begin
      result := False;
      exit;
    end;
    for j := 1 to t.Count-1 do begin
      t2.CommaTextEx := t[j];
      d := FItems.Add();
      //d.FConfig.DataLoadOld(t2);
      //d.FGetRd.MatineCode := d.FConfig..MatineCode;  // ̕ӂ͉ǂKv
      //d.FGetRd.Config := d.FConfig;
      d.FGetRd.RdRec := d.FRecReserve;
    end;
    //Sort();
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataRd.DataLoad(tt: TStringListKey): Boolean;
var
  i,cnt : Integer;
  t : TStringListEx;
  dr : TDataRdItem;
begin
  FItems.Clear;
  t := tt.Values['RD_Config'];
  if t <> nil then begin
    cnt := t.GetInts('Count',0);
    for i := 0 to cnt-1 do begin
      dr := FItems.Add();
      t := tt.Values['RD_Config_'+IntToStr(i)];
      if t <> nil then begin
        //dr.FConfig.DataLoad(t);
      end;
      t := tt.Values['RD_Chanel_'+IntToStr(i)];
      if t <> nil then begin
        //dr.FConfig.Channels.DataLoadOld(t);
      end;
      //dr.FGetRd.MatineCode := dr.FConfig.MatineCode;  // ̕ӂ͉ǂKv
      //dr.FGetRd.Config.Assign(dr.FConfig);
      dr.FGetRd.RdRec := dr.FRecReserve;
    end;

  end;
  result := True;
end;


function TDataRd.DataConfigSave(tt: TStringListKey): Boolean;
var
  i : Integer;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    t.SetInts('Count',FItems.Count);
    tt.Add('RD_Config',t);
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      //FItems[i].FConfig.DataSave(t);
      tt.Add('RD_Config_'+IntToStr(i),t);
      t.Clear;
      //FItems[i].FConfig.Channels.DataSave(t);
      tt.Add('RD_Chanel_'+IntToStr(i),t);

    end;
    result := True;
  finally
    t.Free;
  end;

end;

function TDataRd.DataRecSave(tk: TStringListKey): Boolean;
var
  i : Integer;
  t : TStringListEx;
  s : string;
begin
  t := TStringListEx.Create;
  try
    result := False;
    t.SetInts('Count',FItems.Count);
    tk.Add('RD',t);
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      s := 'RD_' + IntToStr(i);
      FItems[i].RecReserve.DataSave(tk,s);

    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRd.DataRecLoad(tk: TStringListKey): Boolean;
var
  i : Integer;
  t : TStringListEx;
  s : string;
begin
  t := TStringListEx.Create;
  try
    result := False;
    //cnt := t.GetInts('Count');
    for i := 0 to FItems.Count-1 do begin
      s := 'RD_' + IntToStr(i);
      FItems[i].RecReserve.DataLoad(tk,s);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRd.DataInfoLoad(): Boolean;
var
  aInfo : TDataRdRecReserveInfo;
  aConfig : TDataConfigRdItem;
  i : Integer;
  s : string;
  tk: TStringListKey;
begin
  tk := TStringListKey.Create;
  try
    result := False;
    if not FileExists(GetFileNameInfo()) then exit;
    tk.LoadFromFile(GetFileNameInfo());
    for i := 0 to FItems.Count-1 do begin
      aInfo := FItems[i].FGetRd.RdInfo;
      aConfig := FItems[i].FGetRd.Config;
      s := aConfig.Name;
      aInfo.DataLoad(tk,s);
    end;
    result := True;
  finally
    tk.Free;
  end;
end;

function TDataRd.DataInfoSave(): Boolean;
var
  aInfo : TDataRdRecReserveInfo;
  aConfig : TDataConfigRdItem;
  i : Integer;
  s : string;
  tk : TStringListKey;
begin
  tk := TStringListKey.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      aInfo := FItems[i].FGetRd.RdInfo;
      aConfig := FItems[i].FGetRd.Config;
      s := aConfig.Name;
      //if aInfo.Changed then begin
        aInfo.DataSave(tk,s);
      //end;  
    end;
    tk.SaveToFile(GetFileNameInfo());
    result := True;
  finally
    tk.Free;
  end;

end;

procedure TDataRd.SetConfig(const Value: TDataConfigRd);
var
  i : Integer;
  dr : TDataRdItem;
  d : TDataConfigRdItem;
begin
  FConfig.Assign(Value);

  FItems.Clear;
  for i := 0 to FConfig.Items.Count-1 do begin
    dr := FItems.Add();
    d := FConfig.Items[i];
    dr.FGetRd.Engine := DM.Define.Rd.Matines[d.MatineName].Engine;  // ̕ӂ͉ǂKv
    dr.FGetRd.RdInfo := DM.Config.Rd.Items[i].Info;
    dr.FGetRd.Config.Assign(d);
    dr.FGetRd.Define.Assign(DM.Define.Rd.Matines[d.MatineName]);
    dr.FGetRd.RdRec := dr.FRecReserve;
  end;
  DataInfoLoad();
end;


procedure TDataRd.DoRecRateChange(dr: TDataRdRecReserveItem);
begin
  if Assigned(FOnRecChange) then begin
    FOnRecChange(Self,dr);
  end;  
end;

function TDataRd.GetFileNameInfo: string;
var
  s : string;
begin
  s := GetFilePathTemp();
  s := s + 'tmp_rd_info.ini';
  result := s;
end;

end.
