//**************************************************************************//
//                                                                          //
//  RD̋@했̈ႢǗNX                                        //
//                                                                          //
//**************************************************************************//
unit DataDefineRd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,StringListEx,StringListKey,DataRdRecReserveEncode;

//--------------------------------------------------------------------------//
//  ʐM̕ƂāEEE                                                  //
//--------------------------------------------------------------------------//
type
  TDataDefineRdItemEngineMode = (reRD_X5,reRD_H1,reRD_XS46,reRD_H1EX,reRD_XS48,reRD_XD91);
const
  TDataDefineRdItemEngineModeStr : array[0..5] of string =
                                ('RD-X5','RD-H1','RD-XS46','RD-H1EX','RD-XS48','RD-XD91');

//--------------------------------------------------------------------------//
//  RD̋@했̈ႢǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataDefineRdItem = class(TPersistent)
  private
    { Private 錾 }
    FFolder: Boolean;                 // True : tH_@\L
    FName: string;                    // @햼
    //FMatineCode: TDataRdMatineMode;   // @\^
    FAspect : Boolean;                // DVDL^̉ʔ䗦
    FChapterDvd : Boolean;            // DVD-Video`v^[
    FChapterMultiVoice : Boolean;     // True:d`v^[@\
    FChapterSilent : Boolean;         // `v^[

    FAudioLine : Boolean;             // C͐؂ւ
    FNetNaviVer: Integer;             // lbgDEir̎ނ\
    //FPanelUse: Integer;             // True:dAC@\Li폜j
    //FRateVer: Integer;                // }jA[gꗗ̎
    FEncoderMax: Integer;             // ^`[i[̐
    //FUseBsAnalog : Boolean;           // True : arAiO`[i[L
    //FExternalLineMax : Integer;       // O͂̐
    FLinkageCsAnalog: Boolean;        // True:brAiOA@\L
    FNetNaviSelectStyle: Boolean;     // True:lbgDEirSelect^uĂ
    FEx5 : Boolean;                   // True:EXꂽX5 XS46 XS36
    FEngine: TDataDefineRdItemEngineMode;
    FEncode: TDataRdRecReserveEncode;
    function GetEngineStr: string;
    procedure SetEngineStr(const Value: string); // Ɏgp鏈

  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    property Name : string read FName write FName;
    property Aspect : Boolean read FAspect write FAspect;
    property ChapterDvd : Boolean read FChapterDvd write FChapterDvd;
    property ChapterMultiVoice : Boolean read FChapterMultiVoice write FChapterMultiVoice;
    property ChapterSilent : Boolean read FChapterSilent write FChapterSilent;

    property AudioLine : Boolean read FAudioLine;

    property Folder : Boolean read FFolder write FFolder;
    //property MatineCode : TDataRdMatineMode read FMatineCode;
    property NetNaviVer : Integer read FNetNaviVer;
    //property PanelUse : Integer read FPanelUse;
    //property RateVer : Integer read FRateVer;
    property EncoderMax : Integer read FEncoderMax;
    //property UseBsAnalog : Boolean read FUseBsAnalog;
    //property ExternalLineMax : Integer read FExternalLineMax;
    property LinkageCsAnalog : Boolean read FLinkageCsAnalog;
    property NetNaviSelectStyle : Boolean read FNetNaviSelectStyle;
    property Ex5 : Boolean read FEx5;
    property Engine : TDataDefineRdItemEngineMode read FEngine write FEngine;
    property EngineStr : string read GetEngineStr write SetEngineStr;
    property Encode : TDataRdRecReserveEncode read FEncode;
  end;

//--------------------------------------------------------------------------//
//  RD̋@했̈ႢǗ郊XgNX                                  //
//--------------------------------------------------------------------------//
type
  TDataDefineRdItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataDefineRdItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TDataDefineRdItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataDefineRdItem read GetItems;default;
    procedure Assign(a : TDataDefineRdItems);
    function IndexOfName(MatineName : string) : Integer;
  end;

//--------------------------------------------------------------------------//
//  RD̋@했̈ႢǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataDefineRd = class(TPersistent)
  private
    { Private 錾 }
    FItems: TDataDefineRdItems;
    function GetMatines(MatineName: string): TDataDefineRdItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    property Items : TDataDefineRdItems read FItems;

    function DataLoadOld(tk : TStringListKey) : Boolean;
    function DataLoad(tk : TStringListKey) : Boolean;
    function DataSave(tk : TStringListKey) : Boolean;

    property Matines[MatineName : string] : TDataDefineRdItem read GetMatines;
  end;

implementation

{ TDataDefineRd }

constructor TDataDefineRd.Create;
begin
  FItems := TDataDefineRdItems.Create;
end;

destructor TDataDefineRd.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataDefineRd.Assign(Source: TPersistent);
var
  a : TDataDefineRd;
begin
  if Source is TDataDefineRd then begin
    a := TDataDefineRd(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataDefineRd.DataLoad(tk: TStringListKey): Boolean;
var
  i : Integer;
  t,tt : TStringListEx;
  d : TDataDefineRdItem;
  s : string;
begin
  result := False;
  FItems.Clear;
  t := tk.Values['RD'];
  if t = nil then exit;
  //tt := TStringListEx.Create;
  try
    for i := 0 to t.Count-1 do begin
      s := t[i];
      tt := tk.Values[s];
      if tt = nil then continue;
      d := FItems.Add();
      d.DataLoad(tt);
      s := t[i] + '_Encode';
      tt := tk.Values[s];
      if tt = nil then continue;
      d.Encode.DataLoad(tt);
    end;
  finally
    //tt.Free;
  end;
end;

function TDataDefineRd.DataLoadOld(tk: TStringListKey): Boolean;
var
  i : Integer;
  t,tt : TStringListEx;
  d : TDataDefineRdItem;
begin
  result := False;
  FItems.Clear;
  t := tk.Values['RD'];
  if t = nil then exit;
  tt := TStringListEx.Create;
  try
    for i := 0 to t.Count-1 do begin
      tt.CommaTextEx := t[i];
      d := FItems.Add();
      d.DataLoad(tt);
    end;
  finally
    tt.Free;
  end;


end;

function TDataDefineRd.DataSave(tk: TStringListKey): Boolean;
var
  i : Integer;
  t,tt : TStringListEx;
  d : TDataDefineRdItem;
  s : string;
begin
  t := TStringListEx.Create;
  tt := TStringListEx.Create;
  try
    result := False;
    tk.Add('RD',t);
    for i := 0 to FItems.Count-1 do begin
      d := FItems[i];
      t.SetStr(d.FName);
      tt.Clear;
      s := d.FName;
      d.DataSave(tt);
      tk.Add(s,tt);
      tt.Clear;
      s := d.FName + '_Encode';
      d.Encode.DataSave(tt);
      tk.Add(s,tt);

    end;
    tk.Add('RD',t);
    result := True;
  finally
    tt.Free;
    t.Free;
  end;


end;

function TDataDefineRd.GetMatines(MatineName: string): TDataDefineRdItem;
var
  i : Integer;
begin
  result := nil;
  i := FItems.IndexOfName(MatineName);

  //i := FList.IndexOf(MatineName);
  if i = -1 then exit;
  result := FItems[i];
end;

{ TDataDefineRdItems }

destructor TDataDefineRdItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataDefineRdItems.Add: TDataDefineRdItem;
var
  d : TDataDefineRdItem;
begin
  d := TDataDefineRdItem.Create();
  inherited Add(d);
  result := d;
end;

procedure TDataDefineRdItems.Assign(a: TDataDefineRdItems);
var
  i : Integer;
  d : TDataDefineRdItem;
begin
  Clear();
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a[i]);
  end;
end;

procedure TDataDefineRdItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataDefineRdItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataDefineRdItems.GetItems(Index: Integer): TDataDefineRdItem;
begin
  result := inherited Items[Index];
end;

function TDataDefineRdItems.IndexOfName(MatineName: string): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[I].Name = MatineName then begin
      result := i;
      exit;
    end;
  end;

end;

{ TDataDefineRdItem }

constructor TDataDefineRdItem.Create;
begin
  FEncode := TDataRdRecReserveEncode.Create;
end;

destructor TDataDefineRdItem.Destroy;
begin
  FEncode.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                  //
//                                                                          //
//   - Input -  Source :                                              //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataDefineRdItem.Assign(Source: TPersistent);
var
  a : TDataDefineRdItem;
begin
  if Source is TDataDefineRdItem then begin
    a := TDataDefineRdItem(Source);
    FName             := a.FName;
    FFolder           := a.FFolder;
    //FMatineCode       := a.FMatineCode;
    FAspect           := a.FAspect;
    FChapterDvd       := a.FChapterDvd;
    FChapterMultiVoice := a.FChapterMultiVoice;
    FChapterSilent     := a.FChapterSilent;
    FAudioLine        := a.FAudioLine;
    FNetNaviVer       := a.FNetNaviVer;
    //FPanelUse := a.FPanelUse;
    //FRateVer          := a.FRateVer;
    FEncoderMax       := a.FEncoderMax;
    //FUseBsAnalog      := a.FUseBsAnalog;
    //FExternalLineMax  := a.FExternalLineMax;
    FLinkageCsAnalog  := a.FLinkageCsAnalog;
    FNetNaviSelectStyle := a.FNetNaviSelectStyle;
    FEx5                := a.FEx5;
    FEngine             := a.FEngine;
    FEncode.Assign(a.FEncode);
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^ǂݍ݁@`                                                  //
//                                                                          //
//   - Input -  t : f[^ǂݍޕ񃊃Xg                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataDefineRdItem.DataLoad(t: TStringListEx): Boolean;
begin
  FName := t.GetStrs('Name',FName);
  FFolder := t.GetBools('Folder',FFolder);
  FAspect     := t.GetBools('Aspect',FAspect);
  FChapterDvd := t.GetBools('ChapterDvd',FChapterDvd);
  FChapterMultiVoice := t.GetBools('ChapterMultiVoice',FChapterMultiVoice);
  FChapterSilent := t.GetBools('ChapterSilent',FChapterSilent);
  FAudioLine := t.GetBools('AudioLine',FAudioLine);
  FNetNaviVer := t.GetInts('NetNaviVer',FNetNaviVer);
  //FPanelUse := t.GetInts('PanelUse',FPanelUse);
  //FRateVer  := t.GetInts('RateVer',FRateVer);
  FEncoderMax := t.GetInts('EncoderMax',FEncoderMax);
  //FUseBsAnalog := t.GetBools('UseBsAnalog',FUseBsAnalog);
  //FExternalLineMax := t.GetInts('ExternalLineMax',FExternalLineMax);
  FLinkageCsAnalog := t.GetBools('LinkageCsAnalog',FLinkageCsAnalog);
  FNetNaviSelectStyle := t.GetBools('NetNaviSelectStyle',FNetNaviSelectStyle);
  FEx5 := t.GetBools('Ex5',FEx5);
  FEngine := TDataDefineRdItemEngineMode(t.GetInts('Engine',0));
  EngineStr := t.GetStrs('EngineStr','');
  result := True;
end;

function TDataDefineRdItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Name',FName);
  t.SetBools('Folder',FFolder);
  t.SetBools('Aspect',FAspect);
  t.SetBools('ChapterDvd',FChapterDvd);
  t.SetBools('ChapterMultiVoice',FChapterMultiVoice);
  t.SetBools('ChapterSilent',FChapterSilent);
  t.SetBools('AudioLine',FAudioLine);
  t.SetInts('NetNaviVer',FNetNaviVer);
  //FPanelUse := t.GetInts('PanelUse',FPanelUse);
  //t.SetInts('RateVer',FRateVer);
  t.SetInts('EncoderMax',FEncoderMax);
  //t.SetBools('UseBsAnalog',FUseBsAnalog);
  //t.SetInts('ExternalLineMax',FExternalLineMax);
  t.SetBools('LinkageCsAnalog',FLinkageCsAnalog);
  t.SetBools('NetNaviSelectStyle',FNetNaviSelectStyle);
  t.SetBools('Ex5',FEx5);
  t.SetInts('Engine',Ord(FEngine));
  t.SetStrs('EngineStr',EngineStr);
  result := True;
end;


function TDataDefineRdItem.GetEngineStr: string;
var
  i : Integer;
begin
  i := Ord(FEngine);
  result := TDataDefineRdItemEngineModeStr[i];
end;

procedure TDataDefineRdItem.SetEngineStr(const Value: string);
var
  i : Integer;

begin
  FEngine := reRD_X5;
  for i := 0 to High(TDataDefineRdItemEngineModeStr) do begin
    if TDataDefineRdItemEngineModeStr[i] = Value then begin
      FEngine := TDataDefineRdItemEngineMode(i);
      break;
    end;
  end;

end;

end.
