unit DataDefine;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,  StringListEx,StringListKey,
  DataDefineRd,DataConfigTvGenre,DataTvColumn;

//--------------------------------------------------------------------------//
//  Ղ̃f[^ǗNX                                            //
//--------------------------------------------------------------------------//
type
  TDataDefine = class(TPersistent)
  private
    { Private 錾 }
    FRd: TDataDefineRd;
    FGenre: TDataConfigTvGenre;
    FTvColumn : TDataTvColumn;
    function GetFileName() : string;
    function GetFileName2() : string;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataLoad() : Boolean;
    function DataLoadOld() : Boolean;
    function DataSave() : Boolean;

    property Rd : TDataDefineRd read FRd;
    property Genre : TDataConfigTvGenre read FGenre;
    property TvColumn : TDataTvColumn read FTvColumn;

  end;

implementation

{ TDataDefine }

constructor TDataDefine.Create;
begin
  FRd := TDataDefineRd.Create;
  FGenre := TDataConfigTvGenre.Create;
  FTvColumn := TDataTvColumn.Create;
end;

destructor TDataDefine.Destroy;
begin
  FTvColumn.Free;
  FGenre.Free;
  FRd.Free;
  inherited;
end;

procedure TDataDefine.Assign(Source: TPersistent);
var
  a : TDataDefine;
begin
  if Source is TDataDefine then begin
    a := TDataDefine(Source);
    FRd.Assign(a.FRd);
    FTvColumn.Assign(a.FTvColumn);
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@ݒt@Cf[^ǂݍ݁@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TDataDefine.DataLoad: Boolean;
var
  tk : TStringListKey;
  s : string;
begin
  result := False;
  s := GetFileName();
  if not FileExists(s) then exit;
  tk := TStringListKey.Create;
  try
    tk.LoadFromFile(s);                         // ݒۑt@Cǂݍ
    FRd.DataLoad(tk);
    FGenre.DataLoad(tk);
    FTvColumn.DataLoad(tk);
    result := True;
  finally
    tk.Free;
  end;
end;

function TDataDefine.DataLoadOld: Boolean;
var
  tk : TStringListKey;
  s : string;
begin
  result := False;
  s := GetFileName2();
  if not FileExists(s) then exit;
  tk := TStringListKey.Create;
  try
    tk.LoadFromFile(s);                         // ݒۑt@Cǂݍ
    FRd.DataLoadOld(tk);
    result := True;
  finally
    tk.Free;
  end;
end;

function TDataDefine.DataSave: Boolean;
var
  tk : TStringListKey;
  s : string;
begin
  s := GetFileName();
  tk := TStringListKey.Create;
  try
    result := False;
    FGenre.DataSave(tk);
    FRd.DataSave(tk);
    FTvColumn.DataSave(tk);
    tk.SaveToFile(s);
    result := True;
  finally
    tk.Free;
  end;
end;

function TDataDefine.GetFileName: string;
begin
  result := ExtractFilePath(Application.ExeName) + 'define.ini';
end;

function TDataDefine.GetFileName2: string;
begin
  result := ExtractFilePath(Application.ExeName) + 'define2.ini';
end;

end.
