unit DataCursorRd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,DataTvSchedule,
  StringListEx,StringListKey,DataRdRecReserve;

//--------------------------------------------------------------------------//
//  \IJ[\NX                                                  //
//--------------------------------------------------------------------------//
type
  TDataCursorRd = class(TPersistent)
  private
    { Private 錾 }
    FRd : TDataRdRecReserveItem;
    FOnChange: TMultiEventSend;             // vfǉɔCxgNX

    procedure DoChangeTv();

    procedure SetRd(const Value: TDataRdRecReserveItem);
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    property Rd : TDataRdRecReserveItem read FRd write SetRd;

    // J[\ύXCxg
    property OnChange : TMultiEventSend read FOnChange;
  end;

implementation

{ TDataCursorRd }

constructor TDataCursorRd.Create;
begin
  FOnChange := TMultiEventSend.Create(nil);
end;

destructor TDataCursorRd.Destroy;
begin
  FOnChange.Free;
  inherited;
end;

procedure TDataCursorRd.DoChangeTv;
begin
  FOnChange.Notify(nil);
end;

procedure TDataCursorRd.SetRd(const Value: TDataRdRecReserveItem);
begin
  FRd := Value;
  DoChangeTv();
end;


end.
