//**************************************************************************//
//                                                                          //
//  suԑg\Xg̐ݒf[^ǗNX                              //
//                                                                          //
//**************************************************************************//
unit DataConfigTvScheduleColumn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,StringListEx,StringListKey;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataConfigTvScheduleColumnItem = class(TPersistent)
  private
    { Private 錾 }
    FWidth: Integer;                  // Xg̉
    FMode: Integer;                   //
    FCaption: string;                 // ڂ̖
    FComment: string;                 //
    function DataLoad(t : TStringListEx) : Boolean;
    function DataLoadDef(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;

    property Caption : string read FCaption;
    property Comment : string read FComment;
    property Mode : Integer read FMode;
    property Width : Integer read FWidth write FWidth;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗ郊XgNX                                  //
//--------------------------------------------------------------------------//
type
  TDataConfigTvScheduleColumnItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataConfigTvScheduleColumnItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TDataConfigTvScheduleColumnItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataConfigTvScheduleColumnItem read GetItems;default;
    procedure Assign(a : TDataConfigTvScheduleColumnItems);

    function DataLoadDef(t : TStringListEx) : Boolean;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

  end;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataConfigTvScheduleColumn = class(TPersistent)
  private
    { Private 錾 }
    FColumns : TDataConfigTvScheduleColumnItems;
    FListFontSize : Integer;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    function DataLoadDef(tt : TStringListKey) : Boolean;
    function DataLoad(tk: TStringListKey) : Boolean;
    function DataSave(tk: TStringListKey) : Boolean;

    property Columns : TDataConfigTvScheduleColumnItems read FColumns;
    property ListFontSize : Integer read FListFontSize write FListFontSize;
  end;


implementation

{ TDataListViewTvColumnItems }

procedure TDataConfigTvScheduleColumnItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataConfigTvScheduleColumnItems.Add: TDataConfigTvScheduleColumnItem;
var
  d : TDataConfigTvScheduleColumnItem;
begin
  d := TDataConfigTvScheduleColumnItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataConfigTvScheduleColumnItems.Assign(a: TDataConfigTvScheduleColumnItems);
var
  i : Integer;
  d : TDataConfigTvScheduleColumnItem;
begin
  Clear();
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a[i]);
  end;
end;

procedure TDataConfigTvScheduleColumnItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

function TDataConfigTvScheduleColumnItems.DataLoadDef(t : TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TDataConfigTvScheduleColumnItem;
begin
  result := False;
  //t := DMDef.Keys.Values['TvColumn'];
  if t = nil then exit;
  t2 := TStringListEx.Create;
  try
    Clear;
    for i := 0 to t.Count-1 do begin
      d := Add();
      t2.CommaTextEx := t[i];
      d.DataLoadDef(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataConfigTvScheduleColumnItems.DataLoad(t : TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TDataConfigTvScheduleColumnItem;
begin
  result := False;
  //t := DMSave.Keys.Values['TvColumnPro'];
  if t = nil then exit;
  t2 := TStringListEx.Create;
  try
    result := False;
    Clear;
    for i := 0 to t.Count-1 do begin
      d := Add();
      t2.CommaTextEx := t[i];
      d.DataLoad(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataConfigTvScheduleColumnItems.DataSave(t : TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TDataConfigTvScheduleColumnItem;
begin
  t := TStringListEx.Create;
  t2 := TStringListEx.Create;
  try
    result := False;
    for i := 0 to Count-1 do begin
      d := Items[i];
      t2.Clear;
      d.DataSave(t2);
      t.Add(t2.CommaTextEx);
    end;
    //DMSave.Keys.Add('TvColumnPro',t);
    result := True;
  finally
    t2.Free;
    t.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataConfigTvScheduleColumnItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataConfigTvScheduleColumnItems.GetItems(Index: Integer): TDataConfigTvScheduleColumnItem;
begin
  result := inherited Items[Index];
end;


{ TDataListViewTvColumnItem }

procedure TDataConfigTvScheduleColumnItem.Assign(Source: TPersistent);
var
  a : TDataConfigTvScheduleColumnItem;
begin
  if Source is TDataConfigTvScheduleColumnItem then begin
    a := TDataConfigTvScheduleColumnItem(Source);
    FComment := a.FComment;
    FCaption := a.FCaption;
    FMode := a.FMode;
    FWidth := a.FWidth;
  end
  else begin
    inherited;
  end;
end;

function TDataConfigTvScheduleColumnItem.DataLoad(t: TStringListEx): Boolean;
begin
  FComment := t.GetStrs('Comment',FComment);
  FCaption := t.GetStrs('Caption',FCaption);
  FMode := t.GetInts('Mode',FMode);
  FWidth := t.GetInts('Width',FWidth);
  result := True;
end;

function TDataConfigTvScheduleColumnItem.DataLoadDef(t: TStringListEx): Boolean;
begin
  FComment := t.GetStr();
  FCaption := t.GetStr();
  FMode := t.GetInt();
  FWidth := t.GetInt();
  result := True;
end;

function TDataConfigTvScheduleColumnItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Comment',FComment);
  t.SetStrs('Caption',FCaption);
  t.SetInts('Mode',FMode);
  t.SetInts('Width',FWidth);
  result := True;
end;

{ TDataListViewTv }

constructor TDataConfigTvScheduleColumn.Create;
begin
  FColumns := TDataConfigTvScheduleColumnItems.Create;
  FListFontSize := 12;
end;

destructor TDataConfigTvScheduleColumn.Destroy;
begin
  FColumns.Free;
  inherited;
end;

function TDataConfigTvScheduleColumn.DataLoad(tk: TStringListKey): Boolean;
var
  t : TStringListEx;
begin
  result := False;
  FColumns.Clear;
  t := tk.Values['TvColumn'];
  if t = nil then exit;
  FColumns.DataLoad(t);
  result := True;
end;

function TDataConfigTvScheduleColumn.DataLoadDef(tt : TStringListKey): Boolean;
var
  t : TStringListEx;
begin
  t := tt.Values['TvColumn'];
  FColumns.DataLoadDef(t);
  result := True;
end;

function TDataConfigTvScheduleColumn.DataSave(tk: TStringListKey): Boolean;
begin
  result := True;
end;

procedure TDataConfigTvScheduleColumn.Assign(Source: TPersistent);
var
  a : TDataConfigTvScheduleColumn;
begin
  if Source is TDataConfigTvScheduleColumn then begin
    a := TDataConfigTvScheduleColumn(Source);
    FColumns.Assign(a.FColumns);
    FListFontSize := a.FListFontSize;
  end
  else begin
    inherited;
  end;
end;

end.
