//**************************************************************************//
//                                                                          //
//  ԑg\̖m̃WRD̃Wɕϊ邽߂̃NX              //
//                                                                          //
//  łxĂWƃ[U[Œǉ            //
//    WƂ                                                      //
//                                                                          //
//                                                                          //
//**************************************************************************//
unit DataConfigTvGenre;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,StringListEx,StringListKey,DefaultData,DataTvScheduleGenre;

//--------------------------------------------------------------------------//
//  RDMł`lf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataConfigTvGenreItem = class(TPersistent)
  private
    { Private 錾 }
    FName: string;                         // ԑg\ŎgW
    FMode: TDataTvScheduleGenre;           // W
    FColorBack : TColor;                   // ԑg\ł̔wiF
    FColorBack2 : TColor;
    FBrushStyle : TBrushStyle;
    FColorTitle: TColor;
    FColorComment: TColor;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    // W\F̂ݑ
    procedure AssignColor(Source : TDataConfigTvGenreItem);
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    // NX̓er@Sv True
    function Compari(d : TDataConfigTvGenreItem) : Boolean;
    // ԑg\ŎgW
    property Name : string read FName write FName;
    // W
    property Mode : TDataTvScheduleGenre read FMode write FMode;
    // ԑg\ł̔wiF
    property ColorBack : TColor read FColorBack write FColorBack;
    // ԑg\ł̔wiF
    property ColorBack2 : TColor read FColorBack2 write FColorBack2;
    // wiF̓hׂp^[
    property BrushStyle : TBrushStyle read FBrushStyle write FBrushStyle;
    // ԑg\F
    property ColorTitle : TColor read FColorTitle write FColorTitle;
    // ԑg\F
    property ColorComment : TColor read FColorComment write FColorComment;
  end;

//--------------------------------------------------------------------------//
//  suԑgŎgpWꗗǗNX                              //
//--------------------------------------------------------------------------//
type
  TDataConfigTvGenreItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataConfigTvGenreItem;
    function GetGenres(GenreStr: string): TDataTvScheduleGenre;
  public
    { Public 錾 }
    destructor Destroy;override;
    procedure Assign(a : TDataConfigTvGenreItems) ;
    function Add() : TDataConfigTvGenreItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataConfigTvGenreItem read GetItems;default;

    function IndexOfGenre(d : TDataTvScheduleGenre) : Integer;
    property Genres[GenreStr : string] : TDataTvScheduleGenre read GetGenres;
  end;

//--------------------------------------------------------------------------//
//  suԑgŎgpWf[^ǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataConfigTvGenre = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataConfigTvGenreItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataConfigTvGenreItems read FItems;

    function DataLoad(tk : TStringListKey) : Boolean;
    function DataSave(tk : TStringListKey) : Boolean;

  end;

implementation

{ TDataTvGenre }

constructor TDataConfigTvGenre.Create;
begin
  FItems := TDataConfigTvGenreItems.Create;
end;

destructor TDataConfigTvGenre.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataConfigTvGenre.Assign(Source: TPersistent);
var
  a : TDataConfigTvGenre;
begin
  if Source is TDataConfigTvGenre then begin
    a := TDataConfigTvGenre(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataConfigTvGenre.DataLoad(tk: TStringListKey): Boolean;
var
  i : Integer;
  t,tt : TStringListEx;
  d : TDataConfigTvGenreItem;
begin
  result := False;
  FItems.Clear;
  t := tk.Values['TvGenre'];
  if t = nil then exit;
  tt := TStringListEx.Create;
  try
    for i := 0 to t.Count-1 do begin
      tt.CommaTextEx := t[i];
      d := FItems.Add();
      d.DataLoad(tt);
    end;
  finally
    tt.Free;
  end;
end;

function TDataConfigTvGenre.DataSave(tk: TStringListKey): Boolean;
var
  t,tt: TStringListEx;
  i : Integer;
  d : TDataConfigTvGenreItem;
begin
  t := TStringListEx.Create;
  tt := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      d := FItems[i];
      tt.Clear;
      d.DataSave(tt);
      t.Add(tt.CommaTextEx);
    end;
    tk.Add('TvGenre',t);
    result := True;
  finally
    tt.Free;
    t.Free;
  end;
end;

{ TDataTvGenreItems }

destructor TDataConfigTvGenreItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataConfigTvGenreItems.Add: TDataConfigTvGenreItem;
var
  d : TDataConfigTvGenreItem;
begin
  d := TDataConfigTvGenreItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataConfigTvGenreItems.Assign(a: TDataConfigTvGenreItems);
var
  d : TDataConfigTvGenreItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

procedure TDataConfigTvGenreItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataConfigTvGenreItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataConfigTvGenreItems.GetItems(Index: Integer): TDataConfigTvGenreItem;
begin
  result := inherited Items[Index];
end;

function TDataConfigTvGenreItems.IndexOfGenre(
  d: TDataTvScheduleGenre): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = d then begin
      result := i;
      exit;
    end;
  end;

end;

function TDataConfigTvGenreItems.GetGenres(
  GenreStr: string): TDataTvScheduleGenre;
var
  i : Integer;
begin
  result := rgEtc;
  for i := 0 to Count-1 do begin
     if Items[i].Name = GenreStr then begin
       result := Items[i].Mode;
       exit;
     end;
  end;

end;

{ TDataTvGenreItem }

procedure TDataConfigTvGenreItem.Assign(Source: TPersistent);
var
  a : TDataConfigTvGenreItem;
begin
  if Source is TDataConfigTvGenreItem then begin
    a := TDataConfigTvGenreItem(Source);
    FName := a.FName;
    FMode := a.FMode;
    FColorTitle := a.FColorTitle;
    FColorComment := a.FColorComment;
    AssignColor(a);
  end
  else begin
    inherited;
  end;
end;

procedure TDataConfigTvGenreItem.AssignColor(
  Source: TDataConfigTvGenreItem);
var
  a : TDataConfigTvGenreItem;
begin
  a := Source;
  FColorBack := a.FColorBack;
  FColorBack2 := a.FColorBack2;
  FBrushStyle := a.FBrushStyle;
end;

function TDataConfigTvGenreItem.Compari(
  d: TDataConfigTvGenreItem): Boolean;
begin
  result := False;
  if FColorBack  <> d.FColorBack  then exit;
  if FColorBack2 <> d.FColorBack2 then exit;
  if FBrushStyle <> d.FBrushStyle then exit;
  result := True;
end;

function TDataConfigTvGenreItem.DataLoad(t: TStringListEx): Boolean;
const TblColBack : array[0..9] of TColor = (clWhite,$02ECD7FC,$02FCCEFC,$02CEFCFC,
                                            $02FCFCCE,$02D7FCCE,$02CEEAFC,$02D7CEFC,
                                            $02CEFCFC,clWhite);
var
  s : string;
  i : Integer;
  c : TColor;
begin
  FName := t.GetStrs('Name',FName);
  FMode := TDataTvScheduleGenre(t.GetInts('Mode',Ord(rgEtc)));
  i := Ord(FMode);        // qcւ̃WwCfbNXƂ
  c := TblColBack[i];     // l
  FColorBack := t.GetColors('ColorBack',c);
  FColorBack2 := t.GetColors('ColorBack2',FColorBack);
  FBrushStyle := TBrushStyle(t.GetInts('BlushStyle',0));
  FColorTitle := t.GetColors('ColorTitle',clBlue);
  FColorComment := t.GetColors('ColorComment',clBlack);
  result := True;
end;

function TDataConfigTvGenreItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Name',FName);
  t.SetInts('Mode',Ord(FMode));
  t.SetColors('ColorBack',FColorBack);
  t.SetColors('ColorBack2',FColorBack2);
  t.SetInts('BlushStyle',Ord(FBrushStyle));
  t.SetColors('ColorTitle',FColorTitle);
  t.SetColors('ColorComment',FColorComment);
  result := True;
end;

end.
