unit DataConfigRdConfigEncode;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime,
  DataConfigRdChannel,DataRdRecReserveInfo,DataRdRecReserveEncode;

//--------------------------------------------------------------------------//
//  ǗRD̐ݒf[^NX                                            //
//--------------------------------------------------------------------------//
type
  TDataConfigRdConfigEncodeItem = class(TPersistent)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveEncodeItemMode;
    FColorBack: TColor;
    FColorEdge: TColor;
    FColorFont: TColor;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    // ΏۂƂȂGR[_
    property Mode : TDataRdRecReserveEncodeItemMode read FMode;
    // ԑg\ł̕\wiF
    property ColorBack : TColor read FColorBack write FColorBack;
    // ԑg\ł̉F
    property ColorEdge : TColor read FColorEdge write FColorEdge;
    // ԑg\ł̕\F
    property ColorFont : TColor read FColorFont write FColorFont;
  end;

//--------------------------------------------------------------------------//
//  ǗRD̈ꗗf[^NX                                            //
//--------------------------------------------------------------------------//
type
  TDataConfigRdConfigEncodeItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataConfigRdConfigEncodeItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    procedure Assign(a : TDataConfigRdConfigEncodeItems) ;
    function Add() : TDataConfigRdConfigEncodeItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataConfigRdConfigEncodeItem read GetItems;default;

    function IndexOfMode(aMode : TDataRdRecReserveEncodeItemMode) : Integer;
  end;

//--------------------------------------------------------------------------//
//  ǗRD̃GR[_ݒf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataConfigRdConfigEncode = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataConfigRdConfigEncodeItems;
    function GetModes(
      aMode: TDataRdRecReserveEncodeItemMode): TDataConfigRdConfigEncodeItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataConfigRdConfigEncodeItems read FItems;
    property Modes[aMode : TDataRdRecReserveEncodeItemMode] : TDataConfigRdConfigEncodeItem
                    read GetModes;

    function DataLoad(ts: TStringListEx) : Boolean;
    function DataSave(ts: TStringListEx) : Boolean;
  end;

implementation

{ TDataConfigRdEncode }

constructor TDataConfigRdConfigEncode.Create;
begin
  FItems := TDataConfigRdConfigEncodeItems.Create;
end;

destructor TDataConfigRdConfigEncode.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataConfigRdConfigEncode.Assign(Source: TPersistent);
var
  a : TDataConfigRdConfigEncode;
begin
  if Source is TDataConfigRdConfigEncode then begin
    a := TDataConfigRdConfigEncode(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataConfigRdConfigEncode.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataConfigRdConfigEncodeItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataConfigRdConfigEncode.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataConfigRdConfigEncodeItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataConfigRdEncodeItems }

destructor TDataConfigRdConfigEncodeItems.Destroy;
begin
  Clear();
  inherited;
end;

procedure TDataConfigRdConfigEncodeItems.Assign(a: TDataConfigRdConfigEncodeItems);
var
  d : TDataConfigRdConfigEncodeItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataConfigRdConfigEncodeItems.Add: TDataConfigRdConfigEncodeItem;
var
  d : TDataConfigRdConfigEncodeItem;
begin
  d := TDataConfigRdConfigEncodeItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataConfigRdConfigEncodeItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataConfigRdConfigEncodeItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataConfigRdConfigEncodeItems.GetItems(
  Index: Integer): TDataConfigRdConfigEncodeItem;
begin
  result := inherited Items[Index];
end;

function TDataConfigRdConfigEncodeItems.IndexOfMode(
  aMode: TDataRdRecReserveEncodeItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = aMode then begin
      result := i;
      exit;
    end;
  end;

end;

{ TDataConfigRdEncodeItem }

constructor TDataConfigRdConfigEncodeItem.Create;
begin
  FColorBack := clRed;   // qc̗\\̊{F͐
end;

destructor TDataConfigRdConfigEncodeItem.Destroy;
begin
  inherited;
end;

procedure TDataConfigRdConfigEncodeItem.Assign(Source: TPersistent);
var
  a : TDataConfigRdConfigEncodeItem;
begin
  if Source is TDataConfigRdConfigEncodeItem then begin
    a := TDataConfigRdConfigEncodeItem(Source);
    FMode := a.FMode;
    FColorBack := a.FColorBack;
    FColorEdge := a.FColorEdge;
    FColorFont := a.FColorFont;
  end
  else begin
    inherited;
  end;
end;

function TDataConfigRdConfigEncodeItem.DataLoad(t: TStringListEx): Boolean;
var
  s : string;
begin
  s := t.GetStrs('Mode','');
  FMode := StrToEncodeMode(s);
  FColorBack := t.GetColors('ColorBack',clRed);
  FColorEdge := t.GetColors('ColorEdge',clBlack);
  FColorFont := t.GetColors('ColorFont',clWhite);
end;

function TDataConfigRdConfigEncodeItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Mode',EncodeModeToStr(FMode));
  t.SetColors('ColorBack',FColorBack);
  t.SetColors('ColorEdge',FColorEdge);
  t.SetColors('ColorFont',FColorFont);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Yqc̃GR[_ݒNX擾@`                        //
//                                                                          //
//   - Input -  aMode : GR[_                                      //
//                                                                          //
//   - Output - GR[_ݒNX                                        //
//                                                                          //
//   YݒNX݂ȂꍇIɐ                   //
//                                                                          //
//--------------------------------------------------------------------------//
function TDataConfigRdConfigEncode.GetModes(
  aMode: TDataRdRecReserveEncodeItemMode): TDataConfigRdConfigEncodeItem;
var
  i : Integer;
  d : TDataConfigRdConfigEncodeItem;
begin
  i := FItems.IndexOfMode(aMode);       // Xgɂłɑ݂邩
  if i >= 0 then begin                  // ݂ꍇ
    result := FItems[i];                // YNXԂ
  end
  else begin                            // ݂Ȃꍇ
    d := FItems.Add();                  // NXꗗɒǉ
    d.FMode := aMode;                   // vfƂăGR[_ʂi[
    result := d;                        // ǉNXԂ
  end;
end;

end.
