unit DataConfigRdConfig;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,StringListKey,
  StringListEx,DataConfigRdConfigEncode;

//--------------------------------------------------------------------------//
//  RDPŋʂ̏ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataConfigRdConfig = class(TPersistent)
  private
    { Private 錾 }
    FEncode : TDataConfigRdConfigEncode;
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataSave(tk : TStringListKey;Name : string) : Boolean;
    function DataLoad(tk : TStringListKey;Name : string) : Boolean;

    property Encode : TDataConfigRdConfigEncode read FEncode;
  end;

implementation

{ TDataRdRecReserveInfo }

constructor TDataConfigRdConfig.Create;
begin
  FEncode := TDataConfigRdConfigEncode.Create;
end;

destructor TDataConfigRdConfig.Destroy;
begin
  FEncode.Free;
  inherited;
end;

procedure TDataConfigRdConfig.Assign(Source: TPersistent);
var
  a : TDataConfigRdConfig;
begin
  if Source is TDataConfigRdConfig then begin
    a := TDataConfigRdConfig(Source);
    FEncode.Assign(a.FEncode);
  end
  else begin
    inherited;
  end;
end;

function TDataConfigRdConfig.DataLoad(tk: TStringListKey;
  Name: string): Boolean;
var
  ts : TStringListEx;
begin
  ts := tk.Values[Name + '_Encode'];
  if ts <> nil then begin
    FEncode.DataLoad(ts);
  end;
  result := True;
end;

function TDataConfigRdConfig.DataSave(tk: TStringListKey;
  Name: string): Boolean;
var
  ts : TStringListEx;
begin
  ts := TStringListEx.Create;
  try
    result := False;
    ts.Clear;
    FEncode.DataSave(ts);
    tk.Add(Name + '_Encode',ts);
    result := True;
  finally
    ts.Free;
  end;
end;

end.
