unit DataConfigRdChannel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime;

//--------------------------------------------------------------------------//
//  RDMł`lf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataConfigRdChannelLineItem = class(TPersistent)
  private
    { Private 錾 }
    FLine: string;                        // `lԍ
    FLineXD: Integer;                      // `lԍCfbNXChannelNamesQ
    FChannelEx: Integer;
    FChannelTv: Integer;
  public
    { Public 錾 }
    //constructor Create;
    //destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    property Line : string read FLine write FLine;
    property LineXD : Integer read FLineXD write FLineXD;
    property ChannelTv : Integer read FChannelTv write FChannelTv;
    property ChannelEx : Integer read FChannelEx write FChannelEx;

  end;

//--------------------------------------------------------------------------//
//  RDMł`lꗗǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataConfigRdChannelLineItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataConfigRdChannelLineItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TDataConfigRdChannelLineItems) ;
    function Add() : TDataConfigRdChannelLineItem;
    procedure Insert(i : Integer;d : TDataConfigRdChannelLineItem);
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataConfigRdChannelLineItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  RDMł`lf[^ǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataConfigRdChannelLine = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataConfigRdChannelLineItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataConfigRdChannelLineItems read FItems;

    function IndexOfTvEx(Tv,Ex : Integer) : Integer;

    function DataLoadOld(t : TStringListEx) : Boolean;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

  end;

implementation

{ TDataRdConfigChannelLineItems }

function TDataConfigRdChannelLineItems.Add() : TDataConfigRdChannelLineItem;
var
  d : TDataConfigRdChannelLineItem;
begin
  d := TDataConfigRdChannelLineItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataConfigRdChannelLineItems.Assign(
  Source: TDataConfigRdChannelLineItems);
var
  a : TDataConfigRdChannelLineItems;
  d : TDataConfigRdChannelLineItem;
  i : Integer;
begin
  if Source is TDataConfigRdChannelLineItems then begin
    a := TDataConfigRdChannelLineItems(Source);
    Clear;
    for i := 0 to a.Count-1 do begin
      d := Add();
      d.Assign(a.Items[i]);
    end;

  end
  else begin
    inherited Assign(Source);
  end;
end;

procedure TDataConfigRdChannelLineItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

constructor TDataConfigRdChannelLineItems.Create;
begin

end;

procedure TDataConfigRdChannelLineItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

destructor TDataConfigRdChannelLineItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataConfigRdChannelLineItems.GetItems(
  Index: Integer): TDataConfigRdChannelLineItem;
begin
  result := inherited Items[Index];
end;

procedure TDataConfigRdChannelLineItems.Insert(
  i: Integer;d : TDataConfigRdChannelLineItem);
begin
  inherited Insert(i,d);
end;

{ TDataRdConfigChannelLineItem }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                  //
//                                                                          //
//   - Input -  Source :                                              //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataConfigRdChannelLineItem.Assign(Source: TPersistent);
var
  a : TDataConfigRdChannelLineItem;
begin
  if Source is TDataConfigRdChannelLineItem then begin
    a := TDataConfigRdChannelLineItem(Source);
    FLine := a.FLine;
    FLineXD := a.FLineXD;
    FChannelTv := a.FChannelTv;
    FChannelEx := a.FChannelEx;
  end
  else begin
    inherited;
  end;
end;

function TDataConfigRdChannelLineItem.DataLoad(t: TStringListEx): Boolean;
begin
  FLine := t.GetStrs('Line',FLine);
  FLineXD := t.GetInts('LineXD',FLineXD);
  FChannelTv := t.GetInts('ChannelTv',FChannelTv);
  FChannelEx := t.GetInts('ChannelEx',FChannelEx);
  result := True;
end;

function TDataConfigRdChannelLineItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Line',FLine);
  t.SetInts('LineXD',FLineXD);
  t.SetInts('ChannelTv',FChannelTv);
  t.SetInts('ChannelEx',FChannelEx);
  result := True;
end;

{ TDataRdConfigChannelLine }

constructor TDataConfigRdChannelLine.Create;
begin
  FItems := TDataConfigRdChannelLineItems.Create;
end;

destructor TDataConfigRdChannelLine.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataConfigRdChannelLine.Assign(Source: TPersistent);
var
  a : TDataConfigRdChannelLine;
begin
  if Source is TDataConfigRdChannelLine then begin
    a := TDataConfigRdChannelLine(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataConfigRdChannelLine.DataLoadOld(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TDataConfigRdChannelLineItem;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    if t.Count = 0 then exit;
    FItems.Clear();
    for i := 0 to t.Count-1 do begin
      d := FItems.Add();
      t2.CommaTextEx := t[i];
      d.DataLoad(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataConfigRdChannelLine.DataLoad(t: TStringListEx): Boolean;
begin

end;

function TDataConfigRdChannelLine.DataSave(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TDataConfigRdChannelLineItem;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      d := Items[i];
      t2.Clear;
      d.DataSave(t2);
      t.Add(t2.CommaTextEx);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataConfigRdChannelLine.IndexOfTvEx(Tv, Ex: Integer): Integer;
var
  i : Integer;
  d : TDataConfigRdChannelLineItem;
begin
  result := -1;
  for i := 0 to FItems.Count-1 do begin
    d := FItems[i];
    if d.ChannelTv <> Tv then continue;
    if d.ChannelEx <> Ex then continue;
    result := i;
    exit;
  end;

end;

end.
