unit DataConfigRd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime,
  DataConfigRdChannel,DataRdRecReserveInfo,DataConfigRdConfig;

const
  ConfigDataVersion = 1;             // ݒۑ̃o[Wԍ
  DataRdConfigItemMatineStr : array[0..1] of string =
   ('RD','RD-X5');

type
  TDataRdConfigItemMatineCode = (mcNil,mcRD_X5);

//--------------------------------------------------------------------------//
//  ǗRD̐ݒf[^NX                                            //
//--------------------------------------------------------------------------//
type
  TDataConfigRdItem = class(TPersistent)
  private
    { Private 錾 }
    FChannels : TDataConfigRdChannelLine;     // M\ȃ`lꗗ
    FHost: string;                            // http://ŕ\zXg
    FMatineName: string;                      // @햼
    FName: string;                            // ǗƂ̖
    FLineBsAnalog: Integer;                   // BsAp̃`lԍiQOP`j1001CSA
    FLineBsDigital: Integer;                  // BsDp̃`lԍiQOP`j1001CSA
    FLineCsAnalog: Integer;                   // CsAp̃`lԍiQOP`j1001CSA
    FLineCsDigital: Integer;                  // CsDp̃`lԍiQOP`j1001CSA
    FEnablePassword: Boolean;                 // True : RD̃ANZXɃpX[hgp
    FPort: Integer;                           // gp|[gԍ@0:WŎgpĂ|[gg
    FUser: string;                            // Fؗp[U[
    FPassword: string;                        // FؗppX[h
    FRecMarkText: string;                     // ^\\
    FRecMarkColor: TColor;                    // ^\\F
    FMailUsed : Boolean;                      // [\̉
    FMailAddress : string;                    // ^\񃁁[AhX
    FMailPassword : string;                   // ^\ppX[h
    FMailMessage : string;                    // ^\p{
    FInfo: TDataRdRecReserveInfo;             // {̂擾lXȏ
    FConfig: TDataConfigRdConfig;             // qc̃GR[_ɑ΂ă[U[ݒ肷f[^
    FDebugRead: Boolean;                      // qcV~[g
    FDebugWrite: Boolean;                     // True:fobOL^
    //procedure SetMatineStr(const Value : string);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataLoadOld(t : TStringListEx) : Boolean;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    property Host : string read FHost write FHost;
    property Name : string read FName write FName;
    property MatineName : string read FMatineName write FMatineName;
    property LineBsAnalog : Integer read FLineBsAnalog write FLineBsAnalog;
    property LineBsDigital : Integer read FLineBsDigital write FLineBsDigital;
    property LineCsAnalog : Integer read FLineCsAnalog write FLineCsAnalog;
    property LineCsDigital : Integer read FLineCsDigital write FLineCsDigital;
    property Port : Integer read FPort write FPort;
    property EnablePassword : Boolean read FEnablePassword write FEnablePassword;
    property User : string read FUser write FUser;
    property Password : string read FPassword write FPassword;
    property RecMarkText : string read FRecMarkText write FRecMarkText;
    property RecMarkColor : TColor read FRecMarkColor write FRecMarkColor;
    property MailUsed : Boolean read FMailUsed write FMailUsed;
    property MailAddress : string read FMailAddress write FMailAddress;
    property MailPassword : string read FMailPassword write FMailPassword;
    property MailMessage : string read FMailMessage write FMailMessage;

    property DebugRead : Boolean read FDebugRead write FDebugRead;
    property DebugWrite : Boolean read FDebugWrite write FDebugWrite;

    property Channels : TDataConfigRdChannelLine read FChannels;
    // qctH_Agp`lꗗȂǂ̃f[^
    property Info : TDataRdRecReserveInfo read FInfo;
    // qc̃GR[_ɑ΂ă[U[ݒ肷f[^
    property Config : TDataConfigRdConfig read FConfig;

  end;

//--------------------------------------------------------------------------//
//  ǗRD̈ꗗf[^NX                                            //
//--------------------------------------------------------------------------//
type
  TDataConfigRdItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataConfigRdItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    procedure Assign(a : TDataConfigRdItems) ;
    function Add() : TDataConfigRdItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataConfigRdItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  ǗRD̐ݒf[^NX                                            //
//--------------------------------------------------------------------------//
type
  TDataConfigRd = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataConfigRdItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataConfigRdItems read FItems;

    function DataLoad(tt : TStringListKey) : Boolean;
    function DataSave(tt : TStringListKey) : Boolean;
  end;

implementation

uses DataRd;

{ TDataRdConfig }

constructor TDataConfigRd.Create;
begin
  FItems := TDataConfigRdItems.Create;
end;

destructor TDataConfigRd.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataConfigRd.Assign(Source: TPersistent);
var
  a : TDataConfigRd;
begin
  if Source is TDataConfigRd then begin
    a := TDataConfigRd(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataConfigRd.DataLoad(tt: TStringListKey): Boolean;
var
  i,cnt : Integer;
  t : TStringListEx;
  dc : TDataConfigRdItem;
begin
  FItems.Clear;
  t := tt.Values['RD_Config'];
  if t <> nil then begin
    cnt := t.GetInts('Count',0);
    for i := 0 to cnt-1 do begin
      dc := FItems.Add();
      t := tt.Values['RD_Config_'+IntToStr(i)];
      if t <> nil then begin
        dc.DataLoad(t);
      end;
      t := tt.Values['RD_Chanel_'+dc.Name];
      if t <> nil then begin
        dc.Channels.DataLoadOld(t);
      end;

      dc.Info.DataLoad(tt,'RD_Chanel_'+dc.Name);
      dc.Config.DataLoad(tt,'RD_Config_'+dc.Name);

    end;

  end;
  result := True;
end;

function TDataConfigRd.DataSave(tt: TStringListKey): Boolean;
var
  i : Integer;
  t : TStringListEx;
  dc : TDataConfigRdItem;
begin
  t := TStringListEx.Create;
  try
    result := False;
    t.SetInts('Count',FItems.Count);
    tt.Add('RD_Config',t);
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      dc := FItems[i];
      dc.DataSave(t);
      tt.Add('RD_Config_'+IntToStr(i),t);

      t.Clear;
      dc.Channels.DataSave(t);
      tt.Add('RD_Chanel_'+dc.Name,t);

      t.Clear;
      dc.Info.DataSave(tt,'RD_Chanel_'+dc.Name);
      dc.Config.DataSave(tt,'RD_Config_'+dc.Name);

    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdConfigItems }

destructor TDataConfigRdItems.Destroy;
begin
  Clear();
  inherited;
end;

procedure TDataConfigRdItems.Assign(a: TDataConfigRdItems);
var
  d : TDataConfigRdItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataConfigRdItems.Add: TDataConfigRdItem;
var
  d : TDataConfigRdItem;
begin
  d := TDataConfigRdItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataConfigRdItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataConfigRdItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataConfigRdItems.GetItems(Index: Integer): TDataConfigRdItem;
begin
  result := inherited Items[Index];
end;

{ TDataRdConfigItem }

procedure TDataConfigRdItem.Assign(Source: TPersistent);
var
  a : TDataConfigRdItem;
begin
  if Source is TDataConfigRdItem then begin
    a := TDataConfigRdItem(Source);
    FHost           := a.FHost;
    FName           := a.FName;
    FLineBsAnalog   := a.FLineBsAnalog;
    FLineBsDigital  := a.FLineBsDigital;
    FLineCsAnalog   := a.FLineCsAnalog;
    FLineCsDigital  := a.FLineCsDigital;
    FEnablePassword := a.FEnablePassword;
    FPort           := a.FPort;
    FUser           := a.FUser;
    FPassword       := a.FPassword;
    FRecMarkColor   := a.FRecMarkColor;
    FRecMarkText    := a.FRecMarkText;
    FMatineName     := a.FMatineName;
    FMailUsed       := a.FMailUsed;
    FMailAddress    := a.FMailAddress;
    FMailPassword   := a.FMailPassword;
    FMailMessage    := a.FMailMessage;
    FDebugRead      := a.FDebugRead;
    FDebugWrite     := a.FDebugWrite;
    FChannels.Assign(a.FChannels);
    FInfo.Assign(a.FInfo);
    FConfig.Assign(a.FConfig);
  end
  else begin
    inherited;
  end;
end;
{
function TDataRdConfigItem.CheckEqual(a: TDataRdItem): Boolean;
begin

end;
}
constructor TDataConfigRdItem.Create;
begin
  FChannels := TDataConfigRdChannelLine.Create;
  FInfo := TDataRdRecReserveInfo.Create;
  FConfig := TDataConfigRdConfig.Create;
  FPort := 80;
  FRecMarkColor := clRed;
  FRecMarkText := '';

  FMailMessage := 'open %pass %date %time1 %time2 %ch %rate %audio ';
end;

destructor TDataConfigRdItem.Destroy;
begin
  FConfig.Free;
  FInfo.Free;
  FChannels.Free;
  inherited;
end;

function TDataConfigRdItem.DataLoadOld(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  s : string;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    FName := t.GetStrs('Name',FName);
    FHost := t.GetStrs('Host',FHost);
    s := t.GetStrs('MatineCode','RD');
    FMatineName := s;
    //SetMatineStr(s);
    //MatineCodeStr   := t.GetStrs('MatineCode','RD-XS40');
    FLineBsAnalog   := t.GetInts('LineBsAnalog',FLineBsAnalog);
    FLineBsDigital  := t.GetInts('LineBsDigital',FLineBsDigital);
    FLineCsAnalog   := t.GetInts('LineCsAnalog',FLineCsAnalog);
    FLineCsDigital  := t.GetInts('LineCsDigital',FLineCsDigital);
    FPort           := t.GetInts('Port',FPort);
    FEnablePassword := t.GetBools('EnablePassword',FEnablePassword);
    FUser           := t.GetStrs('User',FUser);
    FPassword       := t.GetStrs('Password',FPassword);

    FRecMarkText    := t.GetStrs('RecMarkText',FRecMarkText);
    s := ColorToString(FRecMarkColor);
    s               := t.GetStrs('RecMarkColor',s);
    FRecMarkColor   := StringToColor(s);

    t2.CommaTextEx := t.GetStrs('Channels','');
    FChannels.DataLoadOld(t2);

    result := True;
  finally
    t2.Free;
  end;
end;

function TDataConfigRdItem.DataLoad(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  s : string;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    FName := t.GetStrs('Name',FName);
    FHost := t.GetStrs('Host',FHost);

    StrPosLeftDelete('http://',FHost);

    s := t.GetStrs('MatineCode','RD');
    FMatineName := s;
    //SetMatineStr(s);
    //MatineCodeStr   := t.GetStrs('MatineCode','RD-XS40');
    FLineBsAnalog   := t.GetInts('LineBsAnalog',FLineBsAnalog);
    FLineBsDigital  := t.GetInts('LineBsDigital',FLineBsDigital);
    FLineCsAnalog   := t.GetInts('LineCsAnalog',FLineCsAnalog);
    FLineCsDigital  := t.GetInts('LineCsDigital',FLineCsDigital);
    FPort           := t.GetInts('Port',FPort);
    FEnablePassword := t.GetBools('EnablePassword',FEnablePassword);
    FUser           := t.GetStrs('User',FUser);
    FPassword       := t.GetStrs('Password',FPassword);

    FRecMarkText    := t.GetStrs('RecMarkText',FRecMarkText);
    s := ColorToString(FRecMarkColor);
    s               := t.GetStrs('RecMarkColor',s);
    FRecMarkColor   := StringToColor(s);

    FMailUsed       := t.GetBools('MailUsed',False);
    FMailAddress    := t.GetStrs('MailAddress','');
    FMailPassword   := t.GetStrs('MailPassword','');
    FMailMessage    := t.GetStrs('MailMessage','');

    FDebugRead      := t.GetBools('DebugRead',False);
    FDebugWrite     := t.GetBools('DebugWrite',False);

    result := True;
  finally
    t2.Free;
  end;
end;

function TDataConfigRdItem.DataSave(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  s : string;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    t.SetStrs('Name',FName);
    t.SetStrs('Host',FHost);
    t.SetStrs('MatineCode',FMatineName);

    t.SetInts('LineBsAnalog',FLineBsAnalog);
    t.SetInts('LineBsDigital',FLineBsDigital);
    t.SetInts('LineCsAnalog',FLineCsAnalog);
    t.SetInts('LineCsDigital',FLineCsDigital);

    t.SetInts('Port',FPort);
    t.SetBools('EnablePassword',FEnablePassword);
    t.SetStrs('User',FUser);
    t.SetStrs('Password',FPassword);

    t.SetStrs('RecMarkText',FRecMarkText);
    s := ColorToString(FRecMarkColor);
    t.SetStrs('RecMarkColor',s);

    t.SetBools('MailUsed',FMailUsed);
    t.SetStrs('MailAddress',FMailAddress);
    t.SetStrs('MailPassword',FMailPassword);
    t.SetStrs('MailMessage',FMailMessage);

    t.SetBools('DebugRead',FDebugRead);
    t.SetBools('DebugWrite',FDebugWrite);

    result := True;
  finally
    t2.Free;
  end;
end;





end.
