unit DataConfigNormal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataTvChannel,
  DataTvSchedulePaperColumn,DataConfigRd,DataConfigTvScheduleColumn,DataConfigTvGenre;

//--------------------------------------------------------------------------//
//  {f[^ǗNX                                                    //
//--------------------------------------------------------------------------//
type
  TDataConfigNormal = class(TPersistent)
  private
    { Private 錾 }
    FReadDay: Integer;            // ǍǗsf[^
    FOldDay: Integer;             // ܂ŌÂf[^cĂ
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(tk : TStringListKey) : Boolean;
    function DataSave(tk : TStringListKey) : Boolean;

    property ReadDay : Integer read FReadDay write FReadDay;
    // ܂ŌÂf[^cĂ
    property OldDay : Integer read FOldDay write FOldDay;
  end;

implementation

{ TDataConfigNormal }

constructor TDataConfigNormal.Create;
begin
  FReadDay := 3;
  FOldDay := 1;
end;

destructor TDataConfigNormal.Destroy;
begin
  inherited;

end;

procedure TDataConfigNormal.Assign(Source: TPersistent);
var
  a : TDataConfigNormal;
begin
  if Source is TDataConfigNormal then begin
    a := TDataConfigNormal(Source);
    FReadDay := a.FReadDay;
    FOldDay := a.FOldDay;
  end
  else begin
    inherited;
  end;
end;

function TDataConfigNormal.DataLoad(tk: TStringListKey): Boolean;
var
  t : TStringListEx;
begin
  result := False;
  t := tk.Values['Normal'];
  if t = nil then exit;
  FReadDay := t.GetInts('ReadDay',3);
  FOldDay := t.GetInts('OldDay',1);
  result := True;
end;

function TDataConfigNormal.DataSave(tk: TStringListKey): Boolean;
var
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    t.SetInts('ReadDay',FReadDay);
    t.SetInts('OldDay',FOldDay);
    tk.Add('Normal',t);
    result := True;
  finally
    t.Free;
  end;
end;

end.
