unit DataConfigMail;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataTvChannel,
  DataTvSchedulePaperColumn,DataConfigRd,DataConfigTvScheduleColumn,WinSockVSmtpClient;

//--------------------------------------------------------------------------//
//  {f[^ǗNX                                                    //
//--------------------------------------------------------------------------//
type
  TDataConfigMail = class(TPersistent)
  private
    { Private 錾 }
    FHost: string;                    // SMTPT[oAhX
    FPort: Integer;                   // SMTP|[gԍ
    FAuth: TWinSockVSmtpClientAuth;   // F؂̎
    FUser: string;                    // Fؗp[U[
    FPassword: string;                // FؗppX[h
    FUsed: Boolean;
    FFromName: string;
    FFromMail: string;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(tk : TStringListKey) : Boolean;
    function DataSave(tk : TStringListKey) : Boolean;

    // [gp̗L
    property Used : Boolean read FUsed write FUsed;
    // SMTPT[oAhX
    property Host : string read FHost write FHost;
    // SMTP|[gԍ
    property Port : Integer read FPort write FPort;
    // F؂̎
    property Auth : TWinSockVSmtpClientAuth read FAuth write FAuth;
    // Fؗp[U[
    property User : string read FUser write FUser;
    // FؗppX[h
    property Password : string read FPassword write FPassword;
    // M[AhX
    property FromMail : string read FFromMail write FFromMail;
    // MҖ
    property FromName : string read FFromName write FFromName;
  end;

implementation

{ TDataConfigMail }

constructor TDataConfigMail.Create;
begin
  FPort := 25;
end;

destructor TDataConfigMail.Destroy;
begin
  inherited;

end;

procedure TDataConfigMail.Assign(Source: TPersistent);
var
  a : TDataConfigMail;
begin
  if Source is TDataConfigMail then begin
    a := TDataConfigMail(Source);
    FUsed     := a.FUsed;
    FHost     := a.FHost;
    FPort     := a.FPort;
    FAuth     := a.FAuth;
    FUser     := a.FUser;
    FPassword := a.FPassword;
    FFromMail := a.FFromMail;
    FFromName := a.FFromName;
  end
  else begin
    inherited;
  end;
end;

function TDataConfigMail.DataLoad(tk: TStringListKey): Boolean;
var
  t : TStringListEx;
begin
  result := False;
  t := tk.Values['Mail'];
  if t = nil then exit;
  FUsed := t.GetBools('Used',False);
  FHost := t.GetStrs('Host','');
  FPort := t.GetInts('Port',25);
  FAuth := TWinSockVSmtpClientAuth(t.GetInts('Auth',0));
  FUser := t.GetStrs('Host','');
  FPassword := t.GetStrs('Password','');
  FFromMail := t.GetStrs('FromMail','');
  FFromName := t.GetStrs('FromName','');
  result := True;
end;

function TDataConfigMail.DataSave(tk: TStringListKey): Boolean;
var
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    t.SetBools('Used',FUsed);
    t.SetStrs('Host',FHost);
    t.SetInts('Port',FPort);
    t.SetInts('Auth',Ord(FAuth));
    t.SetStrs('User',FUser);
    t.SetStrs('Password',FPassword);
    t.SetStrs('FromMail',FFromMail);
    t.SetStrs('FromName',FFromName);
    tk.Add('Mail',t);
    result := True;
  finally
    t.Free;
  end;
end;

end.
