unit DataConfig;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataTvChannel,
  DataTvSchedulePaperColumn,DataConfigRd,DataConfigTvScheduleColumn,DataConfigTvGenre,
  DataConfigNormal,DataConfigMail;

//--------------------------------------------------------------------------//
//  ݒf[^ǗNX                                              //
//--------------------------------------------------------------------------//
type
  TDataConfig = class(TPersistent)
  private
    { Private 錾 }
    FNormal : TDataConfigNormal;
    FTvChannel: TDataTvChannel;                     // suԑgf[^Ŏgp`lf[^
    FTvSchedulePaper : TDataTvSchedulePaperConfig;  // V`̐ݒlǗNX
    FTvSchedule : TDataConfigTvScheduleColumn;      // Xg`̔ԑg\̐ݒf[^
    FRd: TDataConfigRd;
    FGenre: TDataConfigTvGenre;
    FMail : TDataConfigMail;                        // [M̂߂̐ݒ
    function DataLoadDef() : Boolean;
    function GetFileName() : string;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    property Normal : TDataConfigNormal read FNormal;
    property TvChannel : TDataTvChannel read FTvChannel;
    property TvSchedulePaperConfig : TDataTvSchedulePaperConfig read FTvSchedulePaper;
    property Rd : TDataConfigRd read FRd;
    property TvSchedule : TDataConfigTvScheduleColumn read FTvSchedule;
    property Genre : TDataConfigTvGenre read FGenre;
    property Mail : TDataConfigMail read FMail;

    function DataLoad() : Boolean;
    function DataSave() : Boolean;

    procedure TvChToTvColumns();
  end;

implementation

{ TDataConfig }

constructor TDataConfig.Create;
begin
  FNormal := TDataConfigNormal.Create;
  FTvChannel := TDataTvChannel.Create;
  FTvSchedulePaper := TDataTvSchedulePaperConfig.Create;
  FRd := TDataConfigRd.Create;
  FTvSchedule := TDataConfigTvScheduleColumn.Create;
  FGenre := TDataConfigTvGenre.Create;
  FMail := TDataConfigMail.Create;
end;

destructor TDataConfig.Destroy;
begin
  FMail.Free;
  FGenre.Free;
  FTvSchedule.Free;
  FRd.Free;
  FTvSchedulePaper.Free;
  FTvChannel.Free;
  FNormal.Free;
  inherited;
end;

procedure TDataConfig.Assign(Source: TPersistent);
var
  a : TDataConfig;
begin
  if Source is TDataConfig then begin
    a := TDataConfig(Source);
    FNormal.Assign(a.FNormal);
    FTvChannel.Assign(a.FTvChannel);
    FTvSchedule.Assign(a.FTvSchedule);
    FTvSchedulePaper.Assign(a.FTvSchedulePaper);
    FRd.Assign(a.FRd);
    FGenre.Assign(a.FGenre);
    FMail.Assign(a.FMail);
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@ۑt@Cf[^ǂݍ݁@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TDataConfig.DataLoad(): Boolean;
var
  tk : TStringListKey;
  s : string;
begin
  result := False;
  DataLoadDef();
  s := GetFileName();
  if not FileExists(s) then exit;
  tk := TStringListKey.Create;
  try
    tk.LoadFromFile(s);                         // ݒۑt@Cǂݍ
    FNormal.DataLoad(tk);
    FTvChannel.DataLoad(tk);                    // ǃf[^ǂݍ
    FRd.DataLoad(tk);
    FTvSchedule.DataLoad(tk);
    FTvSchedulePaper.DataLoad(tk,FTvChannel);
    FGenre.DataLoad(tk);
    FMail.DataLoad(tk);
    result := True;
  finally
    tk.Free;
  end;
end;

function TDataConfig.DataSave(): Boolean;
var
  tk : TStringListKey;
  s : string;
begin
  s := GetFileName();
  tk := TStringListKey.Create;
  try
    result := False;
    FNormal.DataSave(tk);
    FTvChannel.DataSave(tk);                    // ǃf[^ǂݍ
    FRd.DataSave(tk);
    FTvSchedule.DataSave(tk);
    FTvSchedulePaper.DataSave(tk);
    FGenre.DataSave(tk);
    FMail.DataSave(tk);
    tk.SaveToFile(s);                           // ݒt@Cɕۑ
    result := True;
  finally
    tk.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@l@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TDataConfig.DataLoadDef: Boolean;
var
  t : TStringListKey;
  s : string;
begin
  result := False;
  s := ExtractFilePath(Application.ExeName) + 'define.ini';
  if not FileExists(s) then exit;
  t := TStringListKey.Create;
  try
    t.LoadFromFile(s);
    FTvSchedule.DataLoadDef(t);
    //FTvScheduleConfig..DataLoadDef(t);
    result := True;
  finally
    t.Free;
  end;
end;

function TDataConfig.GetFileName: string;
begin
  result := ExtractFilePath(Application.ExeName) + 'config.ini';
end;

//**************************************************************************//
//                                                                          //
//  `@\ǏNX̃f[^݂ĂȂꍇ폜@`              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataConfig.TvChToTvColumns;
var
  i : Integer;
  d : TDataTvSchedulePaperColumnItem;
  dc : TDataTvChannelItem;
  dl : TDataTvSchedulePaperConfig;
begin
  dl := FTvSchedulePaper;
  for i := dl.Columns.Count-1 downto 0 do begin
    d := dl.Columns[i];

    dc := FTvChannel.Items.TvExs[d.ChannelTv,d.ChannelEx];
    if dc = nil then dl.Columns.Delete(i);
    //if not dc.Visible then continue;
  end;
end;

end.
