unit DMUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DataTvSchedule,StringListEx,StringListKey,DataTvChannel,
  DataTvSchedulePaperColumn,GetTv,DataRd,DataConfigRd,DataCursorTv,DataCursorRd,DataConfig,
  DataDefine,DataRdRecReserve,DefaultData,DataTvStatus,ProcPublicFileName,
  DataRdRecReserveChannel,DataRdRecReserveInfo,DataRdRecReserveDateTime,
  DataConfigRdChannel, Menus;

type
  TDM = class(TDataModule)
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private 錾 }
    FLoaded : Boolean;                                  // True : f[^ǂݍݍς
    FTvSchedule: TDataTvSchedule;                       // ԑgf[^
    //FFileDef: TStringListKey;
    FGetTv: TGetTvSchedule;                             // suԑg擾NX
    FRd: TDataRd;                                       // qc擾ꂽf[^
    FCursorTv : TDataCursorTv;                          // ԑgIJ[\NX
    FCursorRd : TDataCursorRd;                          // ^\IJ[\NX
    FConfig: TDataConfig;
    FDefine: TDataDefine;                               // J[\f[^
    function TvSave() : Boolean;
    function TvLoad() : Boolean;
  public
    { Public 錾 }
    property TvSchedule : TDataTvSchedule read FTvSchedule;
    //property FileDef : TStringListKey read FFileDef;
    //property TvChannel : TDataTvScheduleChannel read FTvChannel;
    property Rd : TDataRd read FRd;
    property GetTv : TGetTvSchedule read FGetTv;

    property CursorTv : TDataCursorTv read FCursorTv;
    property CursorRd : TDataCursorRd read FCursorRd;

    property Config : TDataConfig read FConfig write FConfig;
    property Define : TDataDefine read FDefine;

    function DataLoad() : Boolean;
    function DataSave() : Boolean;
    function ProcStart() : Boolean;

    // suԑgf[^qc^ɕϊ
    function TvToRd(dr : TDataRdRecReserveItem;dt : TDataTvScheduleItem;RdIndex : Integer) : Boolean;
    // suԑgf[^ɏdȂ^\擾
    function TvToOverlapRd(drs : TDataRdRecReserveItemsEx;dt : TDataTvScheduleItem) : Boolean;

  end;

var
  DM: TDM;

implementation

{$R *.DFM}

//--------------------------------------------------------------------------//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TDM.DataModuleCreate(Sender: TObject);
begin
  FDefine := TDataDefine.Create;
  FConfig := TDataConfig.Create;
  FTvSchedule := TDataTvSchedule.Create;
  FTvSchedule.Channel := FConfig.TvChannel;
  FGetTv := TGetTvSchedule.Create();
  FGetTv.DM := Self;
  FRd := TDataRd.Create;
  FCursorTv := TDataCursorTv.Create;
  FCursorRd := TDataCursorRd.Create;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TDM.DataModuleDestroy(Sender: TObject);
begin
  TvSave();
  FCursorRd.Free;
  FCursorTv.Free;
  FRd.Free;
  FGetTv.Free;
  FTvSchedule.Free;
  //FTvSchedulePaperConfig.Free;
  //FTvChannel.Free;
  FDefine.Free;
  FConfig.Free;
end;


//**************************************************************************//
//                                                                          //
//  `@ۑt@Cf[^ǂݍ݁@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TDM.DataLoad: Boolean;
begin
  result := False;
  FDefine.DataLoad();
  if not FConfig.DataLoad() then begin      // ݒt@C̓ǍɎsꍇ
    FConfig.Genre.Assign(FDefine.Genre);    // l
    exit;
  end;
  FGetTv.AssignConfig(FConfig.TvChannel);   // suԑgǂݍޕǂw
  FRd.Config := FConfig.Rd;
  TvLoad();                                 // suԑgf[^ǂݍ
  result := True;
  FLoaded := True;
  //FTvSchedule.DataLoad();
end;

function TDM.DataSave: Boolean;
begin
  result := FConfig.DataSave();
end;

function TDM.TvSave: Boolean;
var
  t : TStringListKey;
  t2 : TStringListEx;
  s : string;
begin
  s := GetFilePathTemp() + 'tmp_tv.ini';
  t := TStringListKey.Create;
  t2 := TStringListEx.Create;
  try
    result := False;
    if FTvSchedule.ReadBusy then exit;   // t@Cǂݍݒ̏ꍇ
    FGetTv.DataSave(t);
    FTvSchedule.DataSave(t2);
    //FTvSchedulePaperConfig.DataSave(t);      // V`\̐ݒۑ
    t.Add('Data',t2);
    t.SaveToFile(s);
    result := True;
  finally
    t2.Free;
    t.Free;
  end;

end;

function TDM.TvLoad: Boolean;
var
  t : TStringListKey;
  t2 : TStringListEx;
  s : string;
begin
  s := GetFilePathTemp() + 'tmp_tv.ini';
  t := TStringListKey.Create;
  //t2 := TStringListEx.Create;
  try
    result := False;
    if not FileExists(s) then exit;
    t.LoadFromFile(s);
    FGetTv.DataLoad(t);               // ԑgǂݍݏɑȌԂ𕜌
    t2 := t.Values['Data'];           // ԑgf[^i[ꏊQ
    FTvSchedule.DataLoad(t2);         // ԑgf[^ǂݍ
    result := True;
  finally
    //t2.Free;
    t.Free;
  end;
end;

function TDM.ProcStart: Boolean;
begin
  FGetTv.ProcInit();              // suԑgǂݍ݂
  FGetTv.ProcStart();             // suԑg̓ǂݍݏJn
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@suԑgf[^qc^f[^ɕϊ@`                            //
//                                                                          //
//   - Input -  dr : ^f[^                                             //
//              dt : suԑgf[^                                         //
//              RdIndex : RD䑶݂Ƃ̃CfbNXԍ          //
//                                                                          //
//   - Output - True : ϊI                                             //
//                                                                          //
//**************************************************************************//
function TDM.TvToRd(dr: TDataRdRecReserveItem;
  dt: TDataTvScheduleItem;RdIndex : Integer): Boolean;
var
  i,j : Integer;
  aRdConfig : TDataConfigRdItem;
  aMode : TDataRdRecReserveChannelMode;
  aInfo : TDataRdRecReserveInfo;
begin
  dr.Execution     := True;
  dr.Title         := dt.Title;
  if dt.TalkNo > 0 then begin
    dr.Title := dr.Title + ' #'+IntToStr(dt.TalkNo);
  end;

  aRdConfig := FRd.Items[RdIndex].GetRd.Config;
  // ǈꗗCfbNX𓾂
  i := aRdConfig.Channels.IndexOfTvEx(dt.ChTv,dt.ChTvEx);
  // Iꂽqc̏QƂ
  aInfo := FRd.Items[RdIndex].GetRd.RdInfo;
  // CfbNX͈͓ł邩f
  if (i >= 0) and (i < aRdConfig.Channels.Items.Count) then begin
    // qcŎgp`lʖ
    dr.ChannelStr := aRdConfig.Channels.Items[i].Line;
    // qc̃`lꗗł̃CfbNX𓾂
    j := aInfo.Channels.Items.IndexOfValue(dr.ChannelStr);
    if j <> -1 then begin                                   // Ɏ擾łꍇ
      aMode := aInfo.Channels.Items[j].Mode;                // ǂ̎ނ擾
      for i := 0 to aInfo.BCMedhia.Items.Count-1 do begin   // ǂ̎ވꗗ[v
        if aInfo.BCMedhia.Items[i].Mode = aMode then begin  // Yǂ̎ނ
          dr.BCMedhiaStr := aInfo.BCMedhia.Items[i].Value;  // ̕ǎʒl
          break;
        end;
      end;
    end;
  end;
  //dr.ChannelStr := Config.Channels.Items[dt.Channel].Line;

  dr.DateTime.Start.Yer     := dt.Start.Yer;
  dr.DateTime.Start.Mon     := dt.Start.Mon;
  dr.DateTime.Start.Day     := dt.Start.Day;
  dr.DateTime.Start.Hou     := dt.Start.Hou;
  dr.DateTime.Start.Min     := dt.Start.Min;

  dr.DateTime.Stop.Yer      := dt.Start.Yer;
  dr.DateTime.Stop.Mon      := dt.Start.Mon;
  dr.DateTime.Stop.Day      := dt.Start.Day;
  dr.DateTime.Stop.Hou      := dt.Stop.Hou;
  dr.DateTime.Stop.Min      := dt.Stop.Min;

  //    i := DMConfig.GenruItems.GenruTvStrToGenruNo(d.GenruStr);
  //dr.Genre := 0;
  dr.Genre := aInfo.Genres.Items.ModeToValue(dt.Genre);

  //dr.Genre :=
  //dr.Genre := Ord(FConfig.Genre.Items.Genres[dt.GenreStr]);
  //dr.Genre         := DMConfig.GenruItems.GenruTvStrToGenruNo(tv.GenruStr);
  dr.Comment       := dt.Comment;

  // vZ
  if dr.Status[tsmExtended].Value then begin
    dr.DateTime.Stop.IncMin(30);
  end;
  result := True;
end;

function TDM.TvToOverlapRd(drs: TDataRdRecReserveItemsEx;
  dt: TDataTvScheduleItem): Boolean;
var
  i,j,k : Integer;
  drsr : TDataRdRecReserve;
  dr : TDataRdRecReserveItem;
  drt : TDataRdRecReserveDateTimeItem;
  aRdConfig : TDataConfigRdItem;
  aRdConfigc : TDataConfigRdChannelLineItem;
  aInfo : TDataRdRecReserveInfo;
  aInfoc : TDataRdRecReserveChannelItem;
begin
  result := False;
  drs.Clear;


  for j := 0 to FRd.Items.Count-1 do begin               // qc̑䐔[v
    drsr := FRd.Items[j].RecReserve;                     // qc̘^\NXQ
    aRdConfig := FRd.Items[j].GetRd.Config;              // qc̈ꗗCHMR[h𓾂邽߂̃NXQ
    aInfo := FRd.Items[j].GetRd.RdInfo;                  // su̕ǃf[^CHMR[h𓾂NXQ

    k := aRdConfig.Channels.IndexOfTvEx(dt.ChTv,dt.ChTvEx); // su̕ǃf[^L[Ƃ
    if k = -1 then continue;                                // Ζ
    aRdConfigc := aRdConfig.Channels.Items[k];              // su̕ǃf[^qcCHMR[h擾

    for i := 0 to drsr.Items.Count-1 do begin            // ^\񐔕[v
      dr := drsr.Items[i];                               // ^\Q

      k := aInfo.Channels.Items.IndexOfList(dr.Channel); // qc̘^\ꗗł̂bgL[Ƃ
      if k = -1 then continue;                           // Ζ
      aInfoc := aInfo.Channels.Items[k];                 // qc̘^\ꗗڍׂ擾
      if aInfoc.Value <> aRdConfigc.Line then continue;       // vȂΖ
      for k := 0 to dr.DateTime.Items.Count-1 do begin   // T\WJ[v
        drt := dr.DateTime.Items[k];                     // ^\̂PQ
        if drt.CheckOverlap(dt.Start,dt.Stop) then begin // Ԃ͈͓̔f
          drs.Add(dr);                                   // Y^Ƃēo^
          result := True;
        end;
      end;
    end;
  end;
end;


end.
