//**************************************************************************//
//                                                                          //
//  HTML֐Q                                                  //
//                                                                          //
//**************************************************************************//
unit CommInternet;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,WinInet;

  function ParamToPostStr(aList : TStringList) : string;
  function GetHtmlSource(var Stream: TStream; const url: string): boolean;
  function GetHtmlString(const url: string): string;
  function PostHtmlSource(const url1: string;const url2 : string;const url3: string;aList : TStringList): boolean;

  function StrPosToLeftDelete(aStart : string;var str : string) : Integer;
  function StrPosSurroundLeftDelete(aStart,aEnd : string;var str : string) : string;
  function StrPosSurround(aStart,aEnd : string;const str : string) : string;
  function StrPosLeft(const aStart : string;const str : string) : string;
  function StrPosLeftDelete(const aStart : string;var str : string) : string;

  function StrPosFrame(aStart : string;const str : string;var str2 : string) : Boolean;

  function StrToHtmlAddress(str : string) : string;


implementation


function GetHtmlSource(var Stream: TStream; const url: string): boolean;
const
 UserAgent = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)';
var
 hSession: HINTERNET;
 hService: HINTERNET;
 lpBuffer: array[0..1024] of Char;
 dwBytesRead: Cardinal;
begin
 Result:=False;

 hSession := InternetOpen(PChar(UserAgent), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
 try
  if Assigned(hSession) then
   begin
    hService := InternetOpenUrl(hSession, PChar(url), nil, 0, INTERNET_FLAG_RELOAD, 0);
    try
     if Assigned(hService) then
     begin
      while true do
      begin
       FillChar(lpBuffer, SizeOf(lpBuffer), #0);
       InternetReadFile(hService, @lpBuffer, SizeOf(lpBuffer), dwBytesRead);
       if dwBytesRead = 0 then
        Break;
       Stream.Write(lpBuffer,dwBytesRead);
      end; //while
      
      Stream.Position:=0;  //ǂݎʒu擪ɎĂ
      Result:=True;
     end; //if Assigned(hService)

    finally
     InternetCloseHandle(hService);
    end;
  end; //if Assigned(hSession)

 finally
  InternetCloseHandle(hSession);
 end;
end;

function GetHtmlString(const url: string): string;
var
  t : TStream;
  st : string;
begin
  t := TStringStream.Create(st);
  try
    result := '';
    GetHtmlSource(t,url);
    result := TStringStream(t).DataString;
    st := TStringStream(t).DataString;
  finally
    t.Free;
  end;

end;

function ParamToPostStr(aList : TStringList) : string;
var
  i : Integer;
  s : string;
begin
  s := '';
  for i := 0 to aList.Count-1 do begin
   if i > 0 then begin
     s := s + '&' + aList[i];
   end
   else begin
     s := aList[i];
   end;
  end;
  result := s;
end;

function PostHtmlSource(const url1: string;const url2 : string;const url3: string;aList : TStringList): boolean;
const
 UserAgent = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)';
 //HeadStr = 'Content-Type: application/x-www-form-urlencoded';
 HeadStr = '';
var
 hSession: HINTERNET;
 hConnect : HINTERNET;
 hRequest: HINTERNET;

 s : string;

begin
 Result:=False;

 s := ParamToPostStr(aList);
 hRequest := nil;
 hConnect := nil;
 hSession := InternetOpen(PChar(UserAgent), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
 try
  if Assigned(hSession) then
   begin
    hConnect := InternetConnect(hSession, Pchar(Url1), INTERNET_DEFAULT_HTTP_PORT,
                                nil, nil, INTERNET_SERVICE_HTTP, 0, 0);

    hRequest := HttpOpenRequest(hConnect, 'POST',PChar(Url2),nil,PChar(Url3), nil,
                                INTERNET_FLAG_KEEP_CONNECTION, 0);

    result := HttpSendRequest(hRequest, PChar(HeadStr),Length(HeadStr),Pchar(s),Length(s));
    GetLastError();
  end; //if Assigned(hSession)

 finally
  InternetCloseHandle(hRequest);
  InternetCloseHandle(hConnect);
  InternetCloseHandle(hSession);
 end;
end;


//**************************************************************************//
//                                                                          //
//  `@Q̒當PT񂲂ƍ폜@`      //
//                                                                          //
//   - Input -  aStart : P                                           //
//              str    : Q                                           //
//                                                                          //
//   - Output - ʒu                                              //
//                                                                          //
//     P:DEF                                                         //
//     Q:ABCDEFGHI   -> GHI                                          //
//                                                                          //
//**************************************************************************//
function StrPosToLeftDelete(aStart : string; var str: string): Integer;
var
  i : Integer;
begin
  i := Pos(aStart,str);
  if i > 0 then begin
    str := Copy(str,i+Length(aStart),Length(str));
  end;
  result := i;
end;

//**************************************************************************//
//                                                                          //
//  `@Q̒當PT񂲂ƍ폜@`      //
//                                                                          //
//   - Input -  aStart : P                                           //
//              str    : Q                                           //
//                                                                          //
//   - Output - ܂ł̍                                          //
//                                                                          //
//     P:DEF                                                         //
//     Q:ABCDEFGHI   -> GHI                                          //
//                                                                          //
//**************************************************************************//
function StrPosLeftDelete(const aStart : string;var str : string) : string;
var
  i : Integer;
begin
  result := '';
  i := Pos(aStart,str);
  if i > 0 then begin
    result := Copy(str,1,i-1);
    str := Copy(str,i+Length(aStart),Length(str));
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@R̒當PƕQɋ܂ꂽԂ@`        //
//                                                                          //
//   - Input -  aStart : P                                           //
//              aEnd   : Q                                           //
//              str    : R                                           //
//                                                                          //
//   - Output - ܂ꂽ                                              //
//                                                                          //
//     P:CD                                                          //
//     Q:GH                                                          //
//     R:ABCDEFGHIJK  -> IJK                                         //
//                      ԂlFEF                                          //
//                                                                          //
//**************************************************************************//
function StrPosSurroundLeftDelete(aStart, aEnd: string; var str: string): string;
var
  i : Integer;
begin
  result := '';
  StrPosToLeftDelete(aStart,str);
  i := Pos(aEnd,str);
  if i > 0 then begin
    result := Copy(str,1,i-1);
    StrPosToLeftDelete(aEnd,str);
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@R̒當PƕQɋ܂ꂽԂ@`        //
//      R͕ωȂ                                              //
//        PȂꍇ̓kԂB                    //
//        QȂꍇ͕PE̕Ԃ      //
//                                                                          //
//   - Input -  aStart : P                                           //
//              aEnd   : Q                                           //
//              str    : R                                           //
//                                                                          //
//   - Output - ܂ꂽ                                              //
//                                                                          //
//     P:CD                                                          //
//     Q:GH                                                          //
//     R:ABCDEFGHIJK  -> ABCDEFGHIJK                                 //
//                      ԂlFEF                                          //
//                                                                          //
//**************************************************************************//
function StrPosSurround(aStart, aEnd: string;const str: string): string;
var
  i : Integer;
  s : string;
begin
  result := '';
  s := str;
  i := StrPosToLeftDelete(aStart,s);
  if i <= 0 then exit;
  i := Pos(aEnd,s);
  if i > 0 then begin
    result := Copy(s,1,i-1);
  end
  else begin
    result := s;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@Q̒當PT̍擾@`                    //
//                                                                          //
//   - Input -  aStart : P                                           //
//              str    : Q                                           //
//                                                                          //
//   - Output - ̍̕                                  //
//                                                                          //
//**************************************************************************//
function StrPosLeft(const aStart : string;const str: string): string;
var
  i : Integer;
begin
  i := Pos(aStart,str);
  if i > 0 then begin
    result := Copy(str,1,i-1);
  end
  else begin
    result := str;
  end;
end;


//**************************************************************************//
//                                                                          //
//  `@Q̒ɑ݂镶P擪ƂPt[@`      //
//                                                                          //
//   - Input -  aStart : P                                           //
//              str    : Q                                           //
//              str2   : R                                           //
//                                                                          //
//   - Output - True : PQJȏ㑶݂                         //
//                     Qڂ̕Pn܂镶Ԃ               //
//                                                                          //
//**************************************************************************//
function StrPosFrame(aStart: string; const str: string; var str2: string): Boolean;
var
  i : Integer;
  s : string;
begin
  i := Pos(aStart,str);
  s := Copy(str,i+Length(aStart),Length(str));

  i := Pos(aStart,s);
  if i > 0 then begin
    result := True;
    str2 := Copy(s,i,Length(s));
  end
  else begin
    result := False;
    str2 := str;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@IËƂēn镶ɕϊ@`                        //
//                                                                          //
//   - Input -  str : ϊ镶                                        //
//                                                                          //
//   - Output - IË`̕                                        //
//                                                                          //
//**************************************************************************//
function StrToHtmlAddress(str : string) : string;
var
  i,j,k : Integer;
  t : TList;
  ss : string;
begin
  t := TList.Create;
  try
    k := 0;                              // ͏Jn
    for i := 1 to Length(str) do begin
      if k = 0 then begin
        case Ord(str[i]) of              // pR[h̏ꍇ
          $30..$39,
          $41..$5a,
          $61..$7a: begin
                      j := 0;            // ̂܂ܓnƂw
                    end;
          $80..$9f,
          $E0..$ff: begin                // R[h̏ꍇ
                      j := 1;            // R[hnƂw
                      k := 1;            // ̃R[hƂď
                    end;
        else        begin                // ȊÕR[h̏ꍇ
                      j := 1;            // R[hnƂw
                    end;
        end;
      end
      else begin                         // ÕR[hR[h̏ꍇ
        j := 1;                          // ̕R[hƂď
        k := 0;                          // ̎͒ʏ̏sƂw
      end;
      t.Add(Pointer(j));
    end;

    ss := '';
    for i := 0 to Length(str)-1 do begin // ͌ʂɏ]ď
      case Integer(t[i]) of
        0: ss := ss + str[i+1];
        1: ss := ss + '%' + IntToHex(Ord(str[i+1]),2);
      end;

    end;
    result := ss;

  finally
    t.Free;
  end;

end;

end.
