unit ComboBoxEx;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     StdCtrls,ComCtrls;

//--------------------------------------------------------------------------//
//  suԑg\ԑуf[^ǗNX                                //
//--------------------------------------------------------------------------//
type
  TComboboxColorText = class(TComboBox)
  private
    { Private 錾 }
    procedure OnDrawItemEx(Control: TWinControl; Index: Integer;Rect: TRect;
       State: TOwnerDrawState);
    function GetValueColor: TColor;
    procedure SetValueColor(const Value: TColor);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure View();

    property ValueColor : TColor read GetValueColor write SetValueColor;

    end;


implementation

const
  ColorTextTbl : array[0..7] of Integer = (
                                           $000000,
                                           $0000ff,
                                           $00ff00,
                                           $00ffff,
                                           $ff0000,
                                           $ff00ff,
                                           $ffff00,
                                           $ffffff
                                           );
{ TComboboxColorText }

constructor TComboboxColorText.Create(AOwner: TComponent);
begin
  inherited;
  OnDrawItem := OnDrawItemEx;
  Style := csOwnerDrawFixed;
end;

destructor TComboboxColorText.Destroy;
begin
  inherited;

end;

function TComboboxColorText.GetValueColor: TColor;
begin
  result := 0;
  if ItemIndex = -1 then exit;
  result := ColorTextTbl[ItemIndex];
end;

procedure TComboboxColorText.SetValueColor(const Value: TColor);
var
  i : Integer;
begin
  for i := 0 to High(ColorTextTbl) do begin
    if ColorTextTbl[i] = Value then begin
      ItemIndex := i;
      exit;
    end;
  end;

end;

procedure TComboboxColorText.OnDrawItemEx(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  i,x1,x2,y1,y2 : Integer;
  cp,cf : TColor;
  c : TCanvas;
begin
  c := Canvas;
  c.Brush.Color := clWhite;
  c.FillRect(Rect);
  i := Index;
  cp := clBlack;
  cf := clBlack;
  case i of
    0..7 :   begin
               cp := clBlack;
               cf  := ColorTextTbl[i];
             end;
  end;

  x1 := Rect.Left + 2;
  x2 := x1 + 32;
  y1 := Rect.Top  + 2;
  y2 := y1 + 13;
  c.Pen.Color := cp;
  c.Brush.Color := cf;
  c.Rectangle(x1,y1,x2,y2);
end;

procedure TComboboxColorText.View;
var
  i : Integer;
begin
  Clear();
  for i := 0 to High(ColorTextTbl) do begin
    Items.Add('');
  end;
end;

end.
