#pragma once
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CTorus :public IBaseActorObject
{
friend class CTorusReservoir;
private:
    // OnCreate(CActorReservoir<>::Initialize)̈
    struct SCreateParam
    {
        Scene::ISceneManager* pManager;
        Renderer::Object::IModel* pModel;
        //
        CGame* pGame;
    };
    // OnInitialize(CActorReservoir<>::GetNewActiveObject)̈
    struct SInitializeParam
    {
        ;
    };
    // CActorReservoir<>::GetNewActiveObjectŎ擾Ƀp[^ݒ
private:
    // external
    CGame* m_pGame;
    Scene::ICamera* m_pCamera;
    // OnCreate/OnDestroy
    Scene::IModelActor* m_pModelActor;
    // OnInitialize/OnKill
    CAttackArea* m_pAttackArea;
    CDefenseArea* m_pDefenseArea;
    //
    Math::Vector3D  m_Position;
    Math::Quaternion m_Direction;
public:
    CTorus(void);
    ~CTorus(void);
    //
protected:
    bool OnCreate(void* pParam);
    bool OnInitialize(void* pParam);
    bool OnFinalize(void);
    bool OnDestroy(void);
public:
    bool UpdateParam(void);
public:
    bool OnUpdate(void);
    bool OnDraw(void);
public:
    bool OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea);
    bool OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea);
    //
    bool OnKill(void);
public:
    void SetPosition(const Math::Vector3D& Position);
    void SetDirection(const Math::Quaternion& Direction);
    //
    void PushUp(void);
    void PushDown(void);
    void PushLeft(void);
    void PushRight(void);
    //
    void PushShot(void);
    //
    const Math::Vector3D& GetPosition(void);
    const Math::Quaternion& GetDirection(void);
};
///////////////////////////////////////////////////////////////
class CTorusReservoir :private CActorReservoir<CTorus>
{
private:
    Renderer::Object::IModel* m_pModel;
    CGame* m_pGame;
public:
    CTorusReservoir(void);
    ~CTorusReservoir(void);
    //
    bool Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame);
    bool Finalize(void);
    //
    CTorus* GetNewActiveObject(void);
    CReservoirIterator<CTorus> GetActiveObjectIterator(void);
    //
    bool Update(void);
    bool Draw(void);
};