#include "torus.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CTorus::CTorus(void)
:IBaseActorObject(ACTOR_OBJECT_TORUS)
{
    m_pGame=NULL;
    m_pCamera=NULL;
    //
    m_pModelActor=NULL;
    //
    m_pAttackArea=NULL;
    m_pDefenseArea=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CTorus::~CTorus(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_pModelActor==NULL){return false;}
    //
    m_pGame=pConvParam->pGame;
    m_pCamera=pConvParam->pManager->GetCamera();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnInitialize(void* pParam)
{
    // SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=m_pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pDefenseArea=m_pGame->CreateDefenseArea(this);
    if(m_pDefenseArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-0.7f,-0.2f,-0.7f),Math::Vector3D(0.7f,0.2f,0.7f));
    m_pDefenseArea->SetBox(Math::Vector3D(-0.7f,-0.2f,-0.7f),Math::Vector3D(0.7f,0.2f,0.7f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnDestroy(void)
{
    SAFE_RELEASE(m_pCamera);
    SAFE_RELEASE(m_pModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->RotationQuaternion(m_Direction);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pDefenseArea->TransformReset();
    m_pDefenseArea->RotationQuaternion(m_Direction);
    m_pDefenseArea->Translation(m_Position);
    m_pDefenseArea->TransformUpdate();
    //
    m_pModelActor->TransformReset();
    m_pModelActor->RotationQuaternion(m_Direction);
    m_pModelActor->Translation(m_Position);
    m_pModelActor->TransformUpdate();
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnUpdate(void)
{
    // m_Position+=m_Velocity;
    // m_Direction.Mul(m_Rotation,m_Direction); // 
    // m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length())); // normalize
    //
    if(!UpdateParam())
    {
        return false;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnDraw(void)
{
    m_pModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CTorus::OnKill(void)
{
    CBombEffect* pBombEffect=m_pGame->CreateBombEffect(1.0f);
    if(pBombEffect!=NULL)
    {
        pBombEffect->SetPosition(m_Position);
        pBombEffect->UpdateParam();
    }
    //
    SAFE_RELEASE(m_pDefenseArea);
    SAFE_RELEASE(m_pAttackArea);
    return true;
}
///////////////////////////////////////////////////////////////
void CTorus::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CTorus::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CTorus::PushUp(void)
{
    // IuWFNgWŽZo
    Math::Vector3D VecZ;
    Math::Quaternion QtZ;
    QtZ.Conjugate(m_Direction);
    QtZ.Mul(Math::Quaternion(0.0f,0.0f,1.0f,0.0f));
    QtZ.Mul(m_Direction);
    //
    VecZ=Math::Vector3D(QtZ.x,QtZ.y,QtZ.z);
    VecZ.y=0.0f;
    VecZ.Normalize();
    //
    m_Position+=VecZ*0.1f;
}
///////////////////////////////////////////////////////////////
void CTorus::PushDown(void)
{
    // IuWFNgWŽZo
    Math::Vector3D VecZ;
    Math::Quaternion QtZ;
    QtZ.Conjugate(m_Direction);
    QtZ.Mul(Math::Quaternion(0.0f,0.0f,1.0f,0.0f));
    QtZ.Mul(m_Direction);
    //
    VecZ=Math::Vector3D(QtZ.x,QtZ.y,QtZ.z);
    VecZ.y=0.0f;
    VecZ.Normalize();
    //
    m_Position-=VecZ*0.1f;
}
///////////////////////////////////////////////////////////////
void CTorus::PushLeft(void)
{
    Math::Quaternion Qt;
    Qt=Math::Quaternion(0.0f,0.02f,0.0f,1.0f);
    Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length()));
    m_Direction.Mul(Qt,m_Direction);
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length()));
}
///////////////////////////////////////////////////////////////
void CTorus::PushRight(void)
{
    Math::Quaternion Qt;
    Qt=Math::Quaternion(0.0f,-0.02f,0.0f,1.0f);
    Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length()));
    m_Direction.Mul(Qt,m_Direction);
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length()));
}
///////////////////////////////////////////////////////////////
void CTorus::PushShot(void)
{
    // IuWFNgWŽZo
    Math::Vector3D VecZ;
    Math::Quaternion QtZ;
    QtZ.Conjugate(m_Direction);
    QtZ.Mul(Math::Quaternion(0.0f,0.0f,1.0f,0.0f));
    QtZ.Mul(m_Direction);
    VecZ=Math::Vector3D(QtZ.x,QtZ.y,QtZ.z);
    VecZ.y=0.0f;
    VecZ.Normalize();
    //
    CBeam* pBeam=m_pGame->CreateBeam();
    if(pBeam!=NULL)
    {
        pBeam->SetPosition(m_Position+VecZ);
        pBeam->SetDirection(m_Direction);
        pBeam->SetSpeed(1.0f);
        pBeam->UpdateParam();
    }
}
///////////////////////////////////////////////////////////////
const Math::Vector3D& CTorus::GetPosition(void)
{
    return m_Position;
}
///////////////////////////////////////////////////////////////
const Math::Quaternion& CTorus::GetDirection(void)
{
    return m_Direction;
}
///////////////////////////////////////////////////////////////
CTorusReservoir::CTorusReservoir(void)
{
    m_pModel=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CTorusReservoir::~CTorusReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CTorusReservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pModel=pRender->CreateModelFromFile("torus.smf");
    if(m_pModel==NULL){return false;}
    //
    CTorus::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    Param.pGame=pGame;
    //
    return CActorReservoir<CTorus>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CTorusReservoir::Finalize(void)
{
    if(!CActorReservoir<CTorus>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CTorus* CTorusReservoir::GetNewActiveObject(void)
{
    // CCube::SInitializeParam Param;
    // Param.pGame=m_pGame;
    //
    return CActorReservoir<CTorus>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CTorus> CTorusReservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CTorus>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CTorusReservoir::Update(void)
{
    return CActorReservoir<CTorus>::Update();
}
///////////////////////////////////////////////////////////////
bool CTorusReservoir::Draw(void)
{
    return CActorReservoir<CTorus>::Draw();
}
///////////////////////////////////////////////////////////////