#pragma once
#include "reservoir_base.h"
///////////////////////////////////////////////////////////////
template<typename C> class CReservoirIterator:private IBaseReservoirIterator
{
public:
    CReservoirIterator(IBaseReserveObject* pObject)
    {
        SetObject(pObject);
    }
    CReservoirIterator(CReservoirIterator& Iterator)
    {
        SetObject(Iterator.GetObject());
    }
    ~CReservoirIterator(void)
    {
        ;
    }
    //
    C* Object(void)
    {
        return (C*)GetObject();
    }
    //
    CReservoirIterator& operator=(CReservoirIterator& Iterator)
    {
        SetObject(Iterator.GetObject());
        //
        return *this;
    }
    CReservoirIterator& operator++(void)
    {
        GoNext();
        return *this;
    }
    CReservoirIterator& operator--(void)
    {
        GoPrev();
        return *this;
    }
    //
    bool operator==(CReservoirIterator& Iterator)
    {
        return IsEqual(Iterator.GetObject());
    }
    bool operator!=(CReservoirIterator& Iterator)
    {
        return !IsEqual(Iterator.GetObject());
    }
    bool IsEnd(void)
    {
        return IBaseReservoirIterator::IsEnd();
    }
};
//
template<typename C> class CReservoir:private IBaseReservoir
{
private:
    C* m_pObjectArray;
    int m_ObjectCount;
public:
    CReservoir(void)
    {
        m_pObjectArray=NULL;
        m_ObjectCount=0;
    }
    ~CReservoir(void)
    {
        ;
    }
    //
    bool Initialize(int ObjectCount,void* pParam)
    {
        m_pObjectArray=new C[ObjectCount];
        if(m_pObjectArray==NULL)
        {
            return false;
        }
        //
        m_ObjectCount=ObjectCount;
        //
        for(int i=0;i<m_ObjectCount;i++)
        {
            if(!CreateObject(m_pObjectArray+i,pParam))
            {
                return false;
            }
        }
        //
        return true;
    }
    bool Finalize(void)
    {
        for(int i=0;i<m_ObjectCount;i++)
        {
            if(!DestroyObject(m_pObjectArray+i))
            {
                return false;
            }
        }
        //
        SAFE_DELETE_ARRAY(m_pObjectArray);
        m_ObjectCount=0;
        //
        return true;
    }
    //
    C* GetNewActiveObject(void* pParam)
    {
        return (C*)GetNewActiveBaseObject(pParam);
    }
    CReservoirIterator<C> GetActiveObjectIterator(void)
    {
        CReservoirIterator<C> It(GetActiveObjectHead());
        //
        return It;
    }
};