#include "cube4.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CCube4::CCube4(void)
:IBaseActorObject(ACTOR_OBJECT_CUBE4)
{
    m_pGame=NULL;
    //
    m_pModelActor=NULL;
    //
    m_pAttackArea=NULL;
    m_pDefenseArea=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CCube4::~CCube4(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_pModelActor==NULL){return false;}
    //
    m_pGame=pConvParam->pGame;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnInitialize(void* pParam)
{
    // SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=m_pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pDefenseArea=m_pGame->CreateDefenseArea(this);
    if(m_pDefenseArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-2.0f,-1.0f,-2.0f),Math::Vector3D(2.0f,1.0f,2.0f));
    m_pDefenseArea->SetBox(Math::Vector3D(-2.0f,-1.0f,-2.0f),Math::Vector3D(2.0f,1.0f,2.0f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    m_IsPreKilled=false;
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnDestroy(void)
{
    SAFE_RELEASE(m_pModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->RotationQuaternion(m_Direction);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pDefenseArea->TransformReset();
    m_pDefenseArea->RotationQuaternion(m_Direction);
    m_pDefenseArea->Translation(m_Position);
    m_pDefenseArea->TransformUpdate();
    //
    m_pModelActor->TransformReset();
    m_pModelActor->RotationQuaternion(m_Direction);
    m_pModelActor->Translation(m_Position);
    m_pModelActor->TransformUpdate();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnUpdate(void)
{
    if(m_IsPreKilled)
    {
        Kill();
        return true;
    }
    //
    m_Position+=m_Velocity;
    m_Direction.Mul(m_Rotation,m_Direction); // 
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length())); // normalize
    //
    if(!UpdateParam())
    {
        return false;
    }
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnDraw(void)
{
    m_pModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    IBaseActorObject* pActor=pAttackArea->GetObject();
    switch(pActor->GetObjectType())
    {
    case ACTOR_OBJECT_CUBE:
        m_IsPreKilled=true;
        break;
    default:
        m_IsPreKilled=true;
        break;
    }
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube4::OnKill(void)
{
    CBombEffect* pBombEffect=m_pGame->CreateBombEffect(3.0f);
    if(pBombEffect!=NULL)
    {
        pBombEffect->SetPosition(m_Position);
        pBombEffect->UpdateParam();
    }
    // Cubẽp[^_ɂ
    Math::CRandom* pRandom=m_pGame->GetRandom();
    //
    Math::Quaternion QtTmp;
    // IuWFNgWŽZo
    Math::Vector3D VecZ;
    Math::Quaternion QtZ;
    QtZ.Conjugate(m_Direction);
    QtZ.Mul(Math::Quaternion(0.0f,0.0f,1.0f,0.0f));
    QtZ.Mul(m_Direction);
    VecZ=Math::Vector3D(QtZ.x,QtZ.y,QtZ.z);
    VecZ.y=0.0f;
    VecZ.Normalize();
    // Zx쐬
    Math::Vector3D VelPlus=VecZ*0.05f;
    // Z]x쐬
    Math::Quaternion QtRotPlus;
    QtRotPlus=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
    QtRotPlus.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/QtRotPlus.Length())); // normalize
    CCube2* pCube2=m_pGame->CreateCube2();
    if(pCube2!=NULL)
    {
        pCube2->SetPosition(m_Position+VecZ*2.45f);//
        pCube2->SetVelocity(m_Velocity+VelPlus);//
        pCube2->SetDirection(m_Direction);
        QtTmp.Mul(QtRotPlus,m_Rotation); //Ȃ
        pCube2->SetRotation(QtTmp); //
        pCube2->UpdateParam();
        
        pCube2=m_pGame->CreateCube2();
        if(pCube2!=NULL)
        {
            pCube2->SetPosition(m_Position+VecZ*-2.45f);//
            pCube2->SetVelocity(m_Velocity-VelPlus);//
            pCube2->SetDirection(m_Direction);
            QtRotPlus.Conjugate();
            QtTmp.Mul(QtRotPlus,m_Rotation); //Ȃ
            pCube2->SetRotation(QtTmp); //
            pCube2->UpdateParam();
        }
        
    }
    //
    SAFE_RELEASE(m_pDefenseArea);
    SAFE_RELEASE(m_pAttackArea);
    return true;
}
///////////////////////////////////////////////////////////////
void CCube4::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CCube4::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CCube4::SetVelocity(const Math::Vector3D& Velocity)
{
    m_Velocity=Velocity;
}
///////////////////////////////////////////////////////////////
void CCube4::SetRotation(const Math::Quaternion& Rotation)
{
    m_Rotation=Rotation;
}
///////////////////////////////////////////////////////////////
CCube4Reservoir::CCube4Reservoir(void)
{
    m_pModel=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CCube4Reservoir::~CCube4Reservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube4Reservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pModel=pRender->CreateModelFromFile("cube4.smf");
    if(m_pModel==NULL){return false;}
    //
    CCube4::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    Param.pGame=pGame;
    //
    return CActorReservoir<CCube4>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CCube4Reservoir::Finalize(void)
{
    if(!CActorReservoir<CCube4>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CCube4* CCube4Reservoir::GetNewActiveObject(void)
{
    // CCube4::SInitializeParam Param;
    // Param.pGame=m_pGame;
    //
    return CActorReservoir<CCube4>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CCube4> CCube4Reservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CCube4>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CCube4Reservoir::Update(void)
{
    return CActorReservoir<CCube4>::Update();
}
///////////////////////////////////////////////////////////////
bool CCube4Reservoir::Draw(void)
{
    return CActorReservoir<CCube4>::Draw();
}
///////////////////////////////////////////////////////////////