#include "bombeffect.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CBombEffect::CBombEffect(void)
:IBaseActorObject(ACTOR_OBJECT_BOMB_EFFECT)
{
    m_pGame=NULL;
    //
    m_pParticle=NULL;
    m_pParticleActor=NULL;
    //
    // Math::Vector3D m_Position;
    // SBombParam m_Bomb[16];
    // int m_Count;
}
///////////////////////////////////////////////////////////////
CBombEffect::~CBombEffect(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pParticle=pConvParam->pRender->CreateParticle(32,pConvParam->pTexture,PARTICLE_TYPE_VOLUME,true);
    if(m_pParticle==NULL){return false;}
    //
    m_pParticleActor=pConvParam->pManager->CreateActor(m_pParticle);
    if(m_pParticleActor==NULL){return false;}
    //
    m_pGame=pConvParam->pGame;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnInitialize(void* pParam)
{
    SInitializeParam* pConvParam=(SInitializeParam*)pParam;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    //
    Math::CRandom* pRandom=m_pGame->GetRandom();
    for(int i=0;i<16;i++)
    {
        if(i!=0)
        {
            m_Bomb[i].Pos=Math::Vector3D(0.0f,pConvParam->Radian,0.0f);
            m_Bomb[i].Pos.RotationX(DEG_TO_ANGLE(pRandom->GetFloat(0.0f,180.0f)));
            m_Bomb[i].Pos.RotationY(DEG_TO_ANGLE(pRandom->GetFloat(0.0f,360.0f)));
        }
        else
        {
            m_Bomb[i].Pos=Math::Vector3D(0.0f,0.0f,0.0f);
        }
        m_Bomb[i].AlphaNow=255;
        m_Bomb[i].RadianNow=pConvParam->Radian*pRandom->GetFloat(2.0f,4.0f);
        m_Bomb[i].AngleNow=pRandom->GetFloat(0.0f,360.0f);
        m_Bomb[i].RadianDest=m_Bomb[i].RadianNow+pConvParam->Radian*pRandom->GetFloat(2.0f,4.0f);
        m_Bomb[i].AngleDest=pRandom->GetFloat(0.0f,360.0f);
    }
    //
    m_Count=15;
    //
    SetKilled(false);
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnDestroy(void)
{
    SAFE_RELEASE(m_pParticleActor);
    SAFE_RELEASE(m_pParticle);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::UpdateParam(void)
{
    m_pParticle->SetBasePosition(m_Position);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnUpdate(void)
{
    if(m_Count)
    {
        for(int i=0;i<16;i++)
        {
            m_Bomb[i].AlphaNow-=m_Bomb[i].AlphaNow/m_Count;
            m_Bomb[i].RadianNow+=(m_Bomb[i].RadianDest-m_Bomb[i].RadianNow)/m_Count;
            m_Bomb[i].AngleNow+=(m_Bomb[i].AngleDest-m_Bomb[i].AngleNow)/m_Count;
        }
        m_Count--;
    }
    else
    {
        Kill();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnDraw(void)
{
    m_pParticle->Begin();
    for(int i=0;i<16;i++)
    {
        m_pParticle->DrawRotate(m_Bomb[i].Pos,Math::Point2DF(m_Bomb[i].RadianNow,m_Bomb[i].RadianNow),
            Math::Rect2DI(0,0,64,64),CColor(255,255,255,m_Bomb[i].AlphaNow),DEG_TO_ANGLE(m_Bomb[i].AngleNow));
    }
    m_pParticle->End();
    m_pParticleActor->RenderingRequest();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CBombEffect::OnKill(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
void CBombEffect::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
CBombEffectReservoir::CBombEffectReservoir(void)
{
    m_pTexture=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CBombEffectReservoir::~CBombEffectReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CBombEffectReservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pTexture=pRender->CreateTextureFromFile("bomb.png");
    if(m_pTexture==NULL){return false;}
    //
    CBombEffect::SCreateParam Param;
    Param.pRender=pRender;
    Param.pManager=pManager;
    Param.pTexture=m_pTexture;
    Param.pGame=pGame;
    //
    return CActorReservoir<CBombEffect>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CBombEffectReservoir::Finalize(void)
{
    if(!CActorReservoir<CBombEffect>::Finalize()){return false;}
    SAFE_RELEASE(m_pTexture);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CBombEffect* CBombEffectReservoir::GetNewActiveObject(float Radian)
{
    CBombEffect::SInitializeParam Param;
    Param.Radian=Radian;
    //
    return CActorReservoir<CBombEffect>::GetNewActiveObject(&Param);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CBombEffect> CBombEffectReservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CBombEffect>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CBombEffectReservoir::Update(void)
{
    return CActorReservoir<CBombEffect>::Update();
}
///////////////////////////////////////////////////////////////
bool CBombEffectReservoir::Draw(void)
{
    return CActorReservoir<CBombEffect>::Draw();
}
///////////////////////////////////////////////////////////////