#pragma once
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CBeam :public IBaseActorObject
{
friend class CBeamReservoir;
private:
    // OnCreate(CActorReservoir<>::Initialize)̈
    struct SCreateParam
    {
        Renderer::IRender* pRender;
        Scene::ISceneManager* pManager;
        Renderer::ITexture* pBodyTexture;
        Renderer::ITexture* pHeadTexture;
        CGame* pGame;
    };
    // OnInitialize(CActorReservoir<>::GetNewActiveObject)̈
    struct SInitializeParam
    {
        ;
    };
    // CActorReservoir<>::GetNewActiveObjectŎ擾Ƀp[^ݒ
private:
    // external
    CGame* m_pGame;
    Scene::ICamera* m_pCamera;
    // OnCreate/OnDestroy
    Renderer::Object::ISprite3D* m_pSprite;
    Renderer::Object::IParticle* m_pParticle;
    //
    Renderer::Object::SSpriteListData3D m_BeamList[2];
    //
    Scene::ISpriteActor* m_pBodyActor;
    Scene::IParticleActor* m_pHeadActor;
    // OnInitialize/OnKill
    CAttackArea* m_pAttackArea;
    CDefenseArea* m_pDefenseArea;
    //
    Math::Vector3D  m_Position;
    Math::Quaternion m_Direction;
    float   m_Speed;
    //
    bool m_IsPreKilled;
public:
    CBeam(void);
    ~CBeam(void);
    //
protected:
    bool OnCreate(void* pParam);
    bool OnInitialize(void* pParam);
    bool OnFinalize(void);
    bool OnDestroy(void);
public:
    bool UpdateParam(void);
public:
    bool OnUpdate(void);
    bool OnDraw(void);
public:
    bool OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea);
    bool OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea);
    //
    bool OnKill(void);
public:
    void SetPosition(const Math::Vector3D& Position);
    void SetDirection(const Math::Quaternion& Direction);
    void SetSpeed(float Speed);
};
///////////////////////////////////////////////////////////////
class CBeamReservoir :private CActorReservoir<CBeam>
{
private:
    Scene::ICamera* m_pCamera;
    Renderer::ITexture* m_pBodyTexture;
    Renderer::ITexture* m_pHeadTexture;
    CGame* m_pGame;
public:
    CBeamReservoir(void);
    ~CBeamReservoir(void);
    //
    bool Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame);
    bool Finalize(void);
    //
    CBeam* GetNewActiveObject(void);
    CReservoirIterator<CBeam> GetActiveObjectIterator(void);
    //
    bool Update(void);
    bool Draw(void);
};