#pragma once
#include "reservoir.h"
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CBoundingBox:public IBaseReserveObject,public Math::Style
{
friend class CCollisionDetector;
private:
    IBaseActorObject* m_pObject;
    bool m_IsEnable;
    Math::Vector3D m_MinPt;
    Math::Vector3D m_MaxPt;
    //
    Math::Matrix   m_Matrix;
public:
    CBoundingBox(void);
    ~CBoundingBox(void);
    //
    IBaseActorObject* GetObject(void);
    void SetEnable(bool IsEnable);
    bool IsEnable(void);
    void SetBox(const Math::Vector3D& MinPt,const Math::Vector3D& MaxPt);
    void TransformUpdate(void);
protected:
    bool OnCreate(void* pParam); // pParam==NULL
    bool OnInitialize(void* pParam); // pParam=(IBaseActorObject*)pObject
    bool OnFinalize(void);
    bool OnDestroy(void);
};
//
class CAttackArea:public CBoundingBox
{
};
//
class CDefenseArea:public CBoundingBox
{
};
//
class CCollisionDetector
{
private:
    CReservoir<CAttackArea> m_AttackAreaReservoir;
    CReservoir<CDefenseArea> m_DefenseAreaReservoir;
    //
    bool CheckDefense(CAttackArea* pAttackArea,Collision::CBox& AttackBox);
public:
    CCollisionDetector(void);
    ~CCollisionDetector(void);
    //
    bool Initialize(int AttackAreaCount,int DefenseAreaCount);
    //
    bool Check(void);
    bool DrawCollision(Renderer::Object::ILine3D* pLine,bool IsDrawAttack,bool IsDrawDefense);
    //
    CAttackArea* CreateAttackArea(IBaseActorObject* pObject);
    CDefenseArea* CreateDefenseArea(IBaseActorObject* pObject);
    //
    bool Finalize(void);
};