#include "beam.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CBeam::CBeam(void)
:IBaseActorObject(ACTOR_OBJECT_BEAM)
{
    m_pGame=NULL;
    m_pCamera=NULL;
    // OnCreate/OnDestroy
    m_pSprite=NULL;
    m_pParticle=NULL;
    //
    //Renderer::Object::SSpriteListData3D m_BeamList[16];
    //
    m_pBodyActor=NULL;
    m_pHeadActor=NULL;
    // OnInitialize/OnKill
    m_pAttackArea=NULL;
    m_pDefenseArea=NULL;
}
///////////////////////////////////////////////////////////////
CBeam::~CBeam(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=(SCreateParam*)pParam;
    m_pSprite=pConvParam->pRender->CreateSprite3D(100,pConvParam->pBodyTexture);
    if(m_pSprite==NULL){return false;}
    m_pBodyActor=pConvParam->pManager->CreateActor(m_pSprite);
    if(m_pBodyActor==NULL){return false;}
    //
    m_pParticle=pConvParam->pRender->CreateParticle(100,pConvParam->pHeadTexture,PARTICLE_TYPE_NORMAL);
    if(m_pParticle==NULL){return false;}
    m_pHeadActor=pConvParam->pManager->CreateActor(m_pParticle);
    if(m_pHeadActor==NULL){return false;}
    //
    for(int i=0;i<2;i++)
    {
        m_BeamList[i].Pos=Math::Vector3D(0.0f,0.0f,0.0f);
        m_BeamList[i].Width=0.4f;
        m_BeamList[i].Color=CColor(255,255,255);
        m_BeamList[i].Angle=0;
    }
    //
    m_pGame=pConvParam->pGame;
    m_pCamera=pConvParam->pManager->GetCamera();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnInitialize(void* pParam)
{
    // SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=m_pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pDefenseArea=m_pGame->CreateDefenseArea(this);
    if(m_pDefenseArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-0.2f,-0.2f,-0.2f),Math::Vector3D(0.2f,0.2f,0.2f));
    m_pDefenseArea->SetBox(Math::Vector3D(-0.2f,-0.2f,-0.2f),Math::Vector3D(0.2f,0.2f,0.2f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    m_IsPreKilled=false;
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnDestroy(void)
{
    SAFE_RELEASE(m_pCamera);
    //
    SAFE_RELEASE(m_pHeadActor);
    SAFE_RELEASE(m_pParticle);
    //
    SAFE_RELEASE(m_pBodyActor);
    SAFE_RELEASE(m_pSprite);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->RotationQuaternion(m_Direction);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pDefenseArea->TransformReset();
    m_pDefenseArea->RotationQuaternion(m_Direction);
    m_pDefenseArea->Translation(m_Position);
    m_pDefenseArea->TransformUpdate();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnUpdate(void)
{
    if(m_IsPreKilled)
    {
        Kill();
        return true;
    }
    //
    Math::Quaternion QtTmp;
    // IuWFNgWŽZo
    Math::Vector3D VecZ;
    Math::Quaternion QtZ;
    QtZ.Mul(m_Direction,Math::Quaternion(0.0f,0.0f,1.0f,0.0f));
    QtTmp.Conjugate(m_Direction);
    QtZ.Mul(QtZ,QtTmp);
    VecZ=Math::Vector3D(QtZ.x,QtZ.y,QtZ.z);
    VecZ.y=0.0f;
    VecZ.Normalize();
    //
    m_Position+=VecZ*m_Speed;
    //
    m_BeamList[1].Pos=m_BeamList[0].Pos-VecZ*m_Speed*5.0f;
    m_BeamList[0].Pos=m_Position;
    //
    UpdateParam();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnDraw(void)
{
    m_pParticle->Begin();
    m_pParticle->Draw(m_BeamList[0].Pos,Math::Point2DF(m_BeamList[0].Width*2,m_BeamList[0].Width*2),
        Math::Rect2DI(0,0,64,64),CColor(255,255,255));
    m_pParticle->End();
    m_pHeadActor->RenderingRequest();
    //
    m_pSprite->Begin();
    m_pSprite->DrawPolyLine(m_pCamera->Position(),m_BeamList,2,Math::Rect2DF(0.0f,0.0f,64.0f,550.0f));
    m_pSprite->End();
    m_pBodyActor->TransformReset();
    m_pBodyActor->TransformUpdate();
    m_pBodyActor->RenderingRequest();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    switch(pAttackArea->GetObject()->GetObjectType())
    {
    case ACTOR_OBJECT_OBSTACLEBOX:
        m_IsPreKilled=true;
        break;
    default:
        break;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::OnKill(void)
{
    SAFE_RELEASE(m_pDefenseArea);
    SAFE_RELEASE(m_pAttackArea);
    return true;
}
///////////////////////////////////////////////////////////////
void CBeam::SetPosition(const Math::Vector3D& Position)
{
    m_BeamList[0].Pos=Position;
    m_BeamList[1].Pos=Position;
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CBeam::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CBeam::SetSpeed(float Speed)
{
    m_Speed=Speed;
}
///////////////////////////////////////////////////////////////
CBeamReservoir::CBeamReservoir(void)
{
    m_pCamera=NULL;
    m_pBodyTexture=NULL;
    m_pHeadTexture=NULL;
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CBeamReservoir::~CBeamReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CBeamReservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pBodyTexture=pRender->CreateTextureFromFile("beam_body.png");
    if(m_pBodyTexture==NULL){return false;}
    m_pHeadTexture=pRender->CreateTextureFromFile("beam_head.png");
    if(m_pHeadTexture==NULL){return false;}
    //
    CBeam::SCreateParam Param;
    Param.pRender=pRender;
    Param.pManager=pManager;
    Param.pBodyTexture=m_pBodyTexture;
    Param.pHeadTexture=m_pHeadTexture;
    Param.pGame=pGame;
    //
    return CActorReservoir<CBeam>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CBeamReservoir::Finalize(void)
{
    if(!CActorReservoir<CBeam>::Finalize()){return false;}
    SAFE_RELEASE(m_pHeadTexture);
    SAFE_RELEASE(m_pBodyTexture);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CBeam* CBeamReservoir::GetNewActiveObject(void)
{
    return CActorReservoir<CBeam>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CBeam> CBeamReservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CBeam>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CBeamReservoir::Update(void)
{
    return CActorReservoir<CBeam>::Update();
}
///////////////////////////////////////////////////////////////
bool CBeamReservoir::Draw(void)
{
    return CActorReservoir<CBeam>::Draw();
}
///////////////////////////////////////////////////////////////