#include "beam.h"
///////////////////////////////////////////////////////////////
CBeam::CBeam(void)
{
    m_pBodyTexture=NULL;
    m_pSprite=NULL;
    //
    m_pHeadTexture=NULL;
    m_pParticle=NULL;
    // Renderer::Object::SSpriteListData3D m_BeamList[16];
    //
    m_pBodyActor=NULL;
    m_pHeadActor=NULL;
}
///////////////////////////////////////////////////////////////
CBeam::~CBeam(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CBeam::Initialize(Renderer::IRender* pRender,Scene::ISceneManager* pManager)
{
    m_pBodyTexture=pRender->CreateTextureFromFile("beam_body.png");
    if(m_pBodyTexture==NULL){return false;}
    m_pSprite=pRender->CreateSprite3D(100,m_pBodyTexture);
    if(m_pSprite==NULL){return false;}
    m_pBodyActor=pManager->CreateActor(m_pSprite);
    if(m_pBodyActor==NULL){return false;}
    //
    m_pHeadTexture=pRender->CreateTextureFromFile("beam_head.png");
    if(m_pHeadTexture==NULL){return false;}
    m_pParticle=pRender->CreateParticle(100,m_pHeadTexture,PARTICLE_TYPE_NORMAL);
    if(m_pParticle==NULL){return false;}
    m_pHeadActor=pManager->CreateActor(m_pParticle);
    if(m_pHeadActor==NULL){return false;}
    //
    for(int i=0;i<16;i++)
    {
        m_BeamList[i].Pos=Math::Vector3D(0.0f,0.0f,0.0f);
        m_BeamList[i].Width=0.03f;
        m_BeamList[i].Color=CColor(255,255,255);
        m_BeamList[i].Angle=0;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBeam::Finalize(void)
{
    SAFE_RELEASE(m_pHeadActor);
    SAFE_RELEASE(m_pParticle);
    SAFE_RELEASE(m_pHeadTexture);
    //
    SAFE_RELEASE(m_pBodyActor);
    SAFE_RELEASE(m_pSprite);
    SAFE_RELEASE(m_pBodyTexture);
    //
    return true;
}
///////////////////////////////////////////////////////////////
void CBeam::UpdatePos(Math::Vector3D Pos)
{
    for(int i=15;i>0;i--)
    {
        m_BeamList[i].Pos=m_BeamList[i-1].Pos;
    }
    //
    m_BeamList[0].Pos=Pos;
}
///////////////////////////////////////////////////////////////
void CBeam::Draw(Math::Vector3D Camera)
{
    m_pParticle->Begin();
    m_pParticle->Draw(m_BeamList[0].Pos,Math::Point2DF(m_BeamList[0].Width*2,m_BeamList[0].Width*2),
        Math::Rect2DI(0,0,64,64),CColor(255,255,255));
    m_pParticle->End();
    m_pHeadActor->RenderingRequest();
    //
    m_pSprite->Begin();
    m_pSprite->DrawPolyLine(Camera,m_BeamList,16,Math::Rect2DF(0.0f,0.0f,64.0f,550.0f));
    m_pSprite->End();
    m_pBodyActor->TransformReset();
    m_pBodyActor->TransformUpdate();
    m_pBodyActor->RenderingRequest();
}
///////////////////////////////////////////////////////////////