#include "app.h"
///////////////////////////////////////////////////////////////
CApp::CApp(void)
{
    m_pCore=NULL;
    m_pGraphicCard=NULL;
    m_pRender=NULL;
    m_pKeyboard=NULL;
    //
    m_pSceneManager=NULL;
    m_pCamera=NULL;
    m_Pos=Math::Vector3D(0.0f,0.0f,0.0f);
}
///////////////////////////////////////////////////////////////
CApp::~CApp(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CApp::Initialize(void)
{
    System::Initialize();
    // RA̐ 
    m_pCore=System::CreateCore();
    // 
    if(!m_pCore->Initialize("Hello World",FRAME_RATE_60)){return false;}
    // ^Cgo[ɏ\
    m_pCore->EnableDrawTitleInformation(true);
    // OtBbNJ[h擾
    m_pGraphicCard=m_pCore->CreateGraphicCard(GRAPHIC_CARD_DEFAULT_NO);
    if(m_pGraphicCard==NULL){return false;}
    // EBhE쐬(640x480,WindowMode)
    m_pCore->Start(640,480,true);
    // _[擾
    m_pRender=m_pGraphicCard->CreateRender();
    if(m_pGraphicCard==NULL){return false;}
    // L[{[h擾
    m_pKeyboard=m_pCore->GetKeyboard();
    if(m_pKeyboard==NULL){return false;}
    // V[}l[W[𐶐
    m_pSceneManager=m_pRender->CreateSceneManager(300,true);
    if(m_pSceneManager==NULL){return false;}
    // V[}l[W[̏np[^ݒEXV
    m_pSceneManager->InitParameter_RenderTargetData(NULL,Math::Point2DI(640,480),false);
    m_pSceneManager->InitParameter_Shading(SHADING_TYPE_NORMAL);
    if(!m_pSceneManager->InitParameter_Update()){return false;}
    // J̎擾Eݒ
    m_pCamera=m_pSceneManager->GetCamera();
    if(m_pCamera==NULL){return false;}
    m_pCamera->UpdateProjection(1.0f,1000.0f,DEG_TO_ANGLE(45.0f),640,480);
    // Beam̍쐬
    if(!m_Beam.Initialize(m_pRender,m_pSceneManager)){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CApp::Run(void)
{
    while(m_pCore->Run())
    {
        // Update
        if(m_pKeyboard->GetKeyData(SELENE_VK_LEFT)){m_Pos.x-=0.05f;m_Beam.UpdatePos(m_Pos);}
        if(m_pKeyboard->GetKeyData(SELENE_VK_RIGHT)){m_Pos.x+=0.05f;m_Beam.UpdatePos(m_Pos);}
        if(m_pKeyboard->GetKeyData(SELENE_VK_UP)){m_Pos.z+=0.05f;m_Beam.UpdatePos(m_Pos);}
        if(m_pKeyboard->GetKeyData(SELENE_VK_DOWN)){m_Pos.z-=0.05f;m_Beam.UpdatePos(m_Pos);}        
        // J̈ʒuEp̍XV
        m_pCamera->Reset();
        m_pCamera->SetTransformSimple(Math::Vector3D(0.0f,0.0f,-8.0f),Math::Vector3D(0.0f,0.0f,0.0f),DEG_TO_ANGLE(0.0f));
        m_pCamera->Update();
        // V[}l[W[̃Zbg
        m_pSceneManager->Reset();
        m_pSceneManager->SetParameter_BGColor(CColor(128,128,128));
        // V[ɕs𓖂Ă
        m_pSceneManager->SetLightParameter_Directional(Math::Vector3D(0.5f,-0.5f,0.7f),Math::Vector3D(0.8f,0.8f,0.8f));
        // V[}l[W[ւ̃_ONGXg(Ȃ炸J̈ʒup߂Ă)
        m_pRender->SetDrawType(DRAW_TYPE_ADD);
        m_pRender->SetAlphaTestEnable(true);
        m_pRender->SetCullType(CULL_NONE);
        m_pSceneManager->Begin(false);
        m_Beam.Draw(Math::Vector3D(0.0f,0.0f,-8.0f));
        m_pSceneManager->End();
        // ʂ̃NA(white)
        m_pRender->Clear(CColor(255,255,255));
        // ʂւ̕`
        m_pRender->Begin();
        m_pSceneManager->Rendering(true);
        m_pRender->DrawText(Math::Point2DI(0,0),CColor(0,0,0),"Pos=[%2.2f,%2.2f,%2.2f];",m_Pos.x,m_Pos.y,m_Pos.z);
        m_pRender->End();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
void CApp::Finalize(void)
{
    m_Beam.Finalize();
    //
    SAFE_RELEASE(m_pCamera);
    SAFE_RELEASE(m_pSceneManager);
    //
    SAFE_RELEASE(m_pKeyboard);
    SAFE_RELEASE(m_pRender);
    SAFE_RELEASE(m_pGraphicCard);
    SAFE_RELEASE(m_pCore);
    // VXẻ
    System::Finalize();
}
///////////////////////////////////////////////////////////////