#include "obstaclebox.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CObstacleBox::CObstacleBox(void)
:IBaseActorObject(ACTOR_OBJECT_OBSTACLEBOX)
{
    m_pGame=NULL;
    //
    m_pModelActor=NULL;
    //
    m_pAttackArea=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Scale=Math::Vector3D(1.0f,1.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CObstacleBox::~CObstacleBox(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_pModelActor==NULL){return false;}
    //
    m_pGame=pConvParam->pGame;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnInitialize(void* pParam)
{
    // SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=m_pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-0.5f,-0.5f,-0.5f),Math::Vector3D(0.5f,0.5f,0.5f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnDestroy(void)
{
    SAFE_RELEASE(m_pModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->Scaling(m_Scale.x,m_Scale.y,m_Scale.z);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pModelActor->TransformReset();
    m_pModelActor->Scaling(m_Scale.x,m_Scale.y,m_Scale.z);
    m_pModelActor->Translation(m_Position);
    m_pModelActor->TransformUpdate();
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnUpdate(void)
{
    UpdateParam();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnDraw(void)
{
    m_pModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CObstacleBox::OnKill(void)
{
    SAFE_RELEASE(m_pAttackArea);
    //
    return true;
}
///////////////////////////////////////////////////////////////
void CObstacleBox::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CObstacleBox::SetScale(const Math::Vector3D& Scale)
{
    m_Scale=Scale;
}
///////////////////////////////////////////////////////////////
CObstacleBoxReservoir::CObstacleBoxReservoir(void)
{
    m_pModel=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CObstacleBoxReservoir::~CObstacleBoxReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CObstacleBoxReservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pModel=pRender->CreateModelFromFile("obstaclebox.smf");
    if(m_pModel==NULL){return false;}
    //
    CObstacleBox::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    Param.pGame=pGame;
    //
    return CActorReservoir<CObstacleBox>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CObstacleBoxReservoir::Finalize(void)
{
    if(!CActorReservoir<CObstacleBox>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CObstacleBox* CObstacleBoxReservoir::GetNewActiveObject(void)
{
    // CObstacleBox::SInitializeParam Param;
    // Param.pGame=m_pGame;
    //
    return CActorReservoir<CObstacleBox>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CObstacleBox> CObstacleBoxReservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CObstacleBox>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CObstacleBoxReservoir::Update(void)
{
    return CActorReservoir<CObstacleBox>::Update();
}
///////////////////////////////////////////////////////////////
bool CObstacleBoxReservoir::Draw(void)
{
    return CActorReservoir<CObstacleBox>::Draw();
}
///////////////////////////////////////////////////////////////