#pragma once
#include "preload.h"
#include "actorobject.h"
#include "collision.h"
#include "cube.h"
#include "cube2.h"
#include "cube4.h"
#include "cube8.h"
#include "bombeffect.h"
#include "obstaclebox.h"
///////////////////////////////////////////////////////////////
class CGame
{
public:
    struct SInitializeParam
    {
        Renderer::IRender* pRender;
        Scene::ISceneManager* pManager;
        int RandomSeed;
    };
    //
    enum eDrawOption
    {
        DRAW_NULL=0x00,
        DRAW_OBJECT=0x01,
        DRAW_ATTACK=0x02,
        DRAW_DEFENSE=0x04,
    };
private:
    Renderer::IRender* m_pRender;
    Scene::ISceneManager* m_pManager;
    Math::CRandom m_Random;
    //
    Renderer::Object::ILine3D* m_pLine;
    Scene::IPrimitiveActor* m_pLineActor;
    //
    eDrawOption m_DrawOption;
    //
    CCollisionDetector m_Detector;
    //
    CCubeReservoir m_CubeReservoir;
    CBombEffectReservoir m_BombEffectReservoir;
    CCube2Reservoir m_Cube2Reservoir;
    CCube4Reservoir m_Cube4Reservoir;
    CCube8Reservoir m_Cube8Reservoir;
    //
    CObstacleBoxReservoir m_ObstacleBoxReservoir;
    //
    CObstacleBox* m_pWall[4];
public:
    CGame(void);
    ~CGame(void);
    //
    bool Initialize(SInitializeParam* pParam);
    bool Finalize(void);
    // ͍XVՓ˔聨`̏(IuWFNg̐E폜͂Ȃ炸Updateł)
    bool Update(void);
    bool CheckCollision(void);
    bool Draw(void);
    // ̎擾
    Math::CRandom* GetRandom(void);
    // h[IvV
    //  DRAW_NULL    ...`Ȃ
    //  DRAW_OBJECT  ...IuWFNg`
    //  DRAW_ATTACK  ...UՓ˃GA`
    //  DRAW_DEFENSE ...hՓ˃GA`
    bool SetDrawOption(eDrawOption Option);
    // Փ˔
    // -̊֐ōASetBox֐AMath::StyleNX̊֐Ńp[^^̂Ɏg
    // -̃NXMath::StylepĂAʒuTransformUpdate֐ŃZbg銴ɂȂĂ
    CAttackArea* CreateAttackArea(IBaseActorObject* pObject);
    CDefenseArea* CreateDefenseArea(IBaseActorObject* pObject);
    //
    // IBaseActorObjecťpNXɂ
    // -\ɏoĂp[^ύXۂɂ͕KUpdateParam֐sƁA
    // -܂UpdateParamƗzp[^ύX͓ɏՓ˔莞(OnAttack,OnDefense),`掞(OnDraw)ɂ͎gȂ
    // -pȂƂȂz֐͈ȉ̂Ƃ
    //  -OnCreate      ... IuWFNg̕ۊǌɂInitialize鎞
    //  -OnInitialize  ... IuWFNg̕ۊǌɂIuWFNgĂ
    //  -OnFinalize    ... IuWFNgQƃJE^OɂȂ
    //                      (IuWFNg̕ۊǌɂȂȂ̃IuWFNg鎞)
    //  -OnDestroy     ... IuWFNg̕ۊǌɂFinalize鎞
    //  -OnKill        ... Kill(QƃJE^0łȂ\)
    //  -OnUpdate      ... XV
    //  -OnDraw        ... `掞
    //  -OnAttack      ... ̍UGÃIuWFNg̖hGAɏՓ˂
    //  -OnDefense     ... ̖hGÃIuWFNg̍UGAɏՓ˂
    //  -UpdateParam   ... ʂɉz֐ɂKvȂǋKi킹Ӗ/p[^̕ύXɎgp邱
    //
    // L[u
    // -̊֐ōASetPositionȂǂ̊֐ŏ^̂Ɏg
    CCube* CreateCube(void);
    // GtFNg
    // -̊֐ōASetPosition֐ŏ^̂Ɏg
    CBombEffect* CreateBombEffect(float Radian);
    // L[u2
    // -̊֐ōASetPositionȂǂ̊֐ŏ^̂Ɏg
    CCube2* CreateCube2(void);
    // L[u4
    // -̊֐ōASetPositionȂǂ̊֐ŏ^̂Ɏg
    CCube4* CreateCube4(void);
    // L[u8
    // -̊֐ōASetPositionȂǂ̊֐ŏ^̂Ɏg
    CCube8* CreateCube8(void);
    // Q{bNX
    // -̊֐ōASetPositionȂǂ̊֐ŏ^̂Ɏg
    CObstacleBox* CreateObstacleBox(void);
};