#include "game.h"
///////////////////////////////////////////////////////////////
CGame::CGame(void)
{
    m_pRender=NULL;
    m_pManager=NULL;
    //
    m_pLine=NULL;
    m_pLineActor=NULL;
    //
    m_DrawOption=DRAW_OBJECT;
    //
    m_pWall[0]=NULL;
    m_pWall[1]=NULL;
    m_pWall[2]=NULL;
    m_pWall[3]=NULL;
}
///////////////////////////////////////////////////////////////
CGame::~CGame(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CGame::Initialize(SInitializeParam* pParam)
{
    m_pRender=pParam->pRender;
    m_pManager=pParam->pManager;
    //
    m_pLine=m_pRender->CreateLine3D(8192,true);
    if(m_pLine==NULL){return false;}
    //
    m_pLineActor=m_pManager->CreateActor(m_pLine);
    if(m_pLineActor==NULL){return false;}
    //
    if(!m_Detector.Initialize(400,400)){return false;}
    if(!m_CubeReservoir.Initialize(200,m_pRender,m_pManager,this)){return false;}
    if(!m_BombEffectReservoir.Initialize(20,m_pRender,m_pManager,this)){return false;}
    if(!m_Cube2Reservoir.Initialize(100,m_pRender,m_pManager,this)){return false;}
    if(!m_Cube4Reservoir.Initialize(50,m_pRender,m_pManager,this)){return false;}
    if(!m_Cube8Reservoir.Initialize(25,m_pRender,m_pManager,this)){return false;}
    //
    if(!m_ObstacleBoxReservoir.Initialize(4,m_pRender,m_pManager,this)){return false;}
    //
    m_Random.Seed(pParam->RandomSeed);
    //
    m_pWall[0]=CreateObstacleBox();
    m_pWall[0]->SetPosition(Math::Vector3D(50.0f,0.0f,0.0f));
    m_pWall[0]->SetScale(Math::Vector3D(10.0f,1.0f,110.0f));
    m_pWall[0]->UpdateParam();
    //
    m_pWall[1]=CreateObstacleBox();
    m_pWall[1]->SetPosition(Math::Vector3D(0.0f,0.0f,50.0f));
    m_pWall[1]->SetScale(Math::Vector3D(90.0f,1.0f,10.0f));
    m_pWall[1]->UpdateParam();
    //
    m_pWall[2]=CreateObstacleBox();
    m_pWall[2]->SetPosition(Math::Vector3D(-50.0f,0.0f,0.0f));
    m_pWall[2]->SetScale(Math::Vector3D(10.0f,1.0f,110.0f));
    m_pWall[2]->UpdateParam();
    //
    m_pWall[3]=CreateObstacleBox();
    m_pWall[3]->SetPosition(Math::Vector3D(0.0f,0.0f,-50.0f));
    m_pWall[3]->SetScale(Math::Vector3D(90.0f,1.0f,10.0f));
    m_pWall[3]->UpdateParam();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::Finalize(void)
{
    SAFE_RELEASE(m_pWall[3]);
    SAFE_RELEASE(m_pWall[2]);
    SAFE_RELEASE(m_pWall[1]);
    SAFE_RELEASE(m_pWall[0]);
    //
    if(!m_ObstacleBoxReservoir.Finalize()){return false;}
    //
    if(!m_Cube8Reservoir.Finalize()){return false;}
    if(!m_Cube4Reservoir.Finalize()){return false;}
    if(!m_Cube2Reservoir.Finalize()){return false;}
    if(!m_BombEffectReservoir.Finalize()){return false;}
    if(!m_CubeReservoir.Finalize()){return false;}
    if(!m_Detector.Finalize()){return false;}
    //
    SAFE_RELEASE(m_pLineActor);
    SAFE_RELEASE(m_pLine);
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::Update(void)
{
    if(!m_CubeReservoir.Update()){return false;}
    if(!m_BombEffectReservoir.Update()){return false;}
    if(!m_Cube2Reservoir.Update()){return false;}
    if(!m_Cube4Reservoir.Update()){return false;}
    if(!m_Cube8Reservoir.Update()){return false;}
    //
    if(!m_ObstacleBoxReservoir.Update()){return false;}
    //
    bool Flag[3];
    Flag[0]=(m_DrawOption & DRAW_OBJECT)?true:false;
    Flag[1]=(m_DrawOption & DRAW_ATTACK)?true:false;
    Flag[2]=(m_DrawOption & DRAW_DEFENSE)?true:false;
    //
    if(Flag[1]||Flag[2])
    {
        m_pLine->Begin();
        if(!m_Detector.DrawCollision(m_pLine,Flag[1],Flag[2])){return false;}
        m_pLine->End();
        m_pLineActor->TransformReset();
        m_pLineActor->TransformUpdate();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::CheckCollision(void)
{
    return m_Detector.Check();
}
///////////////////////////////////////////////////////////////
bool CGame::Draw(void)
{
    bool Flag[3];
    Flag[0]=(m_DrawOption & DRAW_OBJECT)?true:false;
    Flag[1]=(m_DrawOption & DRAW_ATTACK)?true:false;
    Flag[2]=(m_DrawOption & DRAW_DEFENSE)?true:false;
    //
    if(Flag[0])
    {
        if(!m_CubeReservoir.Draw()){return false;}
        if(!m_Cube2Reservoir.Draw()){return false;}
        if(!m_Cube4Reservoir.Draw()){return false;}
        if(!m_Cube8Reservoir.Draw()){return false;}
        if(!m_ObstacleBoxReservoir.Draw()){return false;}
        //
        if(!m_BombEffectReservoir.Draw()){return false;}
    }
    if(Flag[1]||Flag[2])
    {
        m_pLineActor->RenderingRequest();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
Math::CRandom* CGame::GetRandom(void)
{
    return &m_Random;
}
///////////////////////////////////////////////////////////////
bool CGame::SetDrawOption(eDrawOption Option)
{
    m_DrawOption=Option;
    return true;
}
///////////////////////////////////////////////////////////////
CAttackArea* CGame::CreateAttackArea(IBaseActorObject* pObject)
{
    return m_Detector.CreateAttackArea(pObject);
}
///////////////////////////////////////////////////////////////
CDefenseArea* CGame::CreateDefenseArea(IBaseActorObject* pObject)
{
    return m_Detector.CreateDefenseArea(pObject);
}
///////////////////////////////////////////////////////////////
CCube* CGame::CreateCube(void)
{
    return m_CubeReservoir.GetNewActiveObject();
}
///////////////////////////////////////////////////////////////
CBombEffect* CGame::CreateBombEffect(float Radian)
{
    return m_BombEffectReservoir.GetNewActiveObject(Radian);
}
///////////////////////////////////////////////////////////////
CCube2* CGame::CreateCube2(void)
{
    return m_Cube2Reservoir.GetNewActiveObject();
}
///////////////////////////////////////////////////////////////
CCube4* CGame::CreateCube4(void)
{
    return m_Cube4Reservoir.GetNewActiveObject();
}
///////////////////////////////////////////////////////////////
CCube8* CGame::CreateCube8(void)
{
    return m_Cube8Reservoir.GetNewActiveObject();
}
///////////////////////////////////////////////////////////////
CObstacleBox* CGame::CreateObstacleBox(void)
{
    return m_ObstacleBoxReservoir.GetNewActiveObject();
}
///////////////////////////////////////////////////////////////