#pragma once
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CBombEffect:public IBaseActorObject
{
friend class CBombEffectReservoir;
public:
    // OnCreate(CActorReservoir<>::Initialize)̈
    struct SCreateParam
    {
        Renderer::IRender* pRender;
        Scene::ISceneManager* pManager;
        Renderer::ITexture* pTexture;
        CGame* pGame;
    };
    // OnInitialize(CActorReservoir<>::GetNewActiveObject)̈
    struct SInitializeParam
    {
        float Radian;
    };
    // CActorReservoir<>::GetNewActiveObjectŎ擾Ƀp[^ݒ
private:
    // external
    CGame* m_pGame;
    // OnCreate/OnDestroy
    Renderer::Object::IParticle* m_pParticle;
    Scene::IParticleActor* m_pParticleActor;
    //
    struct SBombParam
    {
        Math::Vector3D Pos;
        //
        int AlphaNow;
        float RadianNow;
        float AngleNow;
        //
        float RadianDest;
        float AngleDest;
    };
    //
    Math::Vector3D m_Position;
    SBombParam m_Bomb[16];
    int m_Count;
public:
    CBombEffect(void);
    ~CBombEffect(void);
    //
protected:
    bool OnCreate(void* pParam);
    bool OnInitialize(void* pParam);
    bool OnFinalize(void);
    bool OnDestroy(void);
public:
    bool UpdateParam(void);
public:
    bool OnUpdate(void);
    bool OnDraw(void);
public:
    bool OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea);
    bool OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea);
    //
    bool OnKill(void);
public:
    void SetPosition(const Math::Vector3D& Position);
};
///////////////////////////////////////////////////////////////
class CBombEffectReservoir :private CActorReservoir<CBombEffect>
{
private:
    Renderer::ITexture* m_pTexture;
    CGame* m_pGame;
public:
    CBombEffectReservoir(void);
    ~CBombEffectReservoir(void);
    //
    bool Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame);
    bool Finalize(void);
    //
    CBombEffect* GetNewActiveObject(float Radian);
    CReservoirIterator<CBombEffect> GetActiveObjectIterator(void);
    //
    bool Update(void);
    bool Draw(void);
};
///////////////////////////////////////////////////////////////