#include "reservoir_base.h"
///////////////////////////////////////////////////////////////
IBaseReserveObject::IBaseReserveObject(void)
{
    m_pPrev=this;
    m_pNext=this;
    //
    m_pReservoir=NULL;
    m_RefCount=0;
}
///////////////////////////////////////////////////////////////
IBaseReserveObject::~IBaseReserveObject(void)
{
    ;
}
///////////////////////////////////////////////////////////////
int IBaseReserveObject::AddRef(void)
{
    return m_RefCount++;
}
///////////////////////////////////////////////////////////////
void IBaseReserveObject::Release(void)
{
    if(m_RefCount)
    {
        m_RefCount--;
    }
    else
    {
        OnFinalize();
        if(m_pReservoir!=NULL)
        {
            m_pReservoir->AppendIdleObject(this);
        }
    }
}
///////////////////////////////////////////////////////////////
IBaseReservoir::CDummyObject::CDummyObject(void)
{
    ;
}
///////////////////////////////////////////////////////////////
IBaseReservoir::CDummyObject::~CDummyObject(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoir::CDummyObject::OnCreate(void* pParam)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoir::CDummyObject::OnInitialize(void* pParam)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoir::CDummyObject::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoir::CDummyObject::OnDestroy(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
IBaseReservoir::IBaseReservoir(void)
{
    m_ActiveObjectHead.m_pReservoir=this;
    m_IdleObjectHead.m_pReservoir=this;
}
///////////////////////////////////////////////////////////////
IBaseReservoir::~IBaseReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
void IBaseReservoir::AppendActiveObject(IBaseReserveObject* pObject)
{
    // ؂藣
    pObject->m_pNext->m_pPrev=pObject->m_pPrev;
    pObject->m_pPrev->m_pNext=pObject->m_pNext;
    // Activeɂ
    pObject->m_pPrev=m_ActiveObjectHead.m_pPrev;
    pObject->m_pNext=&m_ActiveObjectHead;
    pObject->m_pPrev->m_pNext=pObject;
    pObject->m_pNext->m_pPrev=pObject;
}
///////////////////////////////////////////////////////////////
void IBaseReservoir::AppendIdleObject(IBaseReserveObject* pObject)
{
    // ؂藣
    pObject->m_pNext->m_pPrev=pObject->m_pPrev;
    pObject->m_pPrev->m_pNext=pObject->m_pNext;
    // Idleɂ
    pObject->m_pPrev=m_IdleObjectHead.m_pPrev;
    pObject->m_pNext=&m_IdleObjectHead;
    pObject->m_pPrev->m_pNext=pObject;
    pObject->m_pNext->m_pPrev=pObject;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoir::CreateObject(IBaseReserveObject* pObject,void* pParam)
{
    if(!pObject->OnCreate(pParam))
    {
        return false;
    }
    //
    AppendIdleObject(pObject);
    pObject->m_pReservoir=this;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoir::DestroyObject(IBaseReserveObject* pObject)
{
    if(!pObject->OnDestroy())
    {
        return false;
    }
    return true;
}
///////////////////////////////////////////////////////////////
IBaseReserveObject* IBaseReservoir::GetActiveObjectHead(void)
{
    return &m_ActiveObjectHead;
}
///////////////////////////////////////////////////////////////
IBaseReserveObject* IBaseReservoir::GetNewActiveBaseObject(void* pParam)
{
    IBaseReserveObject* pObject=m_IdleObjectHead.m_pNext;
    if(pObject==&m_IdleObjectHead)
    {
        return NULL;
    }
    //
    pObject->m_RefCount=0; // ŃJEg0ɂ
    if(!pObject->OnInitialize(pParam))
    {
        return NULL;
    }
    //
    AppendActiveObject(pObject);
    //
    return pObject;
}
///////////////////////////////////////////////////////////////
IBaseReservoirIterator::IBaseReservoirIterator(void)
{
    m_pObject=NULL;
}
///////////////////////////////////////////////////////////////
IBaseReservoirIterator::~IBaseReservoirIterator(void)
{
    SAFE_RELEASE(m_pObject);
}
///////////////////////////////////////////////////////////////
IBaseReserveObject* IBaseReservoirIterator::GetObject(void)
{
    return m_pObject;
}
///////////////////////////////////////////////////////////////
void IBaseReservoirIterator::SetObject(IBaseReserveObject* pObject)
{
    SAFE_ADDREF(pObject);
    SAFE_RELEASE(m_pObject);
    m_pObject=pObject;
}
///////////////////////////////////////////////////////////////
bool IBaseReservoirIterator::IsEqual(IBaseReserveObject* pObject)
{
    return (m_pObject==pObject)?true:false;
}
///////////////////////////////////////////////////////////////
void IBaseReservoirIterator::GoPrev(void)
{
    if(m_pObject==NULL){return;}
    //
    SetObject(m_pObject->m_pPrev);
}
///////////////////////////////////////////////////////////////
void IBaseReservoirIterator::GoNext(void)
{
    if(m_pObject==NULL){return;}
    //
    SetObject(m_pObject->m_pNext);
}
///////////////////////////////////////////////////////////////
bool IBaseReservoirIterator::IsEnd(void)
{
    if(m_pObject==NULL){return true;}
    //
    return IsEqual(m_pObject->m_pReservoir->GetActiveObjectHead());
}