#pragma once
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CCube8 :public IBaseActorObject
{
friend class CCube8Reservoir;
private:
    // OnCreate(CActorReservoir<>::Initialize)̈
    struct SCreateParam
    {
        Scene::ISceneManager* pManager;
        Renderer::Object::IModel* pModel;
        CGame* pGame;
    };
    // OnInitialize(CActorReservoir<>::GetNewActiveObject)̈
    struct SInitializeParam
    {
        ;
    };
    // CActorReservoir<>::GetNewActiveObjectŎ擾Ƀp[^ݒ
private:
    // external
    CGame* m_pGame;
    // OnCreate/OnDestroy
    Scene::IModelActor* m_pModelActor;
    // OnInitialize/OnKill
    CAttackArea* m_pAttackArea;
    CDefenseArea* m_pDefenseArea;
    //
    Math::Vector3D  m_Position;
    Math::Quaternion m_Direction;
    Math::Vector3D   m_Velocity;
    Math::Quaternion m_Rotation;
    //
    bool m_IsPreKilled;
public:
    CCube8(void);
    ~CCube8(void);
    //
protected:
    bool OnCreate(void* pParam);
    bool OnInitialize(void* pParam);
    bool OnFinalize(void);
    bool OnDestroy(void);
public:
    bool UpdateParam(void);
public:
    bool OnUpdate(void);
    bool OnDraw(void);
public:
    bool OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea);
    bool OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea);
    //
    bool OnKill(void);
public:
    void SetPosition(const Math::Vector3D& Position);
    void SetDirection(const Math::Quaternion& Direction);
    void SetVelocity(const Math::Vector3D& Velocity);
    void SetRotation(const Math::Quaternion& Rotation);
};
///////////////////////////////////////////////////////////////
class CCube8Reservoir :private CActorReservoir<CCube8>
{
private:
    Renderer::Object::IModel* m_pModel;
    CGame* m_pGame;
public:
    CCube8Reservoir(void);
    ~CCube8Reservoir(void);
    //
    bool Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame);
    bool Finalize(void);
    //
    CCube8* GetNewActiveObject(void);
    CReservoirIterator<CCube8> GetActiveObjectIterator(void);
    //
    bool Update(void);
    bool Draw(void);
};