#include "cube4.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CCube8::CCube8(void)
:IBaseActorObject(ACTOR_OBJECT_CUBE8)
{
    m_pGame=NULL;
    //
    m_pModelActor=NULL;
    //
    m_pAttackArea=NULL;
    m_pDefenseArea=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CCube8::~CCube8(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_pModelActor==NULL){return false;}
    //
    m_pGame=pConvParam->pGame;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnInitialize(void* pParam)
{
    // SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=m_pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pDefenseArea=m_pGame->CreateDefenseArea(this);
    if(m_pDefenseArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-2.0f,-2.0f,-2.0f),Math::Vector3D(2.0f,2.0f,2.0f));
    m_pDefenseArea->SetBox(Math::Vector3D(-2.0f,-2.0f,-2.0f),Math::Vector3D(2.0f,2.0f,2.0f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    m_IsPreKilled=false;
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnDestroy(void)
{
    SAFE_RELEASE(m_pModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->RotationQuaternion(m_Direction);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pDefenseArea->TransformReset();
    m_pDefenseArea->RotationQuaternion(m_Direction);
    m_pDefenseArea->Translation(m_Position);
    m_pDefenseArea->TransformUpdate();
    //
    m_pModelActor->TransformReset();
    m_pModelActor->RotationQuaternion(m_Direction);
    m_pModelActor->Translation(m_Position);
    m_pModelActor->TransformUpdate();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnUpdate(void)
{
    if(m_IsPreKilled)
    {
        Kill();
        return true;
    }
    //
    m_Position+=m_Velocity;
    m_Direction.Mul(m_Rotation,m_Direction); // 
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length())); // normalize
    //
    if(!UpdateParam())
    {
        return false;
    }
    // _30.0fꂽ
    if(m_Position.Length()>30.0f)
    {
        m_IsPreKilled=true;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnDraw(void)
{
    m_pModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    IBaseActorObject* pActor=pAttackArea->GetObject();
    switch(pActor->GetObjectType())
    {
    case ACTOR_OBJECT_CUBE:
        m_IsPreKilled=true;
        break;
    default:
        m_IsPreKilled=true;
        break;
    }
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube8::OnKill(void)
{
    CBombEffect* pBombEffect=m_pGame->CreateBombEffect(4.0f);
    if(pBombEffect!=NULL)
    {
        pBombEffect->SetPosition(m_Position);
        pBombEffect->UpdateParam();
    }
    // Cubẽp[^_ɂ
    Math::CRandom* pRandom=m_pGame->GetRandom();
    //
    Math::Quaternion QtTmp;
    // IuWFNgWY̌Zo
    Math::Vector3D VecY;
    Math::Quaternion QtY;
    QtY.Mul(m_Direction,Math::Quaternion(0.0f,1.0f,0.0f,0.0f));
    QtTmp.Conjugate(m_Direction);
    QtY.Mul(QtY,QtTmp);
    VecY=Math::Vector3D(QtY.x,QtY.y,QtY.z);
    VecY.y=0.0f;
    VecY.Normalize();
    // Zx쐬
    Math::Vector3D VelPlus=VecY*0.05f;
    // Z]x쐬
    Math::Quaternion QtRotPlus;
    QtRotPlus=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
    QtRotPlus.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/QtRotPlus.Length())); // normalize
    CCube4* pCube4=m_pGame->CreateCube4();
    if(pCube4!=NULL)
    {
        pCube4->SetPosition(m_Position+VecY*3.0f);//
        pCube4->SetVelocity(m_Velocity+VelPlus);//
        pCube4->SetDirection(m_Direction);
        QtTmp.Mul(QtRotPlus,m_Rotation); //Ȃ
        pCube4->SetRotation(QtTmp); //
        pCube4->UpdateParam();
        
        pCube4=m_pGame->CreateCube4();
        if(pCube4!=NULL)
        {
            pCube4->SetPosition(m_Position+VecY*-3.0f);//
            pCube4->SetVelocity(m_Velocity-VelPlus);//
            pCube4->SetDirection(m_Direction);
            QtRotPlus.Conjugate();
            QtTmp.Mul(QtRotPlus,m_Rotation); //Ȃ
            pCube4->SetRotation(QtTmp); //
            pCube4->UpdateParam();
        }
        
    }
    //
    SAFE_RELEASE(m_pDefenseArea);
    SAFE_RELEASE(m_pAttackArea);
    return true;
}
///////////////////////////////////////////////////////////////
void CCube8::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CCube8::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CCube8::SetVelocity(const Math::Vector3D& Velocity)
{
    m_Velocity=Velocity;
}
///////////////////////////////////////////////////////////////
void CCube8::SetRotation(const Math::Quaternion& Rotation)
{
    m_Rotation=Rotation;
}
///////////////////////////////////////////////////////////////
CCube8Reservoir::CCube8Reservoir(void)
{
    m_pModel=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CCube8Reservoir::~CCube8Reservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube8Reservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pModel=pRender->CreateModelFromFile("cube8.smf");
    if(m_pModel==NULL){return false;}
    //
    CCube8::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    Param.pGame=pGame;
    //
    return CActorReservoir<CCube8>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CCube8Reservoir::Finalize(void)
{
    if(!CActorReservoir<CCube8>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CCube8* CCube8Reservoir::GetNewActiveObject(void)
{
    // CCube8::SInitializeParam Param;
    // Param.pGame=m_pGame;
    //
    return CActorReservoir<CCube8>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CCube8> CCube8Reservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CCube8>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CCube8Reservoir::Update(void)
{
    return CActorReservoir<CCube8>::Update();
}
///////////////////////////////////////////////////////////////
bool CCube8Reservoir::Draw(void)
{
    return CActorReservoir<CCube8>::Draw();
}
///////////////////////////////////////////////////////////////