#include "cube2.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CCube2::CCube2(void)
:IBaseActorObject(ACTOR_OBJECT_CUBE2)
{
    m_pGame=NULL;
    //
    m_pModelActor=NULL;
    //
    m_pAttackArea=NULL;
    m_pDefenseArea=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CCube2::~CCube2(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_pModelActor==NULL){return false;}
    //
    m_pGame=pConvParam->pGame;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnInitialize(void* pParam)
{
    // SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=m_pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pDefenseArea=m_pGame->CreateDefenseArea(this);
    if(m_pDefenseArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-2.0f,-1.0f,-1.0f),Math::Vector3D(2.0f,1.0f,1.0f));
    m_pDefenseArea->SetBox(Math::Vector3D(-2.0f,-1.0f,-1.0f),Math::Vector3D(2.0f,1.0f,1.0f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    m_IsPreKilled=false;
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnDestroy(void)
{
    SAFE_RELEASE(m_pModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->RotationQuaternion(m_Direction);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pDefenseArea->TransformReset();
    m_pDefenseArea->RotationQuaternion(m_Direction);
    m_pDefenseArea->Translation(m_Position);
    m_pDefenseArea->TransformUpdate();
    //
    m_pModelActor->TransformReset();
    m_pModelActor->RotationQuaternion(m_Direction);
    m_pModelActor->Translation(m_Position);
    m_pModelActor->TransformUpdate();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnUpdate(void)
{
    if(m_IsPreKilled)
    {
        Kill();
        return true;
    }
    //
    m_Position+=m_Velocity;
    m_Direction.Mul(m_Rotation,m_Direction); // 
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length())); // normalize
    //
    if(!UpdateParam())
    {
        return false;
    }
    // _30.0fꂽ
    if(m_Position.Length()>30.0f)
    {
        m_IsPreKilled=true;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnDraw(void)
{
    m_pModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    IBaseActorObject* pActor=pAttackArea->GetObject();
    switch(pActor->GetObjectType())
    {
    case ACTOR_OBJECT_CUBE:
        m_IsPreKilled=true;
        break;
    default:
        m_IsPreKilled=true;
        break;
    }
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube2::OnKill(void)
{
    CBombEffect* pBombEffect=m_pGame->CreateBombEffect(2.0f);
    if(pBombEffect!=NULL)
    {
        pBombEffect->SetPosition(m_Position);
        pBombEffect->UpdateParam();
    }
    // Cubẽp[^_ɂ
    Math::CRandom* pRandom=m_pGame->GetRandom();
    //
    Math::Quaternion QtTmp;
    // IuWFNgWX̌Zo
    Math::Vector3D VecX;
    Math::Quaternion QtX;
    QtX.Mul(m_Direction,Math::Quaternion(1.0f,0.0f,0.0f,0.0f));
    QtTmp.Conjugate(m_Direction);
    QtX.Mul(QtX,QtTmp);
    VecX=Math::Vector3D(QtX.x,QtX.y,QtX.z);
    VecX.y=0.0f;
    VecX.Normalize();
    // Zx쐬
    Math::Vector3D VelPlus=VecX*0.05f;
    // Z]x쐬
    Math::Quaternion QtRotPlus;
    QtRotPlus=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
    QtRotPlus.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/QtRotPlus.Length())); // normalize
    CCube* pCube=m_pGame->CreateCube();
    if(pCube!=NULL)
    {
        pCube->SetPosition(m_Position+VecX*1.74f);//
        pCube->SetVelocity(m_Velocity+VelPlus);//
        pCube->SetDirection(m_Direction);
        QtTmp.Mul(QtRotPlus,m_Rotation); //Ȃ
        pCube->SetRotation(QtTmp); //
        pCube->UpdateParam();
        
        pCube=m_pGame->CreateCube();
        if(pCube!=NULL)
        {
            pCube->SetPosition(m_Position+VecX*-1.74f);//
            pCube->SetVelocity(m_Velocity-VelPlus);//
            pCube->SetDirection(m_Direction);
            QtRotPlus.Conjugate();
            QtTmp.Mul(QtRotPlus,m_Rotation); //Ȃ
            pCube->SetRotation(QtTmp); //
            pCube->UpdateParam();
        }
        
    }
    //
    SAFE_RELEASE(m_pDefenseArea);
    SAFE_RELEASE(m_pAttackArea);
    return true;
}
///////////////////////////////////////////////////////////////
void CCube2::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CCube2::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CCube2::SetVelocity(const Math::Vector3D& Velocity)
{
    m_Velocity=Velocity;
}
///////////////////////////////////////////////////////////////
void CCube2::SetRotation(const Math::Quaternion& Rotation)
{
    m_Rotation=Rotation;
}
///////////////////////////////////////////////////////////////
CCube2Reservoir::CCube2Reservoir(void)
{
    m_pModel=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CCube2Reservoir::~CCube2Reservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube2Reservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pModel=pRender->CreateModelFromFile("cube2.smf");
    if(m_pModel==NULL){return false;}
    //
    CCube2::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    Param.pGame=pGame;
    //
    return CActorReservoir<CCube2>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CCube2Reservoir::Finalize(void)
{
    if(!CActorReservoir<CCube2>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CCube2* CCube2Reservoir::GetNewActiveObject(void)
{
    // CCube2::SInitializeParam Param;
    // Param.pGame=m_pGame;
    //
    return CActorReservoir<CCube2>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CCube2> CCube2Reservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CCube2>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CCube2Reservoir::Update(void)
{
    return CActorReservoir<CCube2>::Update();
}
///////////////////////////////////////////////////////////////
bool CCube2Reservoir::Draw(void)
{
    return CActorReservoir<CCube2>::Draw();
}
///////////////////////////////////////////////////////////////