#include "collision.h"
///////////////////////////////////////////////////////////////
CBoundingBox::CBoundingBox(void)
{
    m_pObject=NULL;
    m_IsEnable=false;
    //
    // m_Box
}
///////////////////////////////////////////////////////////////
CBoundingBox::~CBoundingBox(void)
{
    ;
}
///////////////////////////////////////////////////////////////
IBaseActorObject* CBoundingBox::GetObject(void)
{
    return m_pObject;
}
///////////////////////////////////////////////////////////////
void CBoundingBox::SetEnable(bool IsEnable)
{
    m_IsEnable=IsEnable;
}
///////////////////////////////////////////////////////////////
bool CBoundingBox::IsEnable(void)
{
    return m_IsEnable;
}
///////////////////////////////////////////////////////////////
void CBoundingBox::SetBox(const Math::Vector3D& MinPt,const Math::Vector3D& MaxPt)
{
    m_MinPt=MinPt;
    m_MaxPt=MaxPt;
}
///////////////////////////////////////////////////////////////
void CBoundingBox::TransformUpdate(void)
{
    GetTransform(m_Matrix);
}
///////////////////////////////////////////////////////////////
bool CBoundingBox::OnCreate(void* pParam)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CBoundingBox::OnInitialize(void* pParam)
{
    m_pObject=(IBaseActorObject*)pParam;
    SAFE_ADDREF(m_pObject);
    m_IsEnable=true;
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBoundingBox::OnFinalize(void)
{
    SAFE_RELEASE(m_pObject);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CBoundingBox::OnDestroy(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
CCollisionDetector::CCollisionDetector(void)
{
    ;
}
///////////////////////////////////////////////////////////////
CCollisionDetector::~CCollisionDetector(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCollisionDetector::Initialize(int AttackAreaCount,int DefenseAreaCount)
{
    if(!m_AttackAreaReservoir.Initialize(AttackAreaCount,NULL)){return false;}
    if(!m_DefenseAreaReservoir.Initialize(DefenseAreaCount,NULL)){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCollisionDetector::CheckDefense(CAttackArea* pAttackArea,Collision::CBox& AttackBox)
{
    static Collision::CBox DefenseBox;
    //
    CReservoirIterator<CDefenseArea> DefIt=m_DefenseAreaReservoir.GetActiveObjectIterator();
    ++DefIt;
    while(!DefIt.IsEnd())
    {
        if(DefIt.Object()->IsEnable())
        {
            CDefenseArea* pDefenseArea=DefIt.Object();
            //
            if(pAttackArea->m_pObject!=pDefenseArea->m_pObject)
            {
                DefenseBox.CreateBox(pDefenseArea->m_MinPt,pDefenseArea->m_MaxPt,pDefenseArea->m_Matrix);
                //
                if(Collision::Box_Box_3D(AttackBox,DefenseBox))
                {
                    if(!pAttackArea->m_pObject->OnAttack(pAttackArea,pDefenseArea)){return false;}
                    if(!pDefenseArea->m_pObject->OnDefense(pDefenseArea,pAttackArea)){return false;}
                }
            }
        }
        //
        ++DefIt;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCollisionDetector::Check(void)
{
    static Collision::CBox AttackBox;
    //
    CReservoirIterator<CAttackArea> AtkIt=m_AttackAreaReservoir.GetActiveObjectIterator();
    ++AtkIt;
    while(!AtkIt.IsEnd())
    {
        if(AtkIt.Object()->IsEnable())
        {
            CAttackArea* pAttackArea=AtkIt.Object();
            AttackBox.CreateBox(pAttackArea->m_MinPt,pAttackArea->m_MaxPt,pAttackArea->m_Matrix);
            //
            if(!CheckDefense(pAttackArea,AttackBox))
            {
                return false;
            }
        }
        //
        ++AtkIt;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCollisionDetector::DrawCollision(Renderer::Object::ILine3D* pLine,bool IsDrawAttack,bool IsDrawDefense)
{
    static Collision::CBox DrawBox;
    if(IsDrawAttack)
    {
        CReservoirIterator<CAttackArea> AtkIt=m_AttackAreaReservoir.GetActiveObjectIterator();
        ++AtkIt;
        while(!AtkIt.IsEnd())
        {
            if(AtkIt.Object()->IsEnable())
            {
                DrawBox.CreateBox(AtkIt.Object()->m_MinPt,AtkIt.Object()->m_MaxPt,AtkIt.Object()->m_Matrix);
                pLine->PushBox(DrawBox,CColor(255,0,0));
            }
            //
            ++AtkIt;
        }
    }
    //
    if(IsDrawDefense)
    {
        CReservoirIterator<CDefenseArea> DefIt=m_DefenseAreaReservoir.GetActiveObjectIterator();
        ++DefIt;
        while(!DefIt.IsEnd())
        {
            if(DefIt.Object()->IsEnable())
            {
                DrawBox.CreateBox(DefIt.Object()->m_MinPt,DefIt.Object()->m_MaxPt,DefIt.Object()->m_Matrix);
                pLine->PushBox(DrawBox,CColor(0,0,255));
            }
            //
            ++DefIt;
        }
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
CAttackArea* CCollisionDetector::CreateAttackArea(IBaseActorObject* pObject)
{
    return m_AttackAreaReservoir.GetNewActiveObject(pObject);
}
///////////////////////////////////////////////////////////////
CDefenseArea* CCollisionDetector::CreateDefenseArea(IBaseActorObject* pObject)
{
    return m_DefenseAreaReservoir.GetNewActiveObject(pObject);
}
///////////////////////////////////////////////////////////////
bool CCollisionDetector::Finalize(void)
{
    if(!m_AttackAreaReservoir.Finalize()){return false;}
    if(!m_DefenseAreaReservoir.Finalize()){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////