#include "app.h"
///////////////////////////////////////////////////////////////
CApp::CApp(void)
{
    m_pCore=NULL;
    m_pGraphicCard=NULL;
    m_pRender=NULL;
    m_pKeyboard=NULL;
    //
    m_pSceneManager=NULL;
    m_pCamera=NULL;
}
///////////////////////////////////////////////////////////////
CApp::~CApp(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CApp::Initialize(void)
{
    System::Initialize();
    // RA̐ 
    m_pCore=System::CreateCore();
    // 
    if(!m_pCore->Initialize("Hello World",FRAME_RATE_60)){return false;}
    // ^Cgo[ɏ\
    m_pCore->EnableDrawTitleInformation(true);
    // OtBbNJ[h擾
    m_pGraphicCard=m_pCore->CreateGraphicCard(GRAPHIC_CARD_DEFAULT_NO);
    if(m_pGraphicCard==NULL){return false;}
    // EBhE쐬(640x480,WindowMode)
    m_pCore->Start(640,480,true);
    // _[擾
    m_pRender=m_pGraphicCard->CreateRender();
    if(m_pGraphicCard==NULL){return false;}
    m_pRender->SetDrawType(DRAW_TYPE_BLEND); // 
    // L[{[h擾
    m_pKeyboard=m_pCore->GetKeyboard();
    if(m_pKeyboard==NULL){return false;}
    // V[}l[W[𐶐
    m_pSceneManager=m_pRender->CreateSceneManager(1024,true);
    if(m_pSceneManager==NULL){return false;}
    // V[}l[W[̏np[^ݒEXV
    m_pSceneManager->InitParameter_RenderTargetData(NULL,Math::Point2DI(640,480),false);
    m_pSceneManager->InitParameter_Shading(SHADING_TYPE_NORMAL);
    if(!m_pSceneManager->InitParameter_Update()){return false;}
    // J̎擾Eݒ
    m_pCamera=m_pSceneManager->GetCamera();
    if(m_pCamera==NULL){return false;}
    m_pCamera->UpdateProjection(1.0f,1000.0f,DEG_TO_ANGLE(45.0f),640,480);
    //CGamȅ
    CGame::SInitializeParam InitializeParam;
    InitializeParam.pRender=m_pRender;
    InitializeParam.pManager=m_pSceneManager;
    InitializeParam.RandomSeed=m_pCore->GetMultiMediaTime()& 0x7FFFFFFF;
    if(!m_Game.Initialize(&InitializeParam)){return false;} //
    return true;
}
///////////////////////////////////////////////////////////////
bool CApp::Run(void)
{
    Uint64 StartTime;
    Uint64 UpdateTime;
    Uint64 CollisionCheckTime;
    Uint64 DrawTime;
    //
    while(m_pCore->Run())
    {
        StartTime=m_pCore->GetSystemTimer();
        // Update
        if(m_pKeyboard->GetKeyData(SELENE_VK_A)) //
        {
            // Cubẽp[^_ɂ
            Math::CRandom* pRandom=m_Game.GetRandom();
            CCube* pCube=m_Game.CreateCube(); //
            pCube->SetPosition(Math::Vector3D(pRandom->GetFloat(-20.0f,20.0f),0.0f,pRandom->GetFloat(-20.0f,20.0f)));//
            pCube->SetVelocity(Math::Vector3D(pRandom->GetFloat(-0.05f,0.05f),0.0f,pRandom->GetFloat(-0.05f,0.05f)));//
            Math::Quaternion Qt;//
            Qt=Math::Quaternion(pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f));//
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube->SetDirection(Qt);//
            Qt=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube->SetRotation(Qt); //
            pCube->UpdateParam();
        }
        //
        if(m_pKeyboard->GetKeyData(SELENE_VK_S)) //
        {
            // Cube2̃p[^_ɂ
            Math::CRandom* pRandom=m_Game.GetRandom();
            CCube2* pCube2=m_Game.CreateCube2(); //
            pCube2->SetPosition(Math::Vector3D(pRandom->GetFloat(-20.0f,20.0f),0.0f,pRandom->GetFloat(-20.0f,20.0f)));//
            pCube2->SetVelocity(Math::Vector3D(pRandom->GetFloat(-0.05f,0.05f),0.0f,pRandom->GetFloat(-0.05f,0.05f)));//
            Math::Quaternion Qt;//
            Qt=Math::Quaternion(pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f));//
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube2->SetDirection(Qt);//
            Qt=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube2->SetRotation(Qt); //
            pCube2->UpdateParam();
        }
        //
        if(m_pKeyboard->GetKeyData(SELENE_VK_D)) //
        {
            // Cube4̃p[^_ɂ
            Math::CRandom* pRandom=m_Game.GetRandom();
            CCube4* pCube4=m_Game.CreateCube4(); //
            pCube4->SetPosition(Math::Vector3D(pRandom->GetFloat(-20.0f,20.0f),0.0f,pRandom->GetFloat(-20.0f,20.0f)));//
            pCube4->SetVelocity(Math::Vector3D(pRandom->GetFloat(-0.05f,0.05f),0.0f,pRandom->GetFloat(-0.05f,0.05f)));//
            Math::Quaternion Qt;//
            Qt=Math::Quaternion(pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f));//
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube4->SetDirection(Qt);//
            Qt=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube4->SetRotation(Qt); //
            pCube4->UpdateParam();
        }        //
        if(m_pKeyboard->GetKeyData(SELENE_VK_F)) //
        {
            // Cube4̃p[^_ɂ
            Math::CRandom* pRandom=m_Game.GetRandom();
            CCube8* pCube8=m_Game.CreateCube8(); //
            pCube8->SetPosition(Math::Vector3D(pRandom->GetFloat(-20.0f,20.0f),0.0f,pRandom->GetFloat(-20.0f,20.0f)));//
            pCube8->SetVelocity(Math::Vector3D(pRandom->GetFloat(-0.05f,0.05f),0.0f,pRandom->GetFloat(-0.05f,0.05f)));//
            Math::Quaternion Qt;//
            Qt=Math::Quaternion(pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f),pRandom->GetFloat(-1.0f,1.0f));//
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube8->SetDirection(Qt);//
            Qt=Math::Quaternion(pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),pRandom->GetFloat(-0.05f,0.05f),1.0f); //
            Qt.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/Qt.Length())); // normalize
            pCube8->SetRotation(Qt); //
            pCube8->UpdateParam();
        }
        //
        if(m_pKeyboard->GetKeyData(SELENE_VK_1)){m_Game.SetDrawOption(CGame::DRAW_OBJECT);}
        if(m_pKeyboard->GetKeyData(SELENE_VK_2)){m_Game.SetDrawOption(CGame::DRAW_ATTACK);}
        if(m_pKeyboard->GetKeyData(SELENE_VK_3)){m_Game.SetDrawOption(CGame::DRAW_DEFENSE);}
        //
        // Game̍XV
        m_Game.Update();
        // J̈ʒuEp̍XV
        m_pCamera->Reset();
        m_pCamera->SetTransformSimple(Math::Vector3D(0.0f,40.0f,-80.0f),Math::Vector3D(0.0f,0.0f,0.0f),DEG_TO_ANGLE(0.0f));
        m_pCamera->Update();
        //
        UpdateTime=m_pCore->GetSystemTimer();
        // GamȅՓ˔
        m_Game.CheckCollision();
        //
        CollisionCheckTime=m_pCore->GetSystemTimer();
        // V[}l[W[̃Zbg
        m_pSceneManager->Reset();
        m_pSceneManager->SetParameter_BGColor(CColor(128,128,128));
        // V[ɕs𓖂Ă
        m_pSceneManager->SetLightParameter_Directional(Math::Vector3D(0.5f,-0.5f,0.7f),Math::Vector3D(0.8f,0.8f,0.8f));
        // V[}l[W[ւ̃_ONGXg(Ȃ炸J̈ʒup߂Ă)
        m_pSceneManager->Begin(true);
        m_Game.Draw();
        m_pSceneManager->End();
        //
        DrawTime=m_pCore->GetSystemTimer();
        // ʂ̃NA(white)
        m_pRender->Clear(CColor(255,255,255));
        // ʂւ̕`
        m_pRender->Begin();
        m_pSceneManager->Rendering(true);
        m_pRender->DebugPrint(Math::Point2DI(0,0),CColor(0,0,0),
            "Update:%d\nCollision:%d\nDraw:%d",UpdateTime-StartTime,CollisionCheckTime-UpdateTime,DrawTime-CollisionCheckTime);
        m_pRender->End();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
void CApp::Finalize(void)
{
    m_Game.Finalize();
    //
    SAFE_RELEASE(m_pCamera);
    SAFE_RELEASE(m_pSceneManager);
    //
    SAFE_RELEASE(m_pKeyboard);
    SAFE_RELEASE(m_pRender);
    SAFE_RELEASE(m_pGraphicCard);
    SAFE_RELEASE(m_pCore);
    // VXẻ
    System::Finalize();
}
///////////////////////////////////////////////////////////////