#include "app.h"
///////////////////////////////////////////////////////////////
CApp::CApp(void)
{
    m_pCore=NULL;
    m_pGraphicCard=NULL;
    m_pRender=NULL;
    m_pKeyboard=NULL;
    //
    m_pSceneManager=NULL;
    m_pCamera=NULL;
    m_Pos=Math::Vector3D(0.0f,0.0f,0.0f);
    //
    m_pTexture=NULL;
    m_pParticle=NULL;
    m_pActor=NULL;
}
///////////////////////////////////////////////////////////////
CApp::~CApp(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CApp::Initialize(void)
{
    System::Initialize();
    // RA̐ 
    m_pCore=System::CreateCore();
    // 
    if(!m_pCore->Initialize("Hello World",FRAME_RATE_60)){return false;}
    // ^Cgo[ɏ\
    m_pCore->EnableDrawTitleInformation(true);
    // OtBbNJ[h擾
    m_pGraphicCard=m_pCore->CreateGraphicCard(GRAPHIC_CARD_DEFAULT_NO);
    if(m_pGraphicCard==NULL){return false;}
    // EBhE쐬(640x480,WindowMode)
    m_pCore->Start(640,480,true);
    // _[擾
    m_pRender=m_pGraphicCard->CreateRender();
    if(m_pGraphicCard==NULL){return false;}
    m_pRender->SetDrawType(DRAW_TYPE_BLEND); // 
    // L[{[h擾
    m_pKeyboard=m_pCore->GetKeyboard();
    if(m_pKeyboard==NULL){return false;}
    // V[}l[W[𐶐
    m_pSceneManager=m_pRender->CreateSceneManager(128,true);
    if(m_pSceneManager==NULL){return false;}
    // V[}l[W[̏np[^ݒEXV
    m_pSceneManager->InitParameter_RenderTargetData(NULL,Math::Point2DI(640,480),false);
    m_pSceneManager->InitParameter_Shading(SHADING_TYPE_NORMAL);
    if(!m_pSceneManager->InitParameter_Update()){return false;}
    // J̎擾Eݒ
    m_pCamera=m_pSceneManager->GetCamera();
    if(m_pCamera==NULL){return false;}
    m_pCamera->UpdateProjection(1.0f,1000.0f,DEG_TO_ANGLE(45.0f),640,480);
    // eNX`̍쐬
    m_pTexture=m_pRender->CreateTextureFromFile("bomb.png");
    if(m_pTexture==NULL){return false;}
    // p[eBN̍쐬
    m_pParticle=m_pRender->CreateParticle(100,m_pTexture,PARTICLE_TYPE_NORMAL);
    if(m_pParticle==NULL){return false;}
    // Actor̍쐬
    m_pActor=m_pSceneManager->CreateActor(m_pParticle);
    if(m_pActor==NULL){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CApp::Run(void)
{
    while(m_pCore->Run())
    {
        // Update
        if(m_pKeyboard->GetKeyData(SELENE_VK_LEFT)){m_Pos.x-=0.05f;}
        if(m_pKeyboard->GetKeyData(SELENE_VK_RIGHT)){m_Pos.x+=0.05f;}
        if(m_pKeyboard->GetKeyData(SELENE_VK_UP)){m_Pos.z+=0.05f;}
        if(m_pKeyboard->GetKeyData(SELENE_VK_DOWN)){m_Pos.z-=0.05f;}
        // Actor̈ʒuEp̍XV
        m_pParticle->SetBasePosition(Math::Vector3D(0.0f,0.0f,0.0f));
        m_pParticle->Begin();
        m_pParticle->Draw(m_Pos,Math::Point2DF(1.0f,1.0f),Math::Rect2DI(0,0,64,64),CColor(255,255,255));
        m_pParticle->End();
        // J̈ʒuEp̍XV
        m_pCamera->Reset();
        m_pCamera->SetTransformSimple(Math::Vector3D(0.0f,0.0f,-8.0f),Math::Vector3D(0.0f,0.0f,0.0f),DEG_TO_ANGLE(0.0f));
        m_pCamera->Update();
        // V[}l[W[̃Zbg
        m_pSceneManager->Reset();
        m_pSceneManager->SetParameter_BGColor(CColor(128,128,128));
        // V[ɕs𓖂Ă
        m_pSceneManager->SetLightParameter_Directional(Math::Vector3D(0.5f,-0.5f,0.7f),Math::Vector3D(0.8f,0.8f,0.8f));
        // V[}l[W[ւ̃_ONGXg(Ȃ炸J̈ʒup߂Ă)
        m_pSceneManager->Begin(true);
        m_pActor->RenderingRequest();
        m_pSceneManager->End();
        // ʂ̃NA(white)
        m_pRender->Clear(CColor(255,255,255));
        // ʂւ̕`
        m_pRender->Begin();
        m_pSceneManager->Rendering(true);
        m_pRender->DrawText(Math::Point2DI(0,0),CColor(0,0,0),"Pos=[%2.2f,%2.2f,%2.2f];",m_Pos.x,m_Pos.y,m_Pos.z);
        m_pRender->End();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
void CApp::Finalize(void)
{
    SAFE_RELEASE(m_pActor);
    SAFE_RELEASE(m_pParticle);
    SAFE_RELEASE(m_pTexture);
    //
    SAFE_RELEASE(m_pCamera);
    SAFE_RELEASE(m_pSceneManager);
    //
    SAFE_RELEASE(m_pKeyboard);
    SAFE_RELEASE(m_pRender);
    SAFE_RELEASE(m_pGraphicCard);
    SAFE_RELEASE(m_pCore);
    // VXẻ
    System::Finalize();
}
///////////////////////////////////////////////////////////////