#pragma once
#include "preload.h"
#include "actorobject.h"
#include "cube.h"
#include "collision.h"
///////////////////////////////////////////////////////////////
class CGame
{
public:
    struct SInitializeParam
    {
        Renderer::IRender* pRender;
        Scene::ISceneManager* pManager;
    };
    //
    enum eDrawOption
    {
        DRAW_NULL=0x00,
        DRAW_OBJECT=0x01,
        DRAW_ATTACK=0x02,
        DRAW_DEFENSE=0x04,
    };
private:
    Renderer::IRender* m_pRender;
    Scene::ISceneManager* m_pManager;
    //
    Renderer::Object::ILine3D* m_pLine;
    Scene::IPrimitiveActor* m_pLineActor;
    //
    eDrawOption m_DrawOption;
    //
    CCollisionDetector m_Detector;
    //
    CCubeReservoir m_CubeReservoir;
public:
    CGame(void);
    ~CGame(void);
    //
    bool Initialize(SInitializeParam* pParam);
    bool Finalize(void);
    // ͍XVՓ˔聨`̏(IuWFNg̐E폜͂Ȃ炸Updateł)
    bool Update(void);
    bool CheckCollision(void);
    bool Draw(void);
    // h[IvV
    //  DRAW_NULL    ...`Ȃ
    //  DRAW_OBJECT  ...IuWFNg`
    //  DRAW_ATTACK  ...UՓ˃GA`
    //  DRAW_DEFENSE ...hՓ˃GA`
    bool SetDrawOption(eDrawOption Option);
    // Փ˔
    // -̊֐ōASetBox֐AMath::StyleNX̊֐Ńp[^^̂Ɏg
    // -̃NXMath::StylepĂAʒuTransformUpdate֐ŃZbg銴ɂȂĂ
    CAttackArea* CreateAttackArea(IBaseActorObject* pObject);
    CDefenseArea* CreateDefenseArea(IBaseActorObject* pObject);
    //
    // IBaseActorObjecťpNXɂ
    // -\ɏoĂp[^ύXۂɂ͕KUpdateParam֐sƁA
    // -܂UpdateParamƗzp[^ύX͓ɏՓ˔莞(OnAttack,OnDefense),`掞(OnDraw)ɂ͎gȂ
    // -pȂƂȂz֐͈ȉ̂Ƃ
    //  -OnCreate      ... IuWFNg̕ۊǌɂInitialize鎞
    //  -OnInitialize  ... IuWFNg̕ۊǌɂIuWFNgĂ
    //  -OnFinalize    ... IuWFNgQƃJE^OɂȂ
    //                      (IuWFNg̕ۊǌɂȂȂ̃IuWFNg鎞)
    //  -OnDestroy     ... IuWFNg̕ۊǌɂFinalize鎞
    //  -OnKill        ... Kill(QƃJE^0łȂ\)
    //  -OnUpdate      ... XV
    //  -OnDraw        ... `掞
    //  -OnAttack      ... ̍UGÃIuWFNg̖hGAɏՓ˂
    //  -OnDefense     ... ̖hGÃIuWFNg̍UGAɏՓ˂
    //  -UpdateParam   ... ʂɉz֐ɂKvȂǋKi킹Ӗ/p[^̕ύXɎgp邱
    //
    // L[u
    // -̊֐ōASetPositionȂǂ̊֐ŏ^̂Ɏg
    CCube* CreateCube(void);
};