#include "game.h"
///////////////////////////////////////////////////////////////
CGame::CGame(void)
{
    m_pRender=NULL;
    m_pManager=NULL;
    //
    m_pLine=NULL;
    m_pLineActor=NULL;
    //
    m_DrawOption=DRAW_OBJECT;
}
///////////////////////////////////////////////////////////////
CGame::~CGame(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CGame::Initialize(SInitializeParam* pParam)
{
    m_pRender=pParam->pRender;
    m_pManager=pParam->pManager;
    //
    m_pLine=m_pRender->CreateLine3D(1024,true);
    if(m_pLine==NULL){return false;}
    //
    m_pLineActor=m_pManager->CreateActor(m_pLine);
    if(m_pLineActor==NULL){return false;}
    //
    if(!m_Detector.Initialize(200,200)){return false;}
    if(!m_CubeReservoir.Initialize(100,m_pRender,m_pManager,this)){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::Finalize(void)
{
    if(!m_CubeReservoir.Finalize()){return false;}
    if(!m_Detector.Finalize()){return false;}
    //
    SAFE_RELEASE(m_pLineActor);
    SAFE_RELEASE(m_pLine);
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::Update(void)
{
    if(!m_CubeReservoir.Update()){return false;}
    //
    bool Flag[3];
    Flag[0]=(m_DrawOption & DRAW_OBJECT)?true:false;
    Flag[1]=(m_DrawOption & DRAW_ATTACK)?true:false;
    Flag[2]=(m_DrawOption & DRAW_DEFENSE)?true:false;
    //
    if(Flag[1]||Flag[2])
    {
        m_pLine->Begin();
        if(!m_Detector.DrawCollision(m_pLine,Flag[1],Flag[2])){return false;}
        m_pLine->End();
        m_pLineActor->TransformReset();
        m_pLineActor->TransformUpdate();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::CheckCollision(void)
{
    return m_Detector.Check();
}
///////////////////////////////////////////////////////////////
bool CGame::Draw(void)
{
    bool Flag[3];
    Flag[0]=(m_DrawOption & DRAW_OBJECT)?true:false;
    Flag[1]=(m_DrawOption & DRAW_ATTACK)?true:false;
    Flag[2]=(m_DrawOption & DRAW_DEFENSE)?true:false;
    //
    if(Flag[0])
    {
        if(!m_CubeReservoir.Draw()){return false;}
    }
    if(Flag[1]||Flag[2])
    {
        m_pLineActor->RenderingRequest();
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CGame::SetDrawOption(eDrawOption Option)
{
    m_DrawOption=Option;
    return true;
}
///////////////////////////////////////////////////////////////
CAttackArea* CGame::CreateAttackArea(IBaseActorObject* pObject)
{
    return m_Detector.CreateAttackArea(pObject);
}
///////////////////////////////////////////////////////////////
CDefenseArea* CGame::CreateDefenseArea(IBaseActorObject* pObject)
{
    return m_Detector.CreateDefenseArea(pObject);
}
///////////////////////////////////////////////////////////////
CCube* CGame::CreateCube(void)
{
    return m_CubeReservoir.GetNewActiveObject();
}
///////////////////////////////////////////////////////////////