#include "cube.h"
#include "game.h"
///////////////////////////////////////////////////////////////
CCube::CCube(void)
:IBaseActorObject(ACTOR_OBJECT_CUBE)
{
    m_pModelActor=NULL;
    //
    m_pAttackArea=NULL;
    m_pDefenseArea=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CCube::~CCube(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_pModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_pModelActor==NULL){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnInitialize(void* pParam)
{
    SInitializeParam* pConvParam=((SInitializeParam*)pParam);
    // OnKillőΉ
    m_pAttackArea=pConvParam->pGame->CreateAttackArea(this);
    if(m_pAttackArea==NULL){return false;}
    m_pDefenseArea=pConvParam->pGame->CreateDefenseArea(this);
    if(m_pDefenseArea==NULL){return false;}
    m_pAttackArea->SetBox(Math::Vector3D(-1.0f,-1.0f,-1.0f),Math::Vector3D(1.0f,1.0f,1.0f));
    m_pDefenseArea->SetBox(Math::Vector3D(-1.0f,-1.0f,-1.0f),Math::Vector3D(1.0f,1.0f,1.0f));
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    SetKilled(false);
    m_IsPreKilled=false;
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnDestroy(void)
{
    SAFE_RELEASE(m_pModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::UpdateParam(void)
{
    m_pAttackArea->TransformReset();
    m_pAttackArea->RotationQuaternion(m_Direction);
    m_pAttackArea->Translation(m_Position);
    m_pAttackArea->TransformUpdate();
    //
    m_pDefenseArea->TransformReset();
    m_pDefenseArea->RotationQuaternion(m_Direction);
    m_pDefenseArea->Translation(m_Position);
    m_pDefenseArea->TransformUpdate();
    //
    m_pModelActor->TransformReset();
    m_pModelActor->RotationQuaternion(m_Direction);
    m_pModelActor->Translation(m_Position);
    m_pModelActor->TransformUpdate();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnUpdate(void)
{
    if(m_IsPreKilled)
    {
        Kill();
        return true;
    }
    //
    m_Position+=m_Velocity;
    m_Direction.Mul(m_Rotation,m_Direction); // 
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length())); // normalize
    //
    if(!UpdateParam())
    {
        return false;
    }
    // _30.0fꂽ
    if(m_Position.Length()>30.0f)
    {
        m_IsPreKilled=true;
    }
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnDraw(void)
{
    m_pModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnAttack(CAttackArea* pAttackArea,CDefenseArea* pDefenseArea)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnDefense(CDefenseArea* pDefenseArea,CAttackArea* pAttackArea)
{
    IBaseActorObject* pActor=pAttackArea->GetObject();
    switch(pActor->GetObjectType())
    {
    case ACTOR_OBJECT_CUBE:
        m_IsPreKilled=true;
        break;
    default:
        m_IsPreKilled=true;
        break;
    }
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnKill(void)
{
    SAFE_RELEASE(m_pDefenseArea);
    SAFE_RELEASE(m_pAttackArea);
    return true;
}
///////////////////////////////////////////////////////////////
void CCube::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CCube::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CCube::SetVelocity(const Math::Vector3D& Velocity)
{
    m_Velocity=Velocity;
}
///////////////////////////////////////////////////////////////
void CCube::SetRotation(const Math::Quaternion& Rotation)
{
    m_Rotation=Rotation;
}
///////////////////////////////////////////////////////////////
CCubeReservoir::CCubeReservoir(void)
{
    m_pModel=NULL;
    //
    m_pGame=NULL;
}
///////////////////////////////////////////////////////////////
CCubeReservoir::~CCubeReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager,CGame* pGame)
{
    m_pModel=pRender->CreateModelFromFile("cube.smf");
    if(m_pModel==NULL){return false;}
    m_pGame=pGame;
    //
    CCube::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    //
    return CActorReservoir<CCube>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Finalize(void)
{
    if(!CActorReservoir<CCube>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CCube* CCubeReservoir::GetNewActiveObject(void)
{
    CCube::SInitializeParam Param;
    Param.pGame=m_pGame;
    //
    return CActorReservoir<CCube>::GetNewActiveObject(&Param);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CCube> CCubeReservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CCube>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Update(void)
{
    return CActorReservoir<CCube>::Update();
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Draw(void)
{
    return CActorReservoir<CCube>::Draw();
}
///////////////////////////////////////////////////////////////