#pragma once
#include "preload.h"
///////////////////////////////////////////////////////////////
class IBaseReservoir;
class IBaseReservoirIterator;
//
class IBaseReserveObject
{
friend class IBaseReservoir;
friend class IBaseReservoirIterator;
private:
    IBaseReserveObject* m_pPrev;
    IBaseReserveObject* m_pNext;
    //
    IBaseReservoir* m_pReservoir;
    int m_RefCount;
public:
    IBaseReserveObject(void);
    virtual ~IBaseReserveObject(void);
    //
    int AddRef(void);
    void Release(void);
protected:
    virtual bool OnCreate(void* pParam)=0;
    virtual bool OnInitialize(void* pParam)=0;
    virtual bool OnFinalize(void)=0;
    virtual bool OnDestroy(void)=0;
};
//
class IBaseReservoir
{
private:
    class CDummyObject:public IBaseReserveObject
    {
    public:
        CDummyObject(void);
        ~CDummyObject(void);
    protected:
        bool OnCreate(void* pParam);
        bool OnInitialize(void* pParam);
        bool OnFinalize(void);
        bool OnDestroy(void);
    };
    //
    CDummyObject m_ActiveObjectHead;
    CDummyObject m_IdleObjectHead;
public:
    IBaseReservoir(void);
    virtual ~IBaseReservoir(void);
    //
    void AppendActiveObject(IBaseReserveObject* pObject);
    void AppendIdleObject(IBaseReserveObject* pObject);
    //
    bool CreateObject(IBaseReserveObject* pObject,void* pParam);
    bool DestroyObject(IBaseReserveObject* pObject);
    //
    IBaseReserveObject* GetActiveObjectHead(void);
    IBaseReserveObject* GetNewActiveBaseObject(void* pParam);
};
// ̃Ce[^Activê̂QƂȂ
class IBaseReservoirIterator
{
private:
    IBaseReserveObject* m_pObject;
public:
    IBaseReservoirIterator(void);
    virtual ~IBaseReservoirIterator(void);
    //
    IBaseReserveObject* GetObject(void);
    void SetObject(IBaseReserveObject* pObject);
    //
    bool IsEqual(IBaseReserveObject* pObject);
    void GoPrev(void);
    void GoNext(void);
    //
    bool IsEnd(void);
};